/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationContainer;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ModifiersChecker;
import org.jetbrains.jet.lang.resolve.NamespaceFactoryImpl;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WriteThroughScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.DFS;

public class TypeHierarchyResolver {
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private ImportsResolver importsResolver;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptHeaderResolver scriptHeaderResolver;
    @NotNull
    private NamespaceFactoryImpl namespaceFactory;
    @NotNull
    private BindingTrace trace;

    public void setContext(@NotNull TopDownAnalysisContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setContext"));
        }
        this.context = context;
    }

    public void setImportsResolver(@NotNull ImportsResolver importsResolver) {
        if (importsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importsResolver", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setImportsResolver"));
        }
        this.importsResolver = importsResolver;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        if (descriptorResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorResolver", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setDescriptorResolver"));
        }
        this.descriptorResolver = descriptorResolver;
    }

    public void setScriptHeaderResolver(@NotNull ScriptHeaderResolver scriptHeaderResolver) {
        if (scriptHeaderResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptHeaderResolver", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setScriptHeaderResolver"));
        }
        this.scriptHeaderResolver = scriptHeaderResolver;
    }

    public void setNamespaceFactory(@NotNull NamespaceFactoryImpl namespaceFactory) {
        if (namespaceFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceFactory", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setNamespaceFactory"));
        }
        this.namespaceFactory = namespaceFactory;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void process(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "process"));
        }
        LinkedList<JetDeclarationContainer> forDeferredResolve = new LinkedList<JetDeclarationContainer>();
        forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(outerScope, owner, declarations));
        while (!forDeferredResolve.isEmpty()) {
            JetDeclarationContainer declarationContainer = (JetDeclarationContainer)forDeferredResolve.poll();
            assert (declarationContainer != null);
            DeclarationDescriptor descriptorForDeferredResolve = this.context.forDeferredResolver.get(declarationContainer);
            JetScope scope = this.context.normalScope.get(declarationContainer);
            if (descriptorForDeferredResolve instanceof MutableClassDescriptorLite) {
                forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(scope, ((MutableClassDescriptorLite)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            if (descriptorForDeferredResolve instanceof MutablePackageFragmentDescriptor) {
                forDeferredResolve.addAll(this.collectNamespacesAndClassifiers(scope, ((MutablePackageFragmentDescriptor)descriptorForDeferredResolve).getBuilder(), declarationContainer.getDeclarations()));
                continue;
            }
            assert (false);
        }
        this.importsResolver.processTypeImports();
        this.createTypeConstructors();
        this.resolveTypesInClassHeaders();
        this.context.setClassesTopologicalOrder(this.topologicallySortClassesAndObjects());
        this.detectAndDisconnectLoops();
        this.checkSupertypesForConsistency();
        this.checkTypesInClassHeaders();
    }

    @NotNull
    private Collection<JetDeclarationContainer> collectNamespacesAndClassifiers(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Iterable<? extends PsiElement> declarations) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectNamespacesAndClassifiers"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectNamespacesAndClassifiers"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectNamespacesAndClassifiers"));
        }
        ArrayList<JetDeclarationContainer> forDeferredResolve = new ArrayList<JetDeclarationContainer>();
        ClassifierCollector collector = new ClassifierCollector(outerScope, owner, forDeferredResolve);
        for (PsiElement psiElement : declarations) {
            psiElement.accept(collector);
        }
        ArrayList<JetDeclarationContainer> arrayList = forDeferredResolve;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "collectNamespacesAndClassifiers"));
        }
        return arrayList;
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull JetClass jetClass) {
        if (jetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetClass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
        }
        if (jetClass.isTrait()) {
            ClassKind classKind = ClassKind.TRAIT;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
            }
            return classKind;
        }
        if (jetClass.isAnnotation()) {
            ClassKind classKind = ClassKind.ANNOTATION_CLASS;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
            }
            return classKind;
        }
        if (jetClass.isEnum()) {
            ClassKind classKind = ClassKind.ENUM_CLASS;
            if (classKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
            }
            return classKind;
        }
        ClassKind classKind = ClassKind.CLASS;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "getClassKind"));
        }
        return classKind;
    }

    private void createTypeConstructors() {
        for (Map.Entry<JetClassOrObject, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            MutableClassDescriptor descriptor = entry.getValue();
            if (classOrObject instanceof JetClass) {
                this.descriptorResolver.resolveMutableClassDescriptor((JetClass)classOrObject, descriptor, this.trace);
            } else if (classOrObject instanceof JetObjectDeclaration) {
                descriptor.setModality(Modality.FINAL);
                descriptor.setVisibility(ModifiersChecker.resolveVisibilityFromModifiers(classOrObject, ModifiersChecker.getDefaultClassVisibility(descriptor)));
                descriptor.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
            }
            descriptor.createTypeConstructor();
            ClassKind kind = descriptor.getKind();
            if (kind != ClassKind.ENUM_ENTRY && kind != ClassKind.OBJECT && kind != ClassKind.ENUM_CLASS) continue;
            MutableClassDescriptorLite classObject = descriptor.getClassObjectDescriptor();
            assert (classObject != null) : "Enum entries and named objects should have class objects: " + classOrObject.getText();
            JetType supertype = kind == ClassKind.ENUM_CLASS ? KotlinBuiltIns.getInstance().getAnyType() : descriptor.getDefaultType();
            classObject.setSupertypes(Collections.singleton(supertype));
            classObject.createTypeConstructor();
        }
    }

    private void resolveTypesInClassHeaders() {
        for (Map.Entry<JetClassOrObject, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClassOrObject classOrObject = entry.getKey();
            if (!(classOrObject instanceof JetClass)) continue;
            MutableClassDescriptor descriptor = entry.getValue();
            this.descriptorResolver.resolveGenericBounds((JetClass)classOrObject, descriptor.getScopeForSupertypeResolution(), descriptor.getTypeConstructor().getParameters(), this.trace);
        }
        for (Map.Entry<JetClassOrObject, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.descriptorResolver.resolveSupertypesForMutableClassDescriptor(entry.getKey(), entry.getValue(), this.trace);
        }
    }

    private List<MutableClassDescriptorLite> topologicallySortClassesAndObjects() {
        return DFS.topologicalOrder(this.context.getClasses().values(), new DFS.Neighbors<MutableClassDescriptorLite>(){

            @Override
            @NotNull
            public Iterable<MutableClassDescriptorLite> getNeighbors(MutableClassDescriptorLite current) {
                ArrayList<MutableClassDescriptorLite> result = Lists.newArrayList();
                for (JetType supertype : current.getSupertypes()) {
                    ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                    if (!(declarationDescriptor instanceof MutableClassDescriptorLite)) continue;
                    MutableClassDescriptorLite classDescriptor = (MutableClassDescriptorLite)declarationDescriptor;
                    result.add(classDescriptor);
                }
                ArrayList<MutableClassDescriptorLite> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$1", "getNeighbors"));
                }
                return arrayList;
            }
        });
    }

    private void detectAndDisconnectLoops() {
        HashSet<ClassDescriptor> visited = Sets.newHashSet();
        HashSet<ClassDescriptor> beingProcessed = Sets.newHashSet();
        ArrayList<ClassDescriptor> currentPath = Lists.newArrayList();
        for (MutableClassDescriptorLite klass : this.context.getClassesTopologicalOrder()) {
            this.traverseTypeHierarchy(klass, visited, beingProcessed, currentPath);
        }
    }

    private void traverseTypeHierarchy(MutableClassDescriptorLite currentClass, Set<ClassDescriptor> visited, Set<ClassDescriptor> beingProcessed, List<ClassDescriptor> currentPath) {
        if (!visited.add(currentClass)) {
            if (beingProcessed.contains(currentClass)) {
                this.markCycleErrors(currentPath, currentClass);
                assert (!currentPath.isEmpty()) : "Cycle cannot be found on an empty currentPath";
                ClassDescriptor subclassOfCurrent = currentPath.get(currentPath.size() - 1);
                assert (subclassOfCurrent instanceof MutableClassDescriptor);
                Iterator<JetType> iterator2 = ((MutableClassDescriptor)subclassOfCurrent).getSupertypes().iterator();
                while (iterator2.hasNext()) {
                    JetType type = iterator2.next();
                    if (type.getConstructor() != currentClass.getTypeConstructor()) continue;
                    iterator2.remove();
                    break;
                }
            }
            return;
        }
        beingProcessed.add(currentClass);
        currentPath.add(currentClass);
        for (JetType supertype : Lists.newArrayList(currentClass.getSupertypes())) {
            ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof MutableClassDescriptor)) continue;
            MutableClassDescriptor mutableClassDescriptor = (MutableClassDescriptor)declarationDescriptor;
            this.traverseTypeHierarchy(mutableClassDescriptor, visited, beingProcessed, currentPath);
        }
        beingProcessed.remove(currentClass);
        currentPath.remove(currentPath.size() - 1);
    }

    private void markCycleErrors(List<ClassDescriptor> currentPath, @NotNull ClassDescriptor current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver", "markCycleErrors"));
        }
        int size = currentPath.size();
        for (int i = size - 1; i >= 0; --i) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            ClassDescriptor classDescriptor = currentPath.get(i);
            ClassDescriptor superclass = i < size - 1 ? currentPath.get(i + 1) : current;
            PsiElement psiElement = BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor);
            PsiElement elementToMark = null;
            if (psiElement instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)psiElement;
                for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                    JetType supertype;
                    JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = this.trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                this.trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on(elementToMark));
            }
            if (classDescriptor == current) break;
        }
    }

    private void checkSupertypesForConsistency() {
        for (MutableClassDescriptorLite mutableClassDescriptor : this.context.getClassesTopologicalOrder()) {
            Multimap<TypeConstructor, TypeProjection> multimap = SubstitutionUtils.buildDeepSubstitutionMultimap(mutableClassDescriptor.getDefaultType());
            for (Map.Entry<TypeConstructor, Collection<TypeProjection>> entry : multimap.asMap().entrySet()) {
                Collection<TypeProjection> projections = entry.getValue();
                if (projections.size() <= 1) continue;
                TypeConstructor typeConstructor = entry.getKey();
                ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
                assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
                LinkedHashSet<JetType> conflictingTypes = Sets.newLinkedHashSet();
                for (TypeProjection projection : projections) {
                    conflictingTypes.add(projection.getType());
                }
                switch (typeParameterDescriptor.getVariance()) {
                    case INVARIANT: {
                        break;
                    }
                    case IN_VARIANCE: {
                        Filter.REMOVE_IF_SUPERTYPE_IN_THE_SET.proceed(conflictingTypes);
                        break;
                    }
                    case OUT_VARIANCE: {
                        Filter.REMOVE_IF_SUBTYPE_IN_THE_SET.proceed(conflictingTypes);
                    }
                }
                if (conflictingTypes.size() <= 1) continue;
                DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
                assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
                JetClassOrObject psiElement = (JetClassOrObject)BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), mutableClassDescriptor);
                JetDelegationSpecifierList delegationSpecifierList = psiElement.getDelegationSpecifierList();
                assert (delegationSpecifierList != null);
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
            }
        }
    }

    private void checkTypesInClassHeaders() {
        for (JetClassOrObject classOrObject : this.context.getClasses().keySet()) {
            for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                this.checkBoundsForTypeInClassHeader(delegationSpecifier.getTypeReference());
            }
            if (!(classOrObject instanceof JetClass)) continue;
            JetClass jetClass = (JetClass)classOrObject;
            for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
                this.checkBoundsForTypeInClassHeader(jetTypeParameter.getExtendsBound());
            }
            for (JetTypeConstraint constraint : jetClass.getTypeConstraints()) {
                this.checkBoundsForTypeInClassHeader(constraint.getBoundTypeReference());
            }
        }
    }

    private void checkBoundsForTypeInClassHeader(@Nullable JetTypeReference typeReference) {
        JetType type;
        if (typeReference != null && (type = this.trace.getBindingContext().get(BindingContext.TYPE, typeReference)) != null) {
            DescriptorResolver.checkBounds(typeReference, type, this.trace);
        }
    }

    private class ClassifierCollector
    extends JetVisitorVoid {
        private final JetScope outerScope;
        private final NamespaceLikeBuilder owner;
        private final Collection<JetDeclarationContainer> forDeferredResolve;

        public ClassifierCollector(@NotNull JetScope outerScope, @NotNull NamespaceLikeBuilder owner, @NotNull Collection<JetDeclarationContainer> forDeferredResolve) {
            if (outerScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            if (forDeferredResolve == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forDeferredResolve", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "<init>"));
            }
            this.outerScope = outerScope;
            this.owner = owner;
            this.forDeferredResolve = forDeferredResolve;
        }

        @Override
        public void visitJetFile(@NotNull JetFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitJetFile"));
            }
            MutablePackageFragmentDescriptor packageFragment = TypeHierarchyResolver.this.namespaceFactory.createPackageFragmentIfNeeded(file);
            TypeHierarchyResolver.this.context.getPackageFragments().put(file, packageFragment);
            PackageViewDescriptor packageView = packageFragment.getContainingDeclaration().getPackage(packageFragment.getFqName());
            ChainedScope rootPlusPackageScope = new ChainedScope((DeclarationDescriptor)packageView, packageView.getMemberScope(), this.outerScope);
            WriteThroughScope packageScope = new WriteThroughScope(rootPlusPackageScope, packageFragment.getMemberScope(), new TraceBasedRedeclarationHandler(TypeHierarchyResolver.this.trace), "package in file " + file.getName());
            packageScope.changeLockLevel(WritableScope.LockLevel.BOTH);
            TypeHierarchyResolver.this.context.getNamespaceScopes().put(file, packageScope);
            if (file.isScript()) {
                TypeHierarchyResolver.this.scriptHeaderResolver.processScriptHierarchy(file.getScript(), packageScope);
            }
            this.prepareForDeferredCall(packageScope, packageFragment, file);
        }

        @Override
        public void visitClass(@NotNull JetClass klass) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitClass"));
            }
            MutableClassDescriptor mutableClassDescriptor = this.createClassDescriptorForClass(klass, this.owner.getOwnerForChildren());
            this.owner.addClassifierDescriptor(mutableClassDescriptor);
        }

        @Override
        public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitObjectDeclaration"));
            }
            if (declaration.isObjectLiteral()) {
                this.createClassDescriptorForSingleton(declaration, SpecialNames.NO_NAME_PROVIDED, ClassKind.CLASS);
                return;
            }
            MutableClassDescriptor descriptor = this.createClassDescriptorForSingleton(declaration, JetPsiUtil.safeName(declaration.getName()), ClassKind.OBJECT);
            this.owner.addClassifierDescriptor(descriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getUnsafeFQName(declaration), descriptor);
            descriptor.getBuilder().setClassObjectDescriptor(this.createSyntheticClassObject(descriptor));
        }

        @Override
        public void visitEnumEntry(@NotNull JetEnumEntry declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitEnumEntry"));
            }
            MutableClassDescriptor descriptor = this.createClassDescriptorForSingleton(declaration, JetPsiUtil.safeName(declaration.getName()), ClassKind.ENUM_ENTRY);
            this.owner.addClassifierDescriptor(descriptor);
            descriptor.getBuilder().setClassObjectDescriptor(this.createSyntheticClassObject(descriptor));
        }

        @Override
        public void visitTypedef(@NotNull JetTypedef typedef) {
            if (typedef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typedef", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitTypedef"));
            }
            TypeHierarchyResolver.this.trace.report(Errors.UNSUPPORTED.on(typedef, "TypeHierarchyResolver"));
        }

        @Override
        public void visitClassObject(@NotNull JetClassObject classObject) {
            if (classObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "visitClassObject"));
            }
            JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
            if (objectDeclaration == null) {
                return;
            }
            DeclarationDescriptor container = this.owner.getOwnerForChildren();
            MutableClassDescriptor classObjectDescriptor = this.createClassDescriptorForSingleton(objectDeclaration, SpecialNames.getClassObjectName(container.getName()), ClassKind.CLASS_OBJECT);
            NamespaceLikeBuilder.ClassObjectStatus status = DescriptorUtils.isEnumEntry(container) || DescriptorUtils.isObject(container) ? NamespaceLikeBuilder.ClassObjectStatus.NOT_ALLOWED : this.owner.setClassObjectDescriptor(classObjectDescriptor);
            switch (status) {
                case DUPLICATE: {
                    TypeHierarchyResolver.this.trace.report(Errors.MANY_CLASS_OBJECTS.on(classObject));
                    break;
                }
                case NOT_ALLOWED: {
                    TypeHierarchyResolver.this.trace.report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
                    break;
                }
            }
        }

        private void createClassObjectForEnumClass(@NotNull MutableClassDescriptor mutableClassDescriptor) {
            if (mutableClassDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableClassDescriptor", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassObjectForEnumClass"));
            }
            if (mutableClassDescriptor.getKind() == ClassKind.ENUM_CLASS) {
                MutableClassDescriptor classObject = this.createSyntheticClassObject(mutableClassDescriptor);
                mutableClassDescriptor.getBuilder().setClassObjectDescriptor(classObject);
                classObject.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValuesMethod(classObject, TypeHierarchyResolver.this.trace));
                classObject.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValueOfMethod(classObject, TypeHierarchyResolver.this.trace));
            }
        }

        @NotNull
        private MutableClassDescriptor createSyntheticClassObject(@NotNull ClassDescriptor classDescriptor) {
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createSyntheticClassObject"));
            }
            MutableClassDescriptor classObject = new MutableClassDescriptor(classDescriptor, this.outerScope, ClassKind.CLASS_OBJECT, false, SpecialNames.getClassObjectName(classDescriptor.getName()));
            classObject.setModality(Modality.FINAL);
            classObject.setVisibility(DescriptorUtils.getSyntheticClassObjectVisibility());
            classObject.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
            this.createPrimaryConstructorForObject(null, classObject);
            MutableClassDescriptor mutableClassDescriptor = classObject;
            if (mutableClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createSyntheticClassObject"));
            }
            return mutableClassDescriptor;
        }

        @NotNull
        private MutableClassDescriptor createClassDescriptorForClass(@NotNull JetClass klass, @NotNull DeclarationDescriptor containingDeclaration) {
            if (klass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForClass"));
            }
            if (containingDeclaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForClass"));
            }
            ClassKind kind = TypeHierarchyResolver.getClassKind(klass);
            boolean isInner = kind == ClassKind.CLASS && klass.isInner();
            MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(containingDeclaration, this.outerScope, kind, isInner, JetPsiUtil.safeName(klass.getName()));
            TypeHierarchyResolver.this.context.getClasses().put(klass, mutableClassDescriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getUnsafeFQName(klass), mutableClassDescriptor);
            this.createClassObjectForEnumClass(mutableClassDescriptor);
            JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
            this.prepareForDeferredCall(classScope, mutableClassDescriptor, klass);
            MutableClassDescriptor mutableClassDescriptor2 = mutableClassDescriptor;
            if (mutableClassDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForClass"));
            }
            return mutableClassDescriptor2;
        }

        @NotNull
        private MutableClassDescriptor createClassDescriptorForSingleton(@NotNull JetClassOrObject declaration, @NotNull Name name, @NotNull ClassKind kind) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            MutableClassDescriptor descriptor = new MutableClassDescriptor(this.owner.getOwnerForChildren(), this.outerScope, kind, false, name);
            this.prepareForDeferredCall(descriptor.getScopeForMemberResolution(), descriptor, declaration);
            this.createPrimaryConstructorForObject(declaration, descriptor);
            TypeHierarchyResolver.this.trace.record(BindingContext.CLASS, declaration, descriptor);
            TypeHierarchyResolver.this.context.getClasses().put(declaration, descriptor);
            MutableClassDescriptor mutableClassDescriptor = descriptor;
            if (mutableClassDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createClassDescriptorForSingleton"));
            }
            return mutableClassDescriptor;
        }

        @NotNull
        private ConstructorDescriptorImpl createPrimaryConstructorForObject(@Nullable PsiElement object2, @NotNull MutableClassDescriptor mutableClassDescriptor) {
            if (mutableClassDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutableClassDescriptor", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createPrimaryConstructorForObject"));
            }
            ConstructorDescriptorImpl constructorDescriptor = DescriptorResolver.createAndRecordPrimaryConstructorForObject(object2, mutableClassDescriptor, TypeHierarchyResolver.this.trace);
            mutableClassDescriptor.setPrimaryConstructor(constructorDescriptor);
            ConstructorDescriptorImpl constructorDescriptorImpl = constructorDescriptor;
            if (constructorDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "createPrimaryConstructorForObject"));
            }
            return constructorDescriptorImpl;
        }

        private void prepareForDeferredCall(@NotNull JetScope outerScope, @NotNull DeclarationDescriptor descriptorForDeferredResolve, @NotNull JetDeclarationContainer container) {
            if (outerScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "prepareForDeferredCall"));
            }
            if (descriptorForDeferredResolve == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorForDeferredResolve", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "prepareForDeferredCall"));
            }
            if (container == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/TypeHierarchyResolver$ClassifierCollector", "prepareForDeferredCall"));
            }
            this.forDeferredResolve.add(container);
            ((TypeHierarchyResolver)TypeHierarchyResolver.this).context.normalScope.put(container, outerScope);
            ((TypeHierarchyResolver)TypeHierarchyResolver.this).context.forDeferredResolver.put(container, descriptorForDeferredResolve);
        }
    }

    private static enum Filter {
        REMOVE_IF_SUBTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(other, subject);
            }
        }
        ,
        REMOVE_IF_SUPERTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(subject, other);
            }
        };


        private void proceed(Set<JetType> conflictingTypes) {
            Iterator<JetType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                JetType type = iterator2.next();
                for (JetType otherType : conflictingTypes) {
                    boolean subtypeOf = this.removeNeeded(type, otherType);
                    if (type == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        public abstract boolean removeNeeded(JetType var1, JetType var2);
    }
}

