/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.parsing.JetScriptDefinition;
import org.jetbrains.jet.lang.parsing.JetScriptDefinitionProvider;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.NamespaceFactory;
import org.jetbrains.jet.lang.resolve.ScriptNameUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.ref.JetTypeName;

public class ScriptHeaderResolver {
    public static final Key<Integer> PRIORITY_KEY = Key.create(JetScript.class.getName() + ".priority");
    @NotNull
    private NamespaceFactory namespaceFactory;
    @NotNull
    private DependencyClassByQualifiedNameResolver dependencyClassByQualifiedNameResolver;
    @NotNull
    private TopDownAnalysisContext context;
    @NotNull
    private BindingTrace trace;
    @NotNull
    private TopDownAnalysisParameters topDownAnalysisParameters;

    public void setNamespaceFactory(@NotNull NamespaceFactory namespaceFactory) {
        if (namespaceFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceFactory", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setNamespaceFactory"));
        }
        this.namespaceFactory = namespaceFactory;
    }

    public void setDependencyClassByQualifiedNameResolver(@NotNull DependencyClassByQualifiedNameResolver dependencyClassByQualifiedNameResolver) {
        if (dependencyClassByQualifiedNameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyClassByQualifiedNameResolver", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setDependencyClassByQualifiedNameResolver"));
        }
        this.dependencyClassByQualifiedNameResolver = dependencyClassByQualifiedNameResolver;
    }

    public void setContext(@NotNull TopDownAnalysisContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setContext"));
        }
        this.context = context;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setTrace"));
        }
        this.trace = trace;
    }

    public void setTopDownAnalysisParameters(@NotNull TopDownAnalysisParameters topDownAnalysisParameters) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "setTopDownAnalysisParameters"));
        }
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    @NotNull
    private ClassDescriptor resolveClass(@NotNull FqName className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveClass"));
        }
        ClassDescriptor classDescriptor = this.dependencyClassByQualifiedNameResolver.resolveClass(className);
        if (classDescriptor == null) {
            throw new IllegalStateException("dependency class not found by name: " + className);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveClass"));
        }
        return classDescriptor2;
    }

    @NotNull
    public JetType resolveTypeName(@NotNull JetTypeName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveTypeName"));
        }
        ArrayList<JetType> typeArguments = new ArrayList<JetType>();
        for (JetTypeName typeArgumentName : typeName.getArguments()) {
            typeArguments.add(this.resolveTypeName(typeArgumentName));
        }
        ClassDescriptor classDescriptor = this.resolveClass(typeName.getClassName());
        JetType jetType = TypeUtils.substituteParameters(classDescriptor, typeArguments);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveTypeName"));
        }
        return jetType;
    }

    @NotNull
    private ValueParameterDescriptor resolveScriptParameter(@NotNull AnalyzerScriptParameter scriptParameter, int index, @NotNull ScriptDescriptor script) {
        if (scriptParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameter", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveScriptParameter"));
        }
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveScriptParameter"));
        }
        JetType type = this.resolveTypeName(scriptParameter.getType());
        ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(script, index, Collections.<AnnotationDescriptor>emptyList(), scriptParameter.getName(), type, false, null);
        if (valueParameterDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "resolveScriptParameter"));
        }
        return valueParameterDescriptorImpl;
    }

    public void processScriptHierarchy(@NotNull JetScript script, @NotNull JetScope outerScope) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/ScriptHeaderResolver", "processScriptHierarchy"));
        }
        JetFile file = (JetFile)script.getContainingFile();
        JetNamespaceHeader namespaceHeader = file.getNamespaceHeader();
        FqName fqName = namespaceHeader != null ? new FqName(namespaceHeader.getQualifiedName()) : FqName.ROOT;
        PackageFragmentDescriptor ns = this.namespaceFactory.createNamespaceDescriptorPathIfNeeded(fqName);
        Integer priority = script.getUserData(PRIORITY_KEY);
        if (priority == null) {
            priority = 0;
        }
        Name className = new FqName(ScriptNameUtil.classNameForScript((JetFile)script.getContainingFile()).replace('/', '.')).shortName();
        ScriptDescriptor scriptDescriptor = new ScriptDescriptor(ns, priority, outerScope, className);
        WritableScopeImpl scriptScope = new WritableScopeImpl(outerScope, scriptDescriptor, RedeclarationHandler.DO_NOTHING, "script");
        scriptScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.context.getScriptScopes().put(script, scriptScope);
        this.context.getScripts().put(script, scriptDescriptor);
        this.trace.record(BindingContext.SCRIPT, script, scriptDescriptor);
        ((WritableScope)outerScope).addClassifierDescriptor(scriptDescriptor.getClassDescriptor());
    }

    public void resolveScriptDeclarations() {
        for (Map.Entry<JetScript, ScriptDescriptor> e : this.context.getScripts().entrySet()) {
            JetScript declaration = e.getKey();
            ScriptDescriptor descriptor = e.getValue();
            WritableScope scope = this.context.getScriptScopes().get(declaration);
            ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
            scope.setImplicitReceiver(descriptor.getThisAsReceiverParameter());
            JetFile file = (JetFile)declaration.getContainingFile();
            JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition(file);
            int index = 0;
            List<AnalyzerScriptParameter> scriptParameters = !scriptDefinition.getScriptParameters().isEmpty() ? scriptDefinition.getScriptParameters() : this.topDownAnalysisParameters.getScriptParameters();
            for (AnalyzerScriptParameter scriptParameter : scriptParameters) {
                ValueParameterDescriptor parameter = this.resolveScriptParameter(scriptParameter, index, descriptor);
                valueParameters.add(parameter);
                scope.addVariableDescriptor(parameter);
                ++index;
            }
            descriptor.setValueParameters(valueParameters);
        }
    }
}

