/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverloadUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class OverloadResolver {
    private TopDownAnalysisContext context;
    private BindingTrace trace;

    public void setContext(TopDownAnalysisContext context) {
        this.context = context;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void process() {
        this.checkOverloads();
    }

    private void checkOverloads() {
        MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses = MultiMap.create();
        MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages = MultiMap.create();
        this.fillGroupedConstructors(inClasses, inPackages);
        for (Map.Entry<JetClassOrObject, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), entry.getKey(), inClasses.get(entry.getValue()));
        }
        this.checkOverloadsInPackages(inPackages);
    }

    private void fillGroupedConstructors(@NotNull MultiMap<ClassDescriptor, ConstructorDescriptor> inClasses, @NotNull MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages) {
        if (inClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inClasses", "org/jetbrains/jet/lang/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        if (inPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inPackages", "org/jetbrains/jet/lang/resolve/OverloadResolver", "fillGroupedConstructors"));
        }
        for (MutableClassDescriptor klass : this.context.getClasses().values()) {
            if (klass.getKind().isSingleton()) continue;
            DeclarationDescriptor containingDeclaration = klass.getContainingDeclaration();
            if (containingDeclaration instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                inClasses.put(classDescriptor, klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof PackageFragmentDescriptor) {
                inPackages.put(DescriptorUtils.getFqName(klass), klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof FunctionDescriptor) continue;
            throw new IllegalStateException();
        }
    }

    private void checkOverloadsInPackages(MultiMap<FqNameUnsafe, ConstructorDescriptor> inPackages) {
        MultiMap<FqNameUnsafe, CallableMemberDescriptor> functionsByName = MultiMap.create();
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : this.context.getFunctions().values()) {
            if (!(simpleFunctionDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            functionsByName.putValue(DescriptorUtils.getFqName(simpleFunctionDescriptor), simpleFunctionDescriptor);
        }
        for (PropertyDescriptor propertyDescriptor : this.context.getProperties().values()) {
            if (!(propertyDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            functionsByName.putValue(DescriptorUtils.getFqName(propertyDescriptor), propertyDescriptor);
        }
        for (Map.Entry entry : inPackages.entrySet()) {
            functionsByName.putValues((FqNameUnsafe)entry.getKey(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((Collection)entry.getValue(), ((FqNameUnsafe)entry.getKey()).parent().asString());
        }
    }

    private static String nameForErrorMessage(ClassDescriptor classDescriptor, JetClassOrObject jetClass) {
        String name = jetClass.getName();
        if (name != null) {
            return name;
        }
        if (jetClass instanceof JetObjectDeclaration) {
            name = classDescriptor.getContainingDeclaration().getName().asString();
            return "class object " + name;
        }
        return "<unknown>";
    }

    private void checkOverloadsInAClass(MutableClassDescriptor classDescriptor, JetClassOrObject klass, Collection<ConstructorDescriptor> nestedClassConstructors) {
        MultiMap<Name, CallableMemberDescriptor> functionsByName = MultiMap.create();
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            MutableClassDescriptor classObjectDescriptor = (MutableClassDescriptor)classDescriptor.getClassObjectDescriptor();
            assert (classObjectDescriptor != null);
            for (CallableMemberDescriptor memberDescriptor : classObjectDescriptor.getDeclaredCallableMembers()) {
                functionsByName.putValue(memberDescriptor.getName(), memberDescriptor);
            }
        }
        for (CallableMemberDescriptor callableMemberDescriptor : classDescriptor.getDeclaredCallableMembers()) {
            functionsByName.putValue(callableMemberDescriptor.getName(), callableMemberDescriptor);
        }
        for (ConstructorDescriptor constructorDescriptor : nestedClassConstructors) {
            functionsByName.putValue(constructorDescriptor.getContainingDeclaration().getName(), constructorDescriptor);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((Collection)entry.getValue(), OverloadResolver.nameForErrorMessage(classDescriptor, klass));
        }
    }

    private void checkOverloadsWithSameName(Collection<CallableMemberDescriptor> functions, @NotNull String functionContainer) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/jet/lang/resolve/OverloadResolver", "checkOverloadsWithSameName"));
        }
        if (functions.size() == 1) {
            return;
        }
        Set<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations = this.findRedeclarations(functions);
        this.reportRedeclarations(functionContainer, redeclarations);
    }

    @NotNull
    private Set<Pair<JetDeclaration, CallableMemberDescriptor>> findRedeclarations(@NotNull Collection<CallableMemberDescriptor> functions) {
        if (functions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/lang/resolve/OverloadResolver", "findRedeclarations"));
        }
        HashSet<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations = Sets.newHashSet();
        for (CallableMemberDescriptor member : functions) {
            for (CallableMemberDescriptor member2 : functions) {
                JetDeclaration jetDeclaration;
                OverloadUtil.OverloadCompatibilityInfo overloadable;
                if (member == member2 || (overloadable = OverloadUtil.isOverloadable(member, member2)).isSuccess() || (jetDeclaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(this.trace.getBindingContext(), member)) == null) continue;
                redeclarations.add(Pair.create(jetDeclaration, member));
            }
        }
        HashSet<Pair<JetDeclaration, CallableMemberDescriptor>> hashSet = redeclarations;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/OverloadResolver", "findRedeclarations"));
        }
        return hashSet;
    }

    private void reportRedeclarations(@NotNull String functionContainer, @NotNull Set<Pair<JetDeclaration, CallableMemberDescriptor>> redeclarations) {
        if (functionContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionContainer", "org/jetbrains/jet/lang/resolve/OverloadResolver", "reportRedeclarations"));
        }
        if (redeclarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarations", "org/jetbrains/jet/lang/resolve/OverloadResolver", "reportRedeclarations"));
        }
        for (Pair<JetDeclaration, CallableMemberDescriptor> redeclaration : redeclarations) {
            CallableMemberDescriptor memberDescriptor = redeclaration.getSecond();
            JetDeclaration jetDeclaration = redeclaration.getFirst();
            if (memberDescriptor instanceof PropertyDescriptor) {
                this.trace.report(Errors.REDECLARATION.on(jetDeclaration, memberDescriptor.getName().asString()));
                continue;
            }
            this.trace.report(Errors.CONFLICTING_OVERLOADS.on(jetDeclaration, memberDescriptor, functionContainer));
        }
    }
}

