/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.MutablePackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.NamespaceFactory;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class NamespaceFactoryImpl
implements NamespaceFactory {
    private ModuleDescriptorImpl module;
    private MutablePackageFragmentProvider packageFragmentProvider;
    private BindingTrace trace;

    public void setModule(ModuleDescriptorImpl module) {
        this.module = module;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setPackageFragmentProvider(MutablePackageFragmentProvider packageFragmentProvider) {
        this.packageFragmentProvider = packageFragmentProvider;
    }

    @NotNull
    public MutablePackageFragmentDescriptor createPackageFragmentIfNeeded(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createPackageFragmentIfNeeded"));
        }
        JetNamespaceHeader namespaceHeader = file.getNamespaceHeader();
        assert (namespaceHeader != null) : "scripts are not supported";
        MutablePackageFragmentDescriptor fragment = this.packageFragmentProvider.getOrCreateFragment(namespaceHeader.getFqName());
        for (JetSimpleNameExpression nameExpression : namespaceHeader.getNamespaceNames()) {
            FqName fqName = namespaceHeader.getFqName(nameExpression);
            PackageViewDescriptor packageView = this.module.getPackage(fqName);
            assert (packageView != null) : "package not found: " + fqName;
            this.trace.record(BindingContext.REFERENCE_TARGET, nameExpression, packageView);
            PackageViewDescriptor parentPackageView = packageView.getContainingDeclaration();
            assert (parentPackageView != null) : "package has no parent: " + packageView;
            this.trace.record(BindingContext.RESOLUTION_SCOPE, nameExpression, parentPackageView.getMemberScope());
        }
        this.storeBindingForFile(file, fragment);
        MutablePackageFragmentDescriptor mutablePackageFragmentDescriptor = fragment;
        if (mutablePackageFragmentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createPackageFragmentIfNeeded"));
        }
        return mutablePackageFragmentDescriptor;
    }

    @Override
    @NotNull
    public PackageFragmentDescriptor createNamespaceDescriptorPathIfNeeded(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        MutablePackageFragmentDescriptor mutablePackageFragmentDescriptor = this.packageFragmentProvider.getOrCreateFragment(fqName);
        if (mutablePackageFragmentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "createNamespaceDescriptorPathIfNeeded"));
        }
        return mutablePackageFragmentDescriptor;
    }

    private void storeBindingForFile(@NotNull JetFile file, @NotNull PackageFragmentDescriptor fragment) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "storeBindingForFile"));
        }
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "org/jetbrains/jet/lang/resolve/NamespaceFactoryImpl", "storeBindingForFile"));
        }
        this.trace.record(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file, fragment);
        FqName fqName = fragment.getFqName();
        Collection<JetFile> files = this.trace.get(BindingContext.PACKAGE_TO_FILES, fqName);
        if (files == null) {
            files = Sets.newIdentityHashSet();
        }
        files.add(file);
        this.trace.record(BindingContext.PACKAGE_TO_FILES, fqName, files);
    }
}

