/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.FilteringScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.DescriptorSubstitutor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DescriptorUtils {
    private DescriptorUtils() {
    }

    @NotNull
    public static <D extends CallableDescriptor> D substituteBounds(@NotNull D functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "substituteBounds"));
        }
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getTypeParameters();
        if (typeParameters.isEmpty()) {
            D d = functionDescriptor;
            if (d == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "substituteBounds"));
            }
            return d;
        }
        CallableDescriptor substitutedFunction = functionDescriptor.substitute(DescriptorSubstitutor.createUpperBoundsSubstitutor(typeParameters));
        assert (substitutedFunction != null) : "Substituting upper bounds should always be legal";
        CallableDescriptor callableDescriptor = substitutedFunction;
        if (callableDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "substituteBounds"));
        }
        return (D)callableDescriptor;
    }

    @NotNull
    public static Modality convertModality(@NotNull Modality modality, boolean makeNonAbstract) {
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "convertModality"));
        }
        if (makeNonAbstract && modality == Modality.ABSTRACT) {
            Modality modality2 = Modality.OPEN;
            if (modality2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "convertModality"));
            }
            return modality2;
        }
        Modality modality3 = modality;
        if (modality3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "convertModality"));
        }
        return modality3;
    }

    @Nullable
    public static ReceiverParameterDescriptor getExpectedThisObjectIfNeeded(@NotNull DeclarationDescriptor containingDeclaration) {
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getExpectedThisObjectIfNeeded"));
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            return classDescriptor.getThisAsReceiverParameter();
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            ScriptDescriptor scriptDescriptor = (ScriptDescriptor)containingDeclaration;
            return scriptDescriptor.getThisAsReceiverParameter();
        }
        return ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER;
    }

    public static boolean isLocal(DeclarationDescriptor containerOfTheCurrentLocality, DeclarationDescriptor candidate) {
        if (candidate instanceof ValueParameterDescriptor) {
            return true;
        }
        DeclarationDescriptor parent = candidate.getContainingDeclaration();
        if (!(parent instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)parent;
        for (DeclarationDescriptor current = containerOfTheCurrentLocality; current != null; current = current.getContainingDeclaration()) {
            if (current != functionDescriptor) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static FqNameUnsafe getFqName(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqName"));
        }
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor);
        FqNameUnsafe fqNameUnsafe = safe != null ? safe.toUnsafe() : DescriptorUtils.getFqNameUnsafe(descriptor);
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqName"));
        }
        return fqNameUnsafe;
    }

    @NotNull
    public static FqName getFqNameSafe(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameSafe"));
        }
        FqName safe = DescriptorUtils.getFqNameSafeIfPossible(descriptor);
        FqName fqName = safe != null ? safe : DescriptorUtils.getFqNameUnsafe(descriptor).toSafe();
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameSafe"));
        }
        return fqName;
    }

    @Nullable
    private static FqName getFqNameSafeIfPossible(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameSafeIfPossible"));
        }
        if (descriptor instanceof ModuleDescriptor || ErrorUtils.isError(descriptor)) {
            return FqName.ROOT;
        }
        if (descriptor instanceof PackageViewDescriptor) {
            return ((PackageViewDescriptor)descriptor).getFqName();
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            return ((PackageFragmentDescriptor)descriptor).getFqName();
        }
        return null;
    }

    @NotNull
    private static FqNameUnsafe getFqNameUnsafe(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameUnsafe"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.CLASS_OBJECT) {
            DeclarationDescriptor classOfClassObject = containingDeclaration.getContainingDeclaration();
            assert (classOfClassObject != null);
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classOfClassObject).child(descriptor.getName());
            if (fqNameUnsafe == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameUnsafe"));
            }
            return fqNameUnsafe;
        }
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(containingDeclaration).child(descriptor.getName());
        if (fqNameUnsafe == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getFqNameUnsafe"));
        }
        return fqNameUnsafe;
    }

    public static boolean isTopLevelDeclaration(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isTopLevelDeclaration"));
        }
        return descriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean areInSameModule(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "areInSameModule"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "areInSameModule"));
        }
        ModuleDescriptor parentModule = DescriptorUtils.getParentOfType(first, ModuleDescriptor.class, false);
        ModuleDescriptor fromModule = DescriptorUtils.getParentOfType(second, ModuleDescriptor.class, false);
        assert (parentModule != null && fromModule != null);
        return parentModule.equals(fromModule);
    }

    @Nullable
    public static DeclarationDescriptor findTopLevelParent(@NotNull DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "findTopLevelParent"));
        }
        DeclarationDescriptor descriptor = declarationDescriptor;
        if (declarationDescriptor instanceof PropertyAccessorDescriptor) {
            descriptor = ((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty();
        }
        while (descriptor != null && !DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            descriptor = descriptor.getContainingDeclaration();
        }
        return descriptor;
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getParentOfType"));
        }
        return DescriptorUtils.getParentOfType(descriptor, aClass, true);
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getParentOfType(@Nullable DeclarationDescriptor descriptor, @NotNull Class<D> aClass, boolean strict) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getParentOfType"));
        }
        if (descriptor == null) {
            return null;
        }
        if (strict) {
            descriptor = descriptor.getContainingDeclaration();
        }
        while (descriptor != null) {
            if (aClass.isInstance(descriptor)) {
                return (D)descriptor;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return null;
    }

    public static boolean isAncestor(@Nullable DeclarationDescriptor ancestor, @NotNull DeclarationDescriptor declarationDescriptor, boolean strict) {
        DeclarationDescriptor descriptor;
        if (declarationDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isAncestor"));
        }
        if (ancestor == null) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor = strict ? declarationDescriptor.getContainingDeclaration() : declarationDescriptor;
        while (descriptor != null) {
            if (ancestor == descriptor) {
                return true;
            }
            descriptor = descriptor.getContainingDeclaration();
        }
        return false;
    }

    public static boolean isSubclass(@NotNull ClassDescriptor subClass, @NotNull ClassDescriptor superClass) {
        if (subClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubclass"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubclass"));
        }
        return DescriptorUtils.isSubtypeOfClass(subClass.getDefaultType(), superClass.getOriginal());
    }

    private static boolean isSubtypeOfClass(@NotNull JetType type, @NotNull DeclarationDescriptor superClass) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubtypeOfClass"));
        }
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSubtypeOfClass"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor != null && superClass == descriptor.getOriginal()) {
            return true;
        }
        for (JetType superType : type.getConstructor().getSupertypes()) {
            if (!DescriptorUtils.isSubtypeOfClass(superType, superClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFunctionLiteral(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isFunctionLiteral"));
        }
        return descriptor instanceof AnonymousFunctionDescriptor;
    }

    public static boolean isClassObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isClassObject"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.CLASS_OBJECT);
    }

    public static boolean isAnonymousObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isAnonymousObject"));
        }
        return DescriptorUtils.isClass(descriptor) && descriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isObject(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isObject"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.OBJECT);
    }

    public static boolean isEnumEntry(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isEnumEntry"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ENUM_ENTRY);
    }

    public static boolean isSingleton(@Nullable DeclarationDescriptor classifier) {
        if (classifier instanceof ClassDescriptor) {
            ClassDescriptor clazz = (ClassDescriptor)classifier;
            return clazz.getKind().isSingleton();
        }
        return false;
    }

    public static boolean isEnumClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isEnumClass"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(@Nullable DeclarationDescriptor descriptor) {
        return DescriptorUtils.isKindOf(descriptor, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isTrait(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isTrait"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.TRAIT);
    }

    public static boolean isClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isClass"));
        }
        return DescriptorUtils.isKindOf(descriptor, ClassKind.CLASS);
    }

    public static boolean isKindOf(@Nullable DeclarationDescriptor descriptor, @NotNull ClassKind classKind) {
        if (classKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classKind", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isKindOf"));
        }
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() == classKind;
    }

    @NotNull
    public static List<ClassDescriptor> getSuperclassDescriptors(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSuperclassDescriptors"));
        }
        Collection<JetType> superclassTypes = classDescriptor.getTypeConstructor().getSupertypes();
        ArrayList<ClassDescriptor> superClassDescriptors = new ArrayList<ClassDescriptor>();
        for (JetType type : superclassTypes) {
            ClassDescriptor result = DescriptorUtils.getClassDescriptorForType(type);
            if (DescriptorUtils.isAny(result)) continue;
            superClassDescriptors.add(result);
        }
        ArrayList<ClassDescriptor> arrayList = superClassDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSuperclassDescriptors"));
        }
        return arrayList;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForType"));
        }
        ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForTypeConstructor(type.getConstructor());
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForType"));
        }
        return classDescriptor;
    }

    @NotNull
    public static ClassDescriptor getClassDescriptorForTypeConstructor(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForTypeConstructor"));
        }
        ClassifierDescriptor descriptor = typeConstructor.getDeclarationDescriptor();
        assert (descriptor instanceof ClassDescriptor) : "Classifier descriptor of a type should be of type ClassDescriptor: " + typeConstructor;
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getClassDescriptorForTypeConstructor"));
        }
        return classDescriptor;
    }

    public static boolean isAny(@NotNull DeclarationDescriptor superClassDescriptor) {
        if (superClassDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isAny"));
        }
        return superClassDescriptor.equals(KotlinBuiltIns.getInstance().getAny());
    }

    public static boolean inStaticContext(@NotNull DeclarationDescriptor descriptor) {
        ClassDescriptor classDescriptor;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "inStaticContext"));
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            return true;
        }
        if (containingDeclaration instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)containingDeclaration).getKind().isSingleton()) {
            return DescriptorUtils.inStaticContext(classDescriptor.getContainingDeclaration());
        }
        return false;
    }

    public static boolean isEnumClassObject(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containing;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isEnumClassObject"));
        }
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() == ClassKind.CLASS_OBJECT && (containing = descriptor.getContainingDeclaration()) instanceof ClassDescriptor && ((ClassDescriptor)containing).getKind() == ClassKind.ENUM_CLASS;
    }

    public static boolean isSyntheticClassObject(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containing;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isSyntheticClassObject"));
        }
        if (DescriptorUtils.isClassObject(descriptor) && (containing = descriptor.getContainingDeclaration()) != null) {
            return DescriptorUtils.isEnumClass(containing) || DescriptorUtils.isObject(containing) || DescriptorUtils.isEnumEntry(containing);
        }
        return false;
    }

    @NotNull
    public static Visibility getDefaultConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
        }
        ClassKind classKind = classDescriptor.getKind();
        if (classKind == ClassKind.ENUM_CLASS || classKind.isSingleton() || DescriptorUtils.isAnonymousObject(classDescriptor)) {
            Visibility visibility = Visibilities.PRIVATE;
            if (visibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
            }
            return visibility;
        }
        assert (classKind == ClassKind.CLASS || classKind == ClassKind.TRAIT || classKind == ClassKind.ANNOTATION_CLASS);
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getDefaultConstructorVisibility"));
        }
        return visibility;
    }

    @NotNull
    public static Visibility getSyntheticClassObjectVisibility() {
        Visibility visibility = Visibilities.PUBLIC;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSyntheticClassObjectVisibility"));
        }
        return visibility;
    }

    @NotNull
    public static List<String> getSortedValueArguments(@NotNull AnnotationDescriptor descriptor, @Nullable DescriptorRenderer rendererForTypesIfNecessary) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSortedValueArguments"));
        }
        ArrayList<String> resultList = Lists.newArrayList();
        for (Map.Entry<ValueParameterDescriptor, CompileTimeConstant<?>> entry : descriptor.getAllValueArguments().entrySet()) {
            CompileTimeConstant<?> value = entry.getValue();
            String typeSuffix = rendererForTypesIfNecessary == null ? "" : ": " + rendererForTypesIfNecessary.renderType(value.getType(KotlinBuiltIns.getInstance()));
            resultList.add(entry.getKey().getName().asString() + " = " + value.toString() + typeSuffix);
        }
        Collections.sort(resultList);
        ArrayList<String> arrayList = resultList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getSortedValueArguments"));
        }
        return arrayList;
    }

    @Nullable
    public static ClassDescriptor getInnerClassByName(@NotNull ClassDescriptor classDescriptor, @NotNull String innerClassName) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getInnerClassByName"));
        }
        if (innerClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassName", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getInnerClassByName"));
        }
        ClassifierDescriptor classifier = classDescriptor.getDefaultType().getMemberScope().getClassifier(Name.identifier(innerClassName));
        assert (classifier instanceof ClassDescriptor) : "Inner class " + innerClassName + " in " + classDescriptor + " should be instance of ClassDescriptor, but was: " + (classifier == null ? "null" : classifier.getClass());
        return (ClassDescriptor)classifier;
    }

    @NotNull
    public static ConstructorDescriptor getConstructorOfDataClass(ClassDescriptor classDescriptor) {
        ConstructorDescriptor descriptor = DescriptorUtils.getConstructorDescriptorIfOnlyOne(classDescriptor);
        assert (descriptor != null) : "Data class must have only one constructor: " + classDescriptor.getConstructors();
        ConstructorDescriptor constructorDescriptor = descriptor;
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getConstructorOfDataClass"));
        }
        return constructorDescriptor;
    }

    @NotNull
    public static ConstructorDescriptor getConstructorOfSingletonObject(ClassDescriptor classDescriptor) {
        ConstructorDescriptor descriptor = DescriptorUtils.getConstructorDescriptorIfOnlyOne(classDescriptor);
        assert (descriptor != null) : "Class of singleton object must have only one constructor: " + classDescriptor.getConstructors();
        ConstructorDescriptor constructorDescriptor = descriptor;
        if (constructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getConstructorOfSingletonObject"));
        }
        return constructorDescriptor;
    }

    @Nullable
    private static ConstructorDescriptor getConstructorDescriptorIfOnlyOne(ClassDescriptor classDescriptor) {
        Collection<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
        return constructors.size() != 1 ? null : constructors.iterator().next();
    }

    @Nullable
    public static JetType getReceiverParameterType(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
        if (receiverParameterDescriptor == null) {
            return null;
        }
        return receiverParameterDescriptor.getType();
    }

    @NotNull
    public static JetType getVarargParameterType(@NotNull JetType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getVarargParameterType"));
        }
        JetType primitiveArrayType = KotlinBuiltIns.getInstance().getPrimitiveArrayJetTypeByPrimitiveJetType(elementType);
        JetType jetType = primitiveArrayType != null ? primitiveArrayType : KotlinBuiltIns.getInstance().getArrayType(Variance.INVARIANT, elementType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getVarargParameterType"));
        }
        return jetType;
    }

    @NotNull
    public static List<JetType> getValueParametersTypes(@NotNull List<ValueParameterDescriptor> valueParameters) {
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getValueParametersTypes"));
        }
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        ArrayList<JetType> arrayList = parameterTypes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getValueParametersTypes"));
        }
        return arrayList;
    }

    public static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (outer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outer", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isInsideOuterClassOrItsSubclass"));
        }
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorUtils.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    public static boolean isConstructorOfStaticNestedClass(@Nullable CallableDescriptor descriptor) {
        return descriptor instanceof ConstructorDescriptor && DescriptorUtils.isStaticNestedClass(descriptor.getContainingDeclaration());
    }

    public static boolean isStaticNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isStaticNestedClass"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor && containing instanceof ClassDescriptor && !((ClassDescriptor)descriptor).isInner();
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull JetScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getContainingClass"));
        }
        DeclarationDescriptor containingDeclaration = scope.getContainingDeclaration();
        return DescriptorUtils.getParentOfType(containingDeclaration, ClassDescriptor.class, false);
    }

    @NotNull
    public static JetScope getStaticNestedClassesScope(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getStaticNestedClassesScope"));
        }
        JetScope innerClassesScope = descriptor.getUnsubstitutedInnerClassesScope();
        FilteringScope filteringScope = new FilteringScope(innerClassesScope, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                return descriptor instanceof ClassDescriptor && !((ClassDescriptor)descriptor).isInner();
            }
        });
        if (filteringScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getStaticNestedClassesScope"));
        }
        return filteringScope;
    }

    public static boolean isEnumValueOfMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isEnumValueOfMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        JetType nullableString = TypeUtils.makeNullable(KotlinBuiltIns.getInstance().getStringType());
        return "valueOf".equals(functionDescriptor.getName().asString()) && methodTypeParameters.size() == 1 && JetTypeChecker.INSTANCE.isSubtypeOf(methodTypeParameters.get(0).getType(), nullableString);
    }

    public static boolean isEnumValuesMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isEnumValuesMethod"));
        }
        List<ValueParameterDescriptor> methodTypeParameters = functionDescriptor.getValueParameters();
        return "values".equals(functionDescriptor.getName().asString()) && methodTypeParameters.isEmpty();
    }

    @NotNull
    public static Set<ClassDescriptor> getAllSuperClasses(@NotNull ClassDescriptor klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getAllSuperClasses"));
        }
        Set<JetType> allSupertypes = TypeUtils.getAllSupertypes(klass.getDefaultType());
        HashSet<ClassDescriptor> allSuperclasses = Sets.newHashSet();
        for (JetType supertype : allSupertypes) {
            ClassDescriptor superclass = TypeUtils.getClassDescriptor(supertype);
            assert (superclass != null);
            allSuperclasses.add(superclass);
        }
        HashSet<ClassDescriptor> hashSet = allSuperclasses;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getAllSuperClasses"));
        }
        return hashSet;
    }

    public static boolean isTopLevelOrInnerClass(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "isTopLevelOrInnerClass"));
        }
        DeclarationDescriptor containing = descriptor.getContainingDeclaration();
        return DescriptorUtils.isTopLevelDeclaration(descriptor) || containing instanceof ClassDescriptor && DescriptorUtils.isTopLevelOrInnerClass((ClassDescriptor)containing);
    }

    @NotNull
    public static PackageFragmentDescriptor getExactlyOnePackageFragment(@NotNull ModuleDescriptor module, @NotNull FqName fqName) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getExactlyOnePackageFragment"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getExactlyOnePackageFragment"));
        }
        List<PackageFragmentDescriptor> packageFragments = module.getPackageFragmentProvider().getPackageFragments(fqName);
        assert (packageFragments.size() == 1) : "Exactly one package fragment expected: " + packageFragments;
        PackageFragmentDescriptor packageFragmentDescriptor = packageFragments.get(0);
        if (packageFragmentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/DescriptorUtils", "getExactlyOnePackageFragment"));
        }
        return packageFragmentDescriptor;
    }
}

