/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;

public class JetNamespaceHeader
extends JetReferenceExpression {
    private String qualifiedNameCache;

    public JetNamespaceHeader(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "<init>"));
        }
        super(node);
        this.qualifiedNameCache = null;
    }

    @NotNull
    public List<JetSimpleNameExpression> getNamespaceNames() {
        List<JetSimpleNameExpression> list2 = this.findChildrenByType(JetNodeTypes.REFERENCE_EXPRESSION);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getNamespaceNames"));
        }
        return list2;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        JetSimpleNameExpression lastPart = (JetSimpleNameExpression)this.findLastChildByType(JetNodeTypes.REFERENCE_EXPRESSION);
        if (lastPart == null) {
            return null;
        }
        return lastPart.getIdentifier();
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string = nameIdentifier == null ? "" : nameIdentifier.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getName"));
        }
        return string;
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Name name = nameIdentifier == null ? SpecialNames.ROOT_NAMESPACE : Name.identifier(nameIdentifier.getText());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getNameAsName"));
        }
        return name;
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName = this.getQualifiedName();
        FqName fqName = qualifiedName.isEmpty() ? FqName.ROOT : new FqName(qualifiedName);
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getFqName"));
        }
        return fqName;
    }

    @NotNull
    public FqName getFqName(JetSimpleNameExpression nameExpression) {
        FqName fqName = new FqName(this.getQualifiedNameOf(nameExpression));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getFqName"));
        }
        return fqName;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameOf(null);
        }
        String string = this.qualifiedNameCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    private String getQualifiedNameOf(@Nullable JetSimpleNameExpression nameExpression) {
        StringBuilder builder = new StringBuilder();
        for (JetSimpleNameExpression e : this.findChildrenByClass(JetSimpleNameExpression.class)) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e.getReferencedName());
            if (e == nameExpression) break;
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetNamespaceHeader", "getQualifiedNameOf"));
        }
        return string;
    }

    @Override
    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }
}

