/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import jet.Function1;
import jet.Function2;
import jet.KotlinPackageFragment;
import jet.TypeCastException;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetValueParameter;
import jet.suppress;
import kotlin.KotlinPackage;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.evaluate.BinaryOperationKey;
import org.jetbrains.jet.lang.evaluate.CompileTimeType;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$getIntegerValue$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$parseLong$1;
import org.jetbrains.jet.lang.evaluate.EvaluatePackage$parseLong$2;
import org.jetbrains.jet.lang.evaluate.UnaryOperationKey;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.constants.BooleanValue;
import org.jetbrains.jet.lang.resolve.constants.ByteValue;
import org.jetbrains.jet.lang.resolve.constants.CharValue;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.jet.lang.resolve.constants.DoubleValue;
import org.jetbrains.jet.lang.resolve.constants.FloatValue;
import org.jetbrains.jet.lang.resolve.constants.IntValue;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.jet.lang.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.jet.lang.resolve.constants.LongValue;
import org.jetbrains.jet.lang.resolve.constants.ShortValue;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;

@KotlinPackageFragment(abiVersion=13)
public final class EvaluatePackage-ConstantExpressionEvaluator-4b9931f7 {
    @NotNull
    static final CompileTimeType<Byte> BYTE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Short> SHORT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Integer> INT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Long> LONG = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Double> DOUBLE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Float> FLOAT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Character> CHAR = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Boolean> BOOLEAN = new CompileTimeType();
    @NotNull
    static final CompileTimeType<String> STRING = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Object> ANY = new CompileTimeType();

    @Nullable
    public static final Object getValueForNumberType(@JetValueParameter(name="$receiver") IntegerValueTypeConstructor $receiver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getValueForNumberType"));
        }
        CompileTimeConstant<? extends Object> valueWithNewType = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getCompileTimeConstantForNumberType($receiver, expectedType);
        boolean bl = true;
        if (valueWithNewType == null) {
            bl = false;
        }
        if (bl) {
            return valueWithNewType.getValue();
        }
        return null;
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> getCompileTimeConstantForNumberType(@JetValueParameter(name="$receiver") IntegerValueTypeConstructor $receiver, @JetValueParameter(name="expectedType") @NotNull JetType expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getCompileTimeConstantForNumberType"));
        }
        JetType defaultType = TypeUtils.getPrimitiveNumberType($receiver, expectedType);
        return EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createConvertibleCompileTimeConstant($receiver.getValue(), defaultType);
    }

    public static final boolean hasLongSuffix(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "hasLongSuffix"));
        }
        return !KotlinPackage.endsWith(text, 'l') ? KotlinPackage.endsWith(text, 'L') : true;
    }

    @Nullable
    public static final Long parseLong(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "parseLong"));
        }
        try {
            EvaluatePackage$parseLong$1 evaluatePackage$parseLong$1 = new EvaluatePackage$parseLong$1(text);
            EvaluatePackage$parseLong$2 evaluatePackage$parseLong$2 = new EvaluatePackage$parseLong$2(evaluatePackage$parseLong$1);
            return (!KotlinPackage.startsWith(text, "0x") ? KotlinPackage.startsWith(text, "0X") : true) ? evaluatePackage$parseLong$2.invoke(KotlinPackage.substring(text, 2), 16) : ((!KotlinPackage.startsWith(text, "0b") ? KotlinPackage.startsWith(text, "0B") : true) ? evaluatePackage$parseLong$2.invoke(KotlinPackage.substring(text, 2), 2) : evaluatePackage$parseLong$2.invoke(text, 10));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    public static final Object parseFloatingLiteral(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "parseFloatingLiteral"));
        }
        if (KotlinPackage.endsWith(KotlinPackage.toLowerCase(text), 'f')) {
            return EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.parseFloat(text);
        }
        return EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.parseDouble(text);
    }

    @Nullable
    public static final Double parseDouble(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "parseDouble"));
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    public static final Float parseFloat(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "parseFloat"));
        }
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static final boolean parseBoolean(@JetValueParameter(name="text") @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "parseBoolean"));
        }
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createCompileTimeConstantForEquals(@JetValueParameter(name="result", type="?") @Nullable Object result, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference) {
        if (operationReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationReference", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "createCompileTimeConstantForEquals"));
        }
        if (result instanceof Boolean) {
            BooleanValue booleanValue;
            KotlinPackage.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for equals operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.EQEQ)) {
                booleanValue = BooleanValue.valueOf((Boolean)result);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.EXCLEQ)) {
                booleanValue = BooleanValue.valueOf((Boolean)result == false);
            } else {
                if (Intrinsics.areEqual(iElementType, JetTokens.IDENTIFIER)) {
                    JetExpression jetExpression2 = operationReference;
                    if (jetExpression2 == null) {
                        throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
                    }
                    KotlinPackage.assert(Intrinsics.areEqual(((JetSimpleNameExpression)jetExpression2).getReferencedNameAsName(), OperatorConventions.EQUALS), "This method should be called only for equals operations");
                    return BooleanValue.valueOf((Boolean)result);
                }
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + " " + ((JetSimpleNameExpression)operationReference).getText());
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createCompileTimeConstantForCompareTo(@JetValueParameter(name="result", type="?") @Nullable Object result, @JetValueParameter(name="operationReference") @NotNull JetExpression operationReference) {
        if (operationReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationReference", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "createCompileTimeConstantForCompareTo"));
        }
        if (result instanceof Integer) {
            BooleanValue booleanValue;
            KotlinPackage.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for compareTo operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.LT)) {
                booleanValue = BooleanValue.valueOf(((Number)result).intValue() < 0);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.LTEQ)) {
                booleanValue = BooleanValue.valueOf(((Number)result).intValue() <= 0);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.GT)) {
                booleanValue = BooleanValue.valueOf(((Number)result).intValue() > 0);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.GTEQ)) {
                booleanValue = BooleanValue.valueOf(((Number)result).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual(iElementType, JetTokens.IDENTIFIER)) {
                    JetExpression jetExpression2 = operationReference;
                    if (jetExpression2 == null) {
                        throw new TypeCastException("org.jetbrains.jet.lang.psi.JetExpression cannot be cast to org.jetbrains.jet.lang.psi.JetSimpleNameExpression");
                    }
                    KotlinPackage.assert(Intrinsics.areEqual(((JetSimpleNameExpression)jetExpression2).getReferencedNameAsName(), OperatorConventions.COMPARE_TO), "This method should be called only for compareTo operations");
                    return new IntValue(((Number)result).intValue());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return booleanValue;
        }
        return null;
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createUnconvertibleCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value) {
        Object object2 = value;
        return Intrinsics.areEqual(object2, null) ? (CompileTimeConstant)null : (object2 instanceof Byte ? (CompileTimeConstant)new ByteValue(((Number)value).byteValue()) : (object2 instanceof Short ? (CompileTimeConstant)new ShortValue(((Number)value).shortValue()) : (object2 instanceof Integer ? (CompileTimeConstant)new IntValue(((Number)value).intValue()) : (object2 instanceof Long ? (CompileTimeConstant)new LongValue(((Number)value).longValue()) : (object2 instanceof Character ? (CompileTimeConstant)new CharValue(((Character)value).charValue()) : (object2 instanceof Float ? (CompileTimeConstant)new FloatValue(((Number)value).floatValue()) : (object2 instanceof Double ? (CompileTimeConstant)new DoubleValue(((Number)value).doubleValue()) : (object2 instanceof Boolean ? (CompileTimeConstant)BooleanValue.valueOf((Boolean)value) : (CompileTimeConstant)null))))))));
    }

    @Nullable
    public static final StringValue createStringConstant(@JetValueParameter(name="value", type="?") @Nullable CompileTimeConstant<? extends Object> value) {
        StringValue stringValue;
        CompileTimeConstant<? extends Object> compileTimeConstant = value;
        if (Intrinsics.areEqual(compileTimeConstant, null)) {
            stringValue = null;
        } else if (compileTimeConstant instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstructor integerValueTypeConstructor = (IntegerValueTypeConstructor)((IntegerValueTypeConstant)value).getValue();
            if (integerValueTypeConstructor == null) {
                Intrinsics.throwNpe();
            }
            stringValue = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.createStringConstant(EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getCompileTimeConstantForNumberType(integerValueTypeConstructor, TypeUtils.NO_EXPECTED_TYPE));
        } else {
            stringValue = compileTimeConstant instanceof StringValue ? (StringValue)value : (compileTimeConstant instanceof IntValue || compileTimeConstant instanceof ByteValue || compileTimeConstant instanceof ShortValue || compileTimeConstant instanceof LongValue || compileTimeConstant instanceof CharValue || compileTimeConstant instanceof DoubleValue || compileTimeConstant instanceof FloatValue || compileTimeConstant instanceof BooleanValue ? new StringValue(String.valueOf(value.getValue())) : (StringValue)null);
        }
        return stringValue;
    }

    @Nullable
    public static final CompileTimeConstant<? extends Object> createConvertibleCompileTimeConstant(@JetValueParameter(name="value", type="?") @Nullable Object value, @JetValueParameter(name="expectedType", type="?") @Nullable JetType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object2 = value;
        if (Intrinsics.areEqual(object2, null)) {
            compileTimeConstant = null;
        } else if (object2 instanceof Byte || object2 instanceof Short || object2 instanceof Integer || object2 instanceof Long) {
            Object object3 = value;
            if (object3 == null) {
                throw new TypeCastException("jet.Any? cannot be cast to jet.Number");
            }
            long l = ((Number)object3).longValue();
            JetType jetType = expectedType;
            if (jetType == null) {
                jetType = TypeUtils.NO_EXPECTED_TYPE;
            }
            compileTimeConstant = EvaluatePackage-ConstantExpressionEvaluator-4b9931f7.getIntegerValue(l, jetType);
        } else {
            compileTimeConstant = object2 instanceof Character ? (CompileTimeConstant)new CharValue(((Character)value).charValue()) : (object2 instanceof Float ? (CompileTimeConstant)new FloatValue(((Number)value).floatValue()) : (object2 instanceof Double ? (CompileTimeConstant)new DoubleValue(((Number)value).doubleValue()) : (object2 instanceof Boolean ? (CompileTimeConstant)BooleanValue.valueOf((Boolean)value) : (object2 instanceof String ? (CompileTimeConstant)new StringValue((String)value) : (CompileTimeConstant)null))));
        }
        return compileTimeConstant;
    }

    public static final boolean isIntegerType(@JetValueParameter(name="value", type="?") @Nullable Object value) {
        return !(!(!(value instanceof Byte) ? value instanceof Short : true) ? value instanceof Integer : true) ? value instanceof Long : true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CompileTimeConstant<? extends Object> getIntegerValue(@JetValueParameter(name="value") long value, @JetValueParameter(name="expectedType") @NotNull JetType jetType) {
        long l;
        long l2;
        void expectedType;
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getIntegerValue"));
        }
        EvaluatePackage$getIntegerValue$1 evaluatePackage$getIntegerValue$1 = EvaluatePackage$getIntegerValue$1.instance$;
        if (CompileTimeConstantChecker.noExpectedTypeOrError((JetType)expectedType)) {
            return new IntegerValueTypeConstant(value);
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType jetType2 = TypeUtils.makeNotNullable((JetType)expectedType);
        CompileTimeConstant compileTimeConstant = Intrinsics.areEqual(jetType2, builtIns.getLongType()) ? (CompileTimeConstant)new LongValue(value) : (Intrinsics.areEqual(jetType2, builtIns.getShortType()) ? ((l2 = value) == (long)((short)value) ? (CompileTimeConstant)new ShortValue((short)value) : evaluatePackage$getIntegerValue$1.invoke(value)) : (Intrinsics.areEqual(jetType2, builtIns.getByteType()) ? ((l = value) == (long)((byte)value) ? (CompileTimeConstant)new ByteValue((byte)value) : evaluatePackage$getIntegerValue$1.invoke(value)) : (Intrinsics.areEqual(jetType2, builtIns.getCharType()) ? (CompileTimeConstant)new IntValue((int)value) : evaluatePackage$getIntegerValue$1.invoke(value))));
        return compileTimeConstant;
    }

    @Nullable
    public static final JetType getReceiverExpressionType(@JetValueParameter(name="resolvedCall") @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getReceiverExpressionType"));
        }
        ExplicitReceiverKind explicitReceiverKind = resolvedCall.getExplicitReceiverKind();
        return Intrinsics.areEqual((Object)explicitReceiverKind, (Object)ExplicitReceiverKind.THIS_OBJECT) ? resolvedCall.getThisObject().getType() : (Intrinsics.areEqual((Object)explicitReceiverKind, (Object)ExplicitReceiverKind.RECEIVER_ARGUMENT) ? resolvedCall.getReceiverArgument().getType() : (Intrinsics.areEqual((Object)explicitReceiverKind, (Object)ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) ? (JetType)null : (Intrinsics.areEqual((Object)explicitReceiverKind, (Object)ExplicitReceiverKind.BOTH_RECEIVERS) ? (JetType)null : (JetType)null)));
    }

    @Nullable
    public static final CompileTimeType<? extends Object> getCompileTimeType(@JetValueParameter(name="c") @NotNull JetType c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getCompileTimeType"));
        }
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType jetType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(jetType, builtIns.getIntType()) ? INT : (Intrinsics.areEqual(jetType, builtIns.getByteType()) ? BYTE : (Intrinsics.areEqual(jetType, builtIns.getShortType()) ? SHORT : (Intrinsics.areEqual(jetType, builtIns.getLongType()) ? LONG : (Intrinsics.areEqual(jetType, builtIns.getDoubleType()) ? DOUBLE : (Intrinsics.areEqual(jetType, builtIns.getFloatType()) ? FLOAT : (Intrinsics.areEqual(jetType, builtIns.getCharType()) ? CHAR : (Intrinsics.areEqual(jetType, builtIns.getBooleanType()) ? BOOLEAN : (Intrinsics.areEqual(jetType, builtIns.getStringType()) ? STRING : (Intrinsics.areEqual(jetType, builtIns.getAnyType()) ? ANY : (CompileTimeType)null)))))))));
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        CompileTimeType<Byte> compileTimeType = BYTE;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getBYTE"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        CompileTimeType<Short> compileTimeType = SHORT;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getSHORT"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        CompileTimeType<Integer> compileTimeType = INT;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getINT"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        CompileTimeType<Long> compileTimeType = LONG;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getLONG"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        CompileTimeType<Double> compileTimeType = DOUBLE;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getDOUBLE"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        CompileTimeType<Float> compileTimeType = FLOAT;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getFLOAT"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        CompileTimeType<Character> compileTimeType = CHAR;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getCHAR"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        CompileTimeType<Boolean> compileTimeType = BOOLEAN;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getBOOLEAN"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        CompileTimeType<String> compileTimeType = STRING;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getSTRING"));
        }
        return compileTimeType;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        CompileTimeType<Object> compileTimeType = ANY;
        if (compileTimeType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "getANY"));
        }
        return compileTimeType;
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> binaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="b") @NotNull CompileTimeType<B> b, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function2<? super A, ? super B, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "binaryOperation"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "binaryOperation"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "binaryOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "binaryOperation"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "binaryOperation"));
        }
        Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>> pair = new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker);
        if (pair == null) {
            throw new TypeCastException("kotlin.Pair<(A, B) -> jet.Any, (java.math.BigInteger, java.math.BigInteger) -> java.math.BigInteger> cannot be cast to kotlin.Pair<(jet.Any?, jet.Any?) -> jet.Any, (java.math.BigInteger, java.math.BigInteger) -> java.math.BigInteger>");
        }
        Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> pair2 = KotlinPackage.to(new BinaryOperationKey<A, B>(a, b, functionName), pair);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "binaryOperation"));
        }
        return pair2;
    }

    @suppress(names={"UNCHECKED_CAST"})
    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> unaryOperation(@JetValueParameter(name="a") @NotNull CompileTimeType<A> a, @JetValueParameter(name="functionName") @NotNull String functionName, @JetValueParameter(name="operation") @NotNull Function1<? super A, ? extends Object> operation, @JetValueParameter(name="checker") @NotNull Function1<? super Long, ? extends Long> checker) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "unaryOperation"));
        }
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "unaryOperation"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "unaryOperation"));
        }
        if (checker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checker", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "unaryOperation"));
        }
        Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>> pair = new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>>(operation, checker);
        if (pair == null) {
            throw new TypeCastException("kotlin.Pair<(A) -> jet.Any, (jet.Long) -> jet.Long> cannot be cast to kotlin.Pair<(jet.Any?) -> jet.Any, (jet.Long) -> jet.Long>");
        }
        Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> pair2 = KotlinPackage.to(new UnaryOperationKey<A>(a, functionName), pair);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/evaluate/EvaluatePackage-ConstantExpressionEvaluator-4b9931f7", "unaryOperation"));
        }
        return pair2;
    }
}

