/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.utils.Printer;

public class PackageViewDescriptorImpl
extends DeclarationDescriptorImpl
implements PackageViewDescriptor {
    private final ModuleDescriptor module;
    private final FqName fqName;
    private final JetScope memberScope;

    public PackageViewDescriptorImpl(@NotNull ModuleDescriptor module, @NotNull FqName fqName, @NotNull List<PackageFragmentDescriptor> fragments) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "<init>"));
        }
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), fqName.shortNameOrSpecial());
        this.module = module;
        this.fqName = fqName;
        ArrayList<JetScope> scopes = Lists.newArrayList();
        assert (!fragments.isEmpty()) : fqName + " in " + module;
        for (PackageFragmentDescriptor fragment : fragments) {
            scopes.add(fragment.getMemberScope());
        }
        scopes.add(new SubpackagesScope());
        this.memberScope = new ChainedScope((DeclarationDescriptor)this, "package view scope for " + fqName + " in " + module.getName(), scopes.toArray(new JetScope[scopes.size()]));
    }

    @Override
    @Nullable
    public PackageViewDescriptor getContainingDeclaration() {
        return this.fqName.isRoot() ? null : this.module.getPackage(this.fqName.parent());
    }

    @Override
    @Nullable
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "substitute"));
        }
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPackageViewDescriptor(this, data2);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = this.fqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "getFqName"));
        }
        return fqName;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public ModuleDescriptor getModule() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl", "getModule"));
        }
        return moduleDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageViewDescriptorImpl that = (PackageViewDescriptorImpl)o;
        if (!this.fqName.equals(that.fqName)) {
            return false;
        }
        return this.module.equals(that.module);
    }

    public int hashCode() {
        int result = this.module.hashCode();
        result = 31 * result + this.fqName.hashCode();
        return result;
    }

    private class SubpackagesScope
    extends JetScopeImpl {
        private SubpackagesScope() {
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            PackageViewDescriptorImpl packageViewDescriptorImpl = PackageViewDescriptorImpl.this;
            if (packageViewDescriptorImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl$SubpackagesScope", "getContainingDeclaration"));
            }
            return packageViewDescriptorImpl;
        }

        @Override
        @Nullable
        public PackageViewDescriptor getPackage(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl$SubpackagesScope", "getPackage"));
            }
            return name.isSpecial() ? null : PackageViewDescriptorImpl.this.module.getPackage(PackageViewDescriptorImpl.this.fqName.child(name));
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            ArrayList<DeclarationDescriptor> result = Lists.newArrayList();
            for (FqName subFqName : PackageViewDescriptorImpl.this.module.getPackageFragmentProvider().getSubPackagesOf(PackageViewDescriptorImpl.this.fqName)) {
                result.add(this.getPackage(subFqName.shortName()));
            }
            ArrayList<DeclarationDescriptor> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl$SubpackagesScope", "getAllDescriptors"));
            }
            return arrayList;
        }

        @Override
        public void printScopeStructure(@NotNull Printer p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/descriptors/impl/PackageViewDescriptorImpl$SubpackagesScope", "printScopeStructure"));
            }
            p.println(this.getClass().getSimpleName(), " {");
            p.pushIndent();
            p.println("thisDescriptor = ", PackageViewDescriptorImpl.this);
            p.popIndent();
            p.println("}");
        }
    }
}

