/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.NamespaceLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.ScopeBasedNamespaceLikeBuilder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class MutablePackageFragmentDescriptor
extends DeclarationDescriptorImpl
implements PackageFragmentDescriptor {
    private final PackageFragmentProvider provider;
    private final ModuleDescriptor module;
    private final FqName fqName;
    private final WritableScope scope;
    private final NamespaceLikeBuilder builder;

    public MutablePackageFragmentDescriptor(@NotNull PackageFragmentProvider provider, @NotNull ModuleDescriptor module, @NotNull FqName fqName) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), fqName.shortNameOrSpecial());
        this.provider = provider;
        this.module = module;
        this.fqName = fqName;
        this.scope = new WritableScopeImpl(JetScope.EMPTY, this, RedeclarationHandler.DO_NOTHING, "Members of " + fqName + " in " + module);
        this.scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.builder = new ScopeBasedNamespaceLikeBuilder(this, this.scope);
    }

    @Override
    @NotNull
    public PackageFragmentProvider getProvider() {
        PackageFragmentProvider packageFragmentProvider = this.provider;
        if (packageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "getProvider"));
        }
        return packageFragmentProvider;
    }

    @Override
    @NotNull
    public ModuleDescriptor getContainingDeclaration() {
        ModuleDescriptor moduleDescriptor = this.module;
        if (moduleDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "getContainingDeclaration"));
        }
        return moduleDescriptor;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        FqName fqName = this.fqName;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "getFqName"));
        }
        return fqName;
    }

    @Override
    @NotNull
    public WritableScope getMemberScope() {
        WritableScope writableScope = this.scope;
        if (writableScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "getMemberScope"));
        }
        return writableScope;
    }

    @Override
    @Nullable
    public DeclarationDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "substitute"));
        }
        return this;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitPackageFragmentDescriptor(this, data2);
    }

    @NotNull
    public NamespaceLikeBuilder getBuilder() {
        NamespaceLikeBuilder namespaceLikeBuilder = this.builder;
        if (namespaceLikeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/MutablePackageFragmentDescriptor", "getBuilder"));
        }
        return namespaceLikeBuilder;
    }
}

