/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.impl.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PackageViewDescriptorImpl;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.TypeSubstitutor;

public class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private static final Logger LOG = Logger.getInstance(ModuleDescriptorImpl.class);
    private final List<PackageFragmentProvider> fragmentProviders;
    private final CompositePackageFragmentProvider packageFragmentProvider;
    private final List<ImportPath> defaultImports;
    private final PlatformToKotlinClassMap platformToKotlinClassMap;

    public ModuleDescriptorImpl(@NotNull Name name, @NotNull List<ImportPath> defaultImports, @NotNull PlatformToKotlinClassMap platformToKotlinClassMap) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "<init>"));
        }
        if (defaultImports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultImports", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "<init>"));
        }
        if (platformToKotlinClassMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformToKotlinClassMap", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "<init>"));
        }
        super(Collections.<AnnotationDescriptor>emptyList(), name);
        this.fragmentProviders = Lists.newArrayList();
        this.packageFragmentProvider = new CompositePackageFragmentProvider(this.fragmentProviders);
        if (!name.isSpecial()) {
            throw new IllegalArgumentException("module name must be special: " + name);
        }
        this.defaultImports = defaultImports;
        this.platformToKotlinClassMap = platformToKotlinClassMap;
    }

    public void addFragmentProvider(@NotNull PackageFragmentProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "addFragmentProvider"));
        }
        if (this.fragmentProviders.contains(provider)) {
            LOG.error("Trying to add already present fragment provider: " + provider);
        }
        this.fragmentProviders.add(provider);
    }

    @Override
    @Nullable
    public DeclarationDescriptor getContainingDeclaration() {
        return null;
    }

    @Override
    @NotNull
    public PackageFragmentProvider getPackageFragmentProvider() {
        CompositePackageFragmentProvider compositePackageFragmentProvider = this.packageFragmentProvider;
        if (compositePackageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getPackageFragmentProvider"));
        }
        return compositePackageFragmentProvider;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getPackage(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getPackage"));
        }
        List<PackageFragmentDescriptor> fragments = this.packageFragmentProvider.getPackageFragments(fqName);
        return !fragments.isEmpty() ? new PackageViewDescriptorImpl(this, fqName, fragments) : null;
    }

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports() {
        List<ImportPath> list2 = this.defaultImports;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getDefaultImports"));
        }
        return list2;
    }

    @Override
    @NotNull
    public PlatformToKotlinClassMap getPlatformToKotlinClassMap() {
        PlatformToKotlinClassMap platformToKotlinClassMap = this.platformToKotlinClassMap;
        if (platformToKotlinClassMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "getPlatformToKotlinClassMap"));
        }
        return platformToKotlinClassMap;
    }

    @Override
    @NotNull
    public ModuleDescriptor substitute(@NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "substitute"));
        }
        ModuleDescriptorImpl moduleDescriptorImpl = this;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/ModuleDescriptorImpl", "substitute"));
        }
        return moduleDescriptorImpl;
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data2) {
        return visitor.visitModuleDeclaration(this, data2);
    }
}

