/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class SubroutineExitInstruction
extends InstructionImpl {
    private final JetElement subroutine;
    private final boolean isError;
    private SubroutineSinkInstruction sinkInstruction;

    public SubroutineExitInstruction(@NotNull JetElement subroutine, boolean isError) {
        if (subroutine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subroutine", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "<init>"));
        }
        this.subroutine = subroutine;
        this.isError = isError;
    }

    public JetElement getSubroutine() {
        return this.subroutine;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setSink(SubroutineSinkInstruction instruction) {
        this.sinkInstruction = (SubroutineSinkInstruction)this.outgoingEdgeTo(instruction);
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        assert (this.sinkInstruction != null);
        Set<Instruction> set = Collections.singleton(this.sinkInstruction);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "getNextInstructions"));
        }
        return set;
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "accept"));
        }
        visitor.visitSubroutineExit(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "accept"));
        }
        return visitor.visitSubroutineExit(this);
    }

    public String toString() {
        return this.isError ? "<ERROR>" : "<END>";
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        SubroutineExitInstruction subroutineExitInstruction = new SubroutineExitInstruction(this.subroutine, this.isError);
        if (subroutineExitInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/SubroutineExitInstruction", "createCopy"));
        }
        return subroutineExitInstruction;
    }
}

