/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jet.Function0;
import jet.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedMemberScope;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentProvider;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.EnumEntrySyntheticClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.name.SpecialNames;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.NullableLazyValue;
import org.jetbrains.jet.storage.StorageManager;

public class DeserializedClassDescriptor
extends AbstractClassDescriptor
implements ClassDescriptor {
    private final ClassId classId;
    private final ProtoBuf.Class classProto;
    private final StorageManager storageManager;
    private final TypeDeserializer typeDeserializer;
    private final DescriptorDeserializer deserializer;
    private final DeserializedMemberScope memberScope;
    private final NullableLazyValue<ConstructorDescriptor> primaryConstructor;
    private final AnnotationDeserializer annotationDeserializer;
    private final NotNullLazyValue<List<AnnotationDescriptor>> annotations;
    private final NullableLazyValue<ClassDescriptor> classObjectDescriptor;
    private final NestedClassDescriptors nestedClasses;
    private final NotNullLazyValue<DeclarationDescriptor> containingDeclaration;
    private final DeserializedClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final DescriptorFinder descriptorFinder;
    private final PackageFragmentProvider packageFragmentProvider;

    public DeserializedClassDescriptor(@NotNull StorageManager storageManager, @NotNull AnnotationDeserializer annotationResolver, @NotNull DescriptorFinder descriptorFinder, @NotNull PackageFragmentProvider packageFragmentProvider, @NotNull NameResolver nameResolver, @NotNull ProtoBuf.Class classProto) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (annotationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationResolver", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (descriptorFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorFinder", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        if (classProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProto", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "<init>"));
        }
        super(storageManager, nameResolver.getClassId(classProto.getFqName()).getRelativeClassName().shortName());
        this.classProto = classProto;
        this.classId = nameResolver.getClassId(classProto.getFqName());
        this.storageManager = storageManager;
        this.packageFragmentProvider = packageFragmentProvider;
        this.descriptorFinder = descriptorFinder;
        TypeDeserializer notNullTypeDeserializer = new TypeDeserializer(storageManager, null, nameResolver, descriptorFinder, "Deserializer for class " + this.getName(), TypeDeserializer.TypeParameterResolver.NONE);
        DescriptorDeserializer outerDeserializer = DescriptorDeserializer.create(storageManager, notNullTypeDeserializer, this, nameResolver, annotationResolver);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(classProto.getTypeParameterCount());
        this.deserializer = outerDeserializer.createChildDeserializer(this, classProto.getTypeParameterList(), typeParameters);
        this.typeDeserializer = this.deserializer.getTypeDeserializer();
        this.containingDeclaration = storageManager.createLazyValue(new Function0<DeclarationDescriptor>(){

            @Override
            public DeclarationDescriptor invoke() {
                return DeserializedClassDescriptor.this.computeContainingDeclaration();
            }
        });
        this.typeConstructor = new DeserializedClassTypeConstructor(typeParameters);
        this.memberScope = new DeserializedClassMemberScope(storageManager, this);
        int flags = classProto.getFlags();
        this.modality = DescriptorDeserializer.modality(Flags.MODALITY.get(flags));
        this.visibility = DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags));
        this.kind = DescriptorDeserializer.classKind(Flags.CLASS_KIND.get(flags));
        this.isInner = Flags.INNER.get(flags);
        this.annotationDeserializer = annotationResolver;
        this.annotations = storageManager.createLazyValue(new Function0<List<AnnotationDescriptor>>(){

            @Override
            public List<AnnotationDescriptor> invoke() {
                return DeserializedClassDescriptor.this.computeAnnotations();
            }
        });
        this.primaryConstructor = storageManager.createNullableLazyValue(new Function0<ConstructorDescriptor>(){

            @Override
            public ConstructorDescriptor invoke() {
                return DeserializedClassDescriptor.this.computePrimaryConstructor();
            }
        });
        this.classObjectDescriptor = storageManager.createNullableLazyValue(new Function0<ClassDescriptor>(){

            @Override
            public ClassDescriptor invoke() {
                return DeserializedClassDescriptor.this.computeClassObjectDescriptor();
            }
        });
        this.nestedClasses = new NestedClassDescriptors();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.containingDeclaration.invoke();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @NotNull
    private DeclarationDescriptor computeContainingDeclaration() {
        if (this.classId.isTopLevelClass()) {
            List<PackageFragmentDescriptor> fragments = this.packageFragmentProvider.getPackageFragments(this.classId.getPackageFqName());
            assert (fragments.size() == 1) : "there should be exactly one package: " + fragments;
            DeclarationDescriptor declarationDescriptor = fragments.iterator().next();
            if (declarationDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "computeContainingDeclaration"));
            }
            return declarationDescriptor;
        }
        ClassDescriptor result = this.descriptorFinder.findClass(this.classId.getOuterClassId());
        DeclarationDescriptor declarationDescriptor = result != null ? result : ErrorUtils.getErrorModule();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "computeContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        DeserializedClassTypeConstructor deserializedClassTypeConstructor = this.typeConstructor;
        if (deserializedClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getTypeConstructor"));
        }
        return deserializedClassTypeConstructor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = this.kind;
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    private List<AnnotationDescriptor> computeAnnotations() {
        if (!Flags.HAS_ANNOTATIONS.get(this.classProto.getFlags()).booleanValue()) {
            return Collections.emptyList();
        }
        return this.annotationDeserializer.loadClassAnnotations(this, this.classProto);
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> getAnnotations() {
        List list2 = (List)this.annotations.invoke();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getAnnotations"));
        }
        return list2;
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberLookup() {
        DeserializedMemberScope deserializedMemberScope = this.memberScope;
        if (deserializedMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getScopeForMemberLookup"));
        }
        return deserializedMemberScope;
    }

    @Nullable
    private ConstructorDescriptor computePrimaryConstructor() {
        if (!this.classProto.hasPrimaryConstructor()) {
            return null;
        }
        ProtoBuf.Class.PrimaryConstructor constructorProto = this.classProto.getPrimaryConstructor();
        if (!constructorProto.hasData()) {
            ConstructorDescriptorImpl descriptor = DescriptorFactory.createPrimaryConstructorForObject(this);
            descriptor.setReturnType(this.getDefaultType());
            return descriptor;
        }
        return (ConstructorDescriptor)this.deserializer.loadCallable(constructorProto.getData());
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return (ConstructorDescriptor)this.primaryConstructor.invoke();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getUnsubstitutedPrimaryConstructor();
        if (constructor == null) {
            List<ConstructorDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getConstructors"));
            }
            return list2;
        }
        List<ConstructorDescriptor> list3 = Collections.singletonList(constructor);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "getConstructors"));
        }
        return list3;
    }

    @Nullable
    private ClassDescriptor computeClassObjectDescriptor() {
        if (!this.classProto.hasClassObject()) {
            return null;
        }
        if (this.getKind() == ClassKind.ENUM_CLASS) {
            return this.createEnumClassObject();
        }
        if (this.getKind() == ClassKind.OBJECT) {
            ProtoBuf.Class.ClassObject classObjectProto = this.classProto.getClassObject();
            if (!classObjectProto.hasData()) {
                throw new IllegalStateException("Object should have a serialized class object: " + this.classId);
            }
            return new DeserializedClassDescriptor(this.storageManager, this.annotationDeserializer, this.descriptorFinder, this.packageFragmentProvider, this.deserializer.getNameResolver(), classObjectProto.getData());
        }
        return this.descriptorFinder.findClass(this.classId.createNestedClassId(SpecialNames.getClassObjectName(this.getName())));
    }

    @NotNull
    private MutableClassDescriptor createEnumClassObject() {
        MutableClassDescriptor classObject = new MutableClassDescriptor(this, this.getScopeForMemberLookup(), ClassKind.CLASS_OBJECT, false, SpecialNames.getClassObjectName(this.getName()));
        classObject.setSupertypes(Collections.singleton(KotlinBuiltIns.getInstance().getAnyType()));
        classObject.setModality(Modality.FINAL);
        classObject.setVisibility(DescriptorUtils.getSyntheticClassObjectVisibility());
        classObject.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObject.setPrimaryConstructor(DescriptorFactory.createPrimaryConstructorForObject(classObject));
        classObject.createTypeConstructor();
        JetType enumType = this.getDefaultType();
        JetType enumArrayType = KotlinBuiltIns.getInstance().getArrayType(enumType);
        classObject.getBuilder().addFunctionDescriptor(DescriptorFactory.createEnumClassObjectValuesMethod(classObject, enumArrayType));
        classObject.getBuilder().addFunctionDescriptor(DescriptorFactory.createEnumClassObjectValueOfMethod(classObject, enumType));
        MutableClassDescriptor mutableClassDescriptor = classObject;
        if (mutableClassDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor", "createEnumClassObject"));
        }
        return mutableClassDescriptor;
    }

    @Override
    @Nullable
    public ClassDescriptor getClassObjectDescriptor() {
        return (ClassDescriptor)this.classObjectDescriptor.invoke();
    }

    private Collection<JetType> computeSuperTypes() {
        ArrayList<JetType> supertypes = new ArrayList<JetType>(this.classProto.getSupertypeCount());
        for (ProtoBuf.Type supertype : this.classProto.getSupertypeList()) {
            supertypes.add(this.typeDeserializer.type(supertype));
        }
        return supertypes;
    }

    public String toString() {
        return "deserialized class " + this.getName().toString();
    }

    private class NestedClassDescriptors {
        private final Set<Name> nestedClassNames = this.nestedClassNames();
        private final MemoizedFunctionToNullable<Name, ClassDescriptor> findClass;
        private final Set<Name> enumEntryNames = this.enumEntryNames();

        public NestedClassDescriptors() {
            final NotNullLazyValue<Collection<Name>> enumMemberNames = DeserializedClassDescriptor.this.storageManager.createLazyValue(new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return NestedClassDescriptors.this.computeEnumMemberNames();
                }
            });
            this.findClass = DeserializedClassDescriptor.this.storageManager.createMemoizedFunctionWithNullableValues(new Function1<Name, ClassDescriptor>(){

                @Override
                public ClassDescriptor invoke(Name name) {
                    if (NestedClassDescriptors.this.enumEntryNames.contains(name)) {
                        return EnumEntrySyntheticClassDescriptor.create(DeserializedClassDescriptor.this.storageManager, DeserializedClassDescriptor.this, name, enumMemberNames);
                    }
                    if (NestedClassDescriptors.this.nestedClassNames.contains(name)) {
                        return DeserializedClassDescriptor.this.descriptorFinder.findClass(DeserializedClassDescriptor.this.classId.createNestedClassId(name));
                    }
                    return null;
                }
            });
        }

        @NotNull
        private Set<Name> nestedClassNames() {
            HashSet<Name> result = new HashSet<Name>();
            NameResolver nameResolver = DeserializedClassDescriptor.this.deserializer.getNameResolver();
            for (Integer index : DeserializedClassDescriptor.this.classProto.getNestedClassNameList()) {
                result.add(nameResolver.getName(index));
            }
            HashSet<Name> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "nestedClassNames"));
            }
            return hashSet;
        }

        @NotNull
        private Set<Name> enumEntryNames() {
            if (DeserializedClassDescriptor.this.getKind() != ClassKind.ENUM_CLASS) {
                Set<Name> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "enumEntryNames"));
                }
                return set;
            }
            HashSet<Name> result = new HashSet<Name>();
            NameResolver nameResolver = DeserializedClassDescriptor.this.deserializer.getNameResolver();
            for (Integer index : DeserializedClassDescriptor.this.classProto.getEnumEntryList()) {
                result.add(nameResolver.getName(index));
            }
            HashSet<Name> hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "enumEntryNames"));
            }
            return hashSet;
        }

        @NotNull
        private Collection<Name> computeEnumMemberNames() {
            HashSet<Name> result = new HashSet<Name>();
            for (JetType supertype : DeserializedClassDescriptor.this.getTypeConstructor().getSupertypes()) {
                for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                    if (!(descriptor instanceof SimpleFunctionDescriptor) && !(descriptor instanceof PropertyDescriptor)) continue;
                    result.add(descriptor.getName());
                }
            }
            final NameResolver nameResolver = DeserializedClassDescriptor.this.deserializer.getNameResolver();
            HashSet<Name> hashSet = KotlinPackage.mapTo(DeserializedClassDescriptor.this.classProto.getMemberList(), result, new Function1<ProtoBuf.Callable, Name>(){

                @Override
                public Name invoke(@NotNull ProtoBuf.Callable callable2) {
                    if (callable2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors$3", "invoke"));
                    }
                    return nameResolver.getName(callable2.getName());
                }
            });
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "computeEnumMemberNames"));
            }
            return hashSet;
        }

        @NotNull
        public Collection<ClassDescriptor> getAllDescriptors() {
            ClassDescriptor descriptor;
            ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(this.nestedClassNames.size() + this.enumEntryNames.size());
            for (Name name : this.nestedClassNames) {
                descriptor = (ClassDescriptor)this.findClass.invoke(name);
                if (descriptor == null) continue;
                result.add(descriptor);
            }
            for (Name name : this.enumEntryNames) {
                descriptor = (ClassDescriptor)this.findClass.invoke(name);
                if (descriptor == null) continue;
                result.add(descriptor);
            }
            ArrayList<ClassDescriptor> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$NestedClassDescriptors", "getAllDescriptors"));
            }
            return arrayList;
        }
    }

    private static class DeserializedClassMemberScope
    extends DeserializedMemberScope {
        private final DeserializedClassDescriptor classDescriptor;

        public DeserializedClassMemberScope(@NotNull StorageManager storageManager, @NotNull DeserializedClassDescriptor classDescriptor) {
            if (storageManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "<init>"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "<init>"));
            }
            super(storageManager, classDescriptor, classDescriptor.deserializer, classDescriptor.classProto.getMemberList());
            this.classDescriptor = classDescriptor;
        }

        @Override
        protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredFunctions"));
            }
            if (functions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functions", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredFunctions"));
            }
            ArrayList<FunctionDescriptor> fromSupertypes = new ArrayList<FunctionDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getFunctions(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, functions);
        }

        @Override
        protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> property2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredProperties"));
            }
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "computeNonDeclaredProperties"));
            }
            ArrayList<VariableDescriptor> fromSupertypes = new ArrayList<VariableDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getProperties(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, property2);
        }

        private <D extends CallableMemberDescriptor> void generateFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes, final @NotNull Collection<D> result) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            if (fromSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSupertypes", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "generateFakeOverrides"));
            }
            ArrayList<D> fromCurrent = new ArrayList<D>(result);
            OverridingUtil.generateOverridesInFunctionGroup(name, fromSupertypes, fromCurrent, this.classDescriptor, new OverridingUtil.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeOverride", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "addToScope"));
                    }
                    OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new OverridingUtil.NotInferredVisibilitySink(){

                        @Override
                        public void cannotInferVisibility(@NotNull CallableMemberDescriptor descriptor) {
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1$1", "cannotInferVisibility"));
                            }
                        }
                    });
                    result.add(fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    if (fromSuper == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromSuper", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "conflict"));
                    }
                    if (fromCurrent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromCurrent", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope$1", "conflict"));
                    }
                }
            });
        }

        @Override
        protected void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "addNonDeclaredDescriptors"));
            }
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                    if (descriptor instanceof FunctionDescriptor) {
                        result.addAll(this.getFunctions(descriptor.getName()));
                        continue;
                    }
                    if (!(descriptor instanceof PropertyDescriptor)) continue;
                    result.addAll(this.getProperties(descriptor.getName()));
                }
            }
        }

        @Override
        @Nullable
        protected ReceiverParameterDescriptor getImplicitReceiver() {
            return this.classDescriptor.getThisAsReceiverParameter();
        }

        @Override
        @Nullable
        protected ClassifierDescriptor getClassDescriptor(@NotNull Name name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "getClassDescriptor"));
            }
            return (ClassifierDescriptor)this.classDescriptor.nestedClasses.findClass.invoke(name);
        }

        @Override
        protected void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassMemberScope", "addAllClassDescriptors"));
            }
            result.addAll(this.classDescriptor.nestedClasses.getAllDescriptors());
        }
    }

    private class DeserializedClassTypeConstructor
    implements TypeConstructor {
        private final Collection<JetType> supertypes;
        private final List<TypeParameterDescriptor> parameters;

        public DeserializedClassTypeConstructor(@NotNull List<TypeParameterDescriptor> typeParameters) {
            if (typeParameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "<init>"));
            }
            this.supertypes = DeserializedClassDescriptor.this.computeSuperTypes();
            this.parameters = typeParameters;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List<TypeParameterDescriptor> list2 = this.parameters;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getParameters"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = this.supertypes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        @Override
        public boolean isFinal() {
            return !DeserializedClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return DeserializedClassDescriptor.this;
        }

        @Override
        @NotNull
        public List<AnnotationDescriptor> getAnnotations() {
            List<AnnotationDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/descriptors/DeserializedClassDescriptor$DeserializedClassTypeConstructor", "getAnnotations"));
            }
            return list2;
        }

        public String toString() {
            return DeserializedClassDescriptor.this.getName().toString();
        }
    }
}

