/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.Interner;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class NameTable {
    public static final TObjectHashingStrategy<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> QUALIFIED_NAME_BUILDER_HASHING = new TObjectHashingStrategy<ProtoBuf.QualifiedNameTable.QualifiedName.Builder>(){

        @Override
        public int computeHashCode(ProtoBuf.QualifiedNameTable.QualifiedName.Builder object2) {
            int result = 13;
            result = 31 * result + object2.getParentQualifiedName();
            result = 31 * result + object2.getShortName();
            result = 31 * result + object2.getKind().hashCode();
            return result;
        }

        @Override
        public boolean equals(ProtoBuf.QualifiedNameTable.QualifiedName.Builder o1, ProtoBuf.QualifiedNameTable.QualifiedName.Builder o2) {
            return o1.getParentQualifiedName() == o2.getParentQualifiedName() && o1.getShortName() == o2.getShortName() && o1.getKind() == o2.getKind();
        }
    };
    private final Interner<String> simpleNames = new Interner();
    private final Interner<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> qualifiedNames = new Interner<ProtoBuf.QualifiedNameTable.QualifiedName.Builder>(QUALIFIED_NAME_BUILDER_HASHING);

    @NotNull
    public List<String> getSimpleNames() {
        List<String> list2 = this.simpleNames.getAllInternedObjects();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameTable", "getSimpleNames"));
        }
        return list2;
    }

    @NotNull
    public List<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> getFqNames() {
        List<ProtoBuf.QualifiedNameTable.QualifiedName.Builder> list2 = this.qualifiedNames.getAllInternedObjects();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/NameTable", "getFqNames"));
        }
        return list2;
    }

    public int getSimpleNameIndex(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/descriptors/serialization/NameTable", "getSimpleNameIndex"));
        }
        return this.simpleNames.intern(name.asString());
    }

    public int getFqNameIndex(@NotNull ClassOrNamespaceDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/NameTable", "getFqNameIndex"));
        }
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        if (descriptor instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        }
        builder.setShortName(this.getSimpleNameIndex(descriptor.getName()));
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)containingDeclaration;
            if (!fragment.getFqName().isRoot()) {
                builder.setParentQualifiedName(this.getFqNameIndex(fragment.getFqName()));
            }
        } else if (containingDeclaration instanceof ClassDescriptor) {
            ClassDescriptor outerClass = (ClassDescriptor)containingDeclaration;
            builder.setParentQualifiedName(this.getFqNameIndex(outerClass));
        } else {
            throw new IllegalStateException("FQ names are only stored for top-level or inner classes: " + descriptor);
        }
        return this.qualifiedNames.intern(builder);
    }

    public int getFqNameIndex(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/descriptors/serialization/NameTable", "getFqNameIndex"));
        }
        int result = -1;
        for (Name segment : fqName.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            builder.setShortName(this.getSimpleNameIndex(segment));
            if (result != -1) {
                builder.setParentQualifiedName(result);
            }
            result = this.qualifiedNames.intern(builder);
        }
        return result;
    }
}

