/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ExpressionCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.psi.JetExpression;

public class UnaryMinus
extends IntrinsicMethod {
    @Override
    @NotNull
    public Type generateImpl(@NotNull ExpressionCodegen codegen, @NotNull InstructionAdapter v, @NotNull Type returnType, PsiElement element, List<JetExpression> arguments2, StackValue receiver) {
        if (codegen == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegen", "org/jetbrains/jet/codegen/intrinsics/UnaryMinus", "generateImpl"));
        }
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/intrinsics/UnaryMinus", "generateImpl"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/jet/codegen/intrinsics/UnaryMinus", "generateImpl"));
        }
        assert (AsmUtil.isPrimitive(returnType)) : "Return type of UnaryMinus intrinsic should be of primitive type: " + returnType;
        Type operandType = AsmUtil.numberFunctionOperandType(returnType);
        if (arguments2.size() == 1) {
            codegen.gen(arguments2.get(0), operandType);
        } else {
            receiver.put(operandType, v);
        }
        Type type = AsmUtil.genNegate(returnType, v);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/intrinsics/UnaryMinus", "generateImpl"));
        }
        return type;
    }
}

