/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.jet.asJava.LightClassConstructionContext;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class CliLightClassGenerationSupport
extends LightClassGenerationSupport {
    private BindingTrace trace;
    private ModuleDescriptorImpl module;

    public static CliLightClassGenerationSupport getInstanceForCli(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getInstanceForCli"));
        }
        return ServiceManager.getService(project, CliLightClassGenerationSupport.class);
    }

    @NotNull
    public BindingTrace getTrace() {
        if (this.trace == null) {
            this.trace = new BindingTraceContextWithoutScopeRecording();
        }
        BindingTrace bindingTrace = this.trace;
        if (bindingTrace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getTrace"));
        }
        return bindingTrace;
    }

    @NotNull
    public ModuleDescriptorImpl getModule() {
        if (this.module == null) {
            this.module = AnalyzerFacadeForJVM.createJavaModule("<module>");
        }
        ModuleDescriptorImpl moduleDescriptorImpl = this.module;
        if (moduleDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getModule"));
        }
        return moduleDescriptorImpl;
    }

    public void setModule(@NotNull ModuleDescriptorImpl module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "setModule"));
        }
        assert (this.module == null) : "module already configured: " + module;
        this.module = module;
    }

    public void newBindingTrace() {
        this.trace = null;
        this.module = null;
    }

    private LightClassConstructionContext analyzeRelevantCode() {
        return new LightClassConstructionContext(this.getTrace().getBindingContext(), null);
    }

    @Override
    @NotNull
    public LightClassConstructionContext analyzeRelevantCode(@NotNull Collection<JetFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "analyzeRelevantCode"));
        }
        LightClassConstructionContext lightClassConstructionContext = this.analyzeRelevantCode();
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "analyzeRelevantCode"));
        }
        return lightClassConstructionContext;
    }

    @Override
    @NotNull
    public LightClassConstructionContext analyzeRelevantCode(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "analyzeRelevantCode"));
        }
        LightClassConstructionContext lightClassConstructionContext = this.analyzeRelevantCode();
        if (lightClassConstructionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "analyzeRelevantCode"));
        }
        return lightClassConstructionContext;
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName, @NotNull GlobalSearchScope searchScope) {
        PsiElement element;
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        ClassDescriptor classDescriptor = this.getTrace().get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, fqName.toUnsafe());
        if (classDescriptor != null && (element = BindingContextUtils.classDescriptorToDeclaration(this.trace.getBindingContext(), classDescriptor)) != null && PsiSearchScopeUtil.isInScope(searchScope, element)) {
            List<JetClassOrObject> list2 = Collections.singletonList((JetClassOrObject)element);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
            }
            return list2;
        }
        if (JvmAbi.isClassObjectFqName(fqName)) {
            Collection<JetClassOrObject> parentClasses = this.findClassOrObjectDeclarations(fqName.parent(), searchScope);
            List<JetClassOrObject> list3 = ContainerUtil.mapNotNull(parentClasses, new Function<JetClassOrObject, JetClassOrObject>(){

                @Override
                public JetClassOrObject fun(JetClassOrObject classOrObject) {
                    JetClass jetClass;
                    JetClassObject classObject;
                    if (classOrObject instanceof JetClass && (classObject = (jetClass = (JetClass)classOrObject).getClassObject()) != null) {
                        return classObject.getObjectDeclaration();
                    }
                    return null;
                }
            });
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
            }
            return list3;
        }
        List<JetClassOrObject> list4 = Collections.emptyList();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarations"));
        }
        return list4;
    }

    @Override
    @NotNull
    public Collection<JetFile> findFilesForPackage(@NotNull FqName fqName, final @NotNull GlobalSearchScope searchScope) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
        }
        Collection<JetFile> files = this.getTrace().get(BindingContext.PACKAGE_TO_FILES, fqName);
        if (files != null) {
            Collection<JetFile> collection = Collections2.filter(files, new Predicate<JetFile>(){

                @Override
                public boolean apply(JetFile input) {
                    return PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)input);
                }
            });
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
            }
            return collection;
        }
        List<JetFile> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findFilesForPackage"));
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<JetClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        Collection<JetFile> files = this.findFilesForPackage(packageFqName, searchScope);
        SmartList<JetClassOrObject> result = new SmartList<JetClassOrObject>();
        for (JetFile file : files) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetClassOrObject)) continue;
                result.add((JetClassOrObject)declaration);
            }
        }
        SmartList<JetClassOrObject> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "findClassOrObjectDeclarationsInPackage"));
        }
        return smartList;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName, @NotNull GlobalSearchScope scope) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "packageExists"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "packageExists"));
        }
        return this.getModule().getPackage(fqName) != null;
    }

    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqn", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
        }
        PackageViewDescriptor packageView = this.getModule().getPackage(fqn);
        if (packageView == null) {
            List<FqName> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
            }
            return list2;
        }
        Collection<DeclarationDescriptor> members = packageView.getMemberScope().getAllDescriptors();
        List<FqName> list3 = ContainerUtil.mapNotNull(members, new Function<DeclarationDescriptor, FqName>(){

            @Override
            public FqName fun(DeclarationDescriptor member) {
                if (member instanceof PackageViewDescriptor) {
                    return ((PackageViewDescriptor)member).getFqName();
                }
                return null;
            }
        });
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getSubPackages"));
        }
        return list3;
    }

    @Override
    @Nullable
    public PsiClass getPsiClass(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/cli/jvm/compiler/CliLightClassGenerationSupport", "getPsiClass"));
        }
        return KotlinLightClassForExplicitDeclaration.create(classOrObject.getManager(), classOrObject);
    }

    public static class BindingTraceContextWithoutScopeRecording
    extends BindingTraceContext {
        @Override
        public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
            if (slice == BindingContext.RESOLUTION_SCOPE || slice == BindingContext.TYPE_RESOLUTION_SCOPE) {
                return;
            }
            super.record(slice, key, value);
        }

        public String toString() {
            return "Filtering trace for the CLI compiler: does not save scopes";
        }
    }
}

