/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SLRUCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.FakeLightClassForFileOfPackage;
import org.jetbrains.jet.asJava.JetLightPackage;
import org.jetbrains.jet.asJava.KotlinLightClassForPackage;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.util.QualifiedNamesUtil;

public class JavaElementFinder
extends PsiElementFinder
implements JavaPsiFacadeKotlinHacks.KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private final LightClassGenerationSupport lightClassGenerationSupport;
    private final CachedValue<SLRUCache<FindClassesRequest, PsiClass[]>> findClassesCache;

    @NotNull
    public static JavaElementFinder getInstance(@NotNull Project project) {
        PsiElementFinder[] extensions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/asJava/JavaElementFinder", "getInstance"));
        }
        for (PsiElementFinder extension : extensions = Extensions.getArea(project).getExtensionPoint(PsiElementFinder.EP_NAME).getExtensions()) {
            if (!(extension instanceof JavaElementFinder)) continue;
            JavaElementFinder javaElementFinder = (JavaElementFinder)extension;
            if (javaElementFinder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/JavaElementFinder", "getInstance"));
            }
            return javaElementFinder;
        }
        throw new IllegalStateException(JavaElementFinder.class.getSimpleName() + " is not found for project " + project);
    }

    public JavaElementFinder(@NotNull Project project, @NotNull LightClassGenerationSupport lightClassGenerationSupport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/asJava/JavaElementFinder", "<init>"));
        }
        if (lightClassGenerationSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lightClassGenerationSupport", "org/jetbrains/jet/asJava/JavaElementFinder", "<init>"));
        }
        this.project = project;
        this.psiManager = PsiManager.getInstance(project);
        this.lightClassGenerationSupport = lightClassGenerationSupport;
        this.findClassesCache = CachedValuesManager.getManager(project).createCachedValue(new CachedValueProvider<SLRUCache<FindClassesRequest, PsiClass[]>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<SLRUCache<FindClassesRequest, PsiClass[]>> compute() {
                return new CachedValueProvider.Result<SLRUCache<FindClassesRequest, PsiClass[]>>(new SLRUCache<FindClassesRequest, PsiClass[]>(30, 10){

                    @Override
                    @NotNull
                    public PsiClass[] createValue(FindClassesRequest key) {
                        PsiClass[] psiClassArray = JavaElementFinder.this.doFindClasses(key.fqName, key.scope);
                        if (psiClassArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/JavaElementFinder$1$1", "createValue"));
                        }
                        return psiClassArray;
                    }
                }, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            }
        }, false);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/jet/asJava/JavaElementFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/asJava/JavaElementFinder", "findClass"));
        }
        PsiClass[] allClasses = this.findClasses(qualifiedName, scope);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        SLRUCache<FindClassesRequest, PsiClass[]> value;
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/jet/asJava/JavaElementFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/asJava/JavaElementFinder", "findClasses"));
        }
        SLRUCache<FindClassesRequest, PsiClass[]> sLRUCache = value = this.findClassesCache.getValue();
        // MONITORENTER : sLRUCache
        PsiClass[] psiClassArray = value.get(new FindClassesRequest(qualifiedNameString, scope));
        // MONITOREXIT : sLRUCache
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/JavaElementFinder", "findClasses"));
    }

    private PsiClass[] doFindClasses(String qualifiedNameString, GlobalSearchScope scope) {
        if (!QualifiedNamesUtil.isValidJavaFqName(qualifiedNameString)) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope, answer);
        if (PackageClassUtils.isPackageClassFqName(qualifiedName)) {
            this.findPackageClass(qualifiedName.parent(), scope, answer);
        }
        return answer.toArray(new PsiClass[answer.size()]);
    }

    private void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        Collection<JetClassOrObject> classOrObjectDeclarations = this.lightClassGenerationSupport.findClassOrObjectDeclarations(qualifiedName, scope);
        for (JetClassOrObject declaration : classOrObjectDeclarations) {
            PsiClass lightClass;
            if (declaration instanceof JetEnumEntry || (lightClass = LightClassUtil.getPsiClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private void findPackageClass(FqName qualifiedName, GlobalSearchScope scope, List<PsiClass> answer) {
        KotlinLightClassForPackage lightClass;
        Collection<JetFile> filesForPackage = this.lightClassGenerationSupport.findFilesForPackage(qualifiedName, scope);
        if (!filesForPackage.isEmpty() && NamespaceCodegen.shouldGenerateNSClass(filesForPackage) && (lightClass = KotlinLightClassForPackage.create(this.psiManager, qualifiedName, scope, filesForPackage)) != null) {
            answer.add(lightClass);
            if (filesForPackage.size() > 1) {
                for (JetFile file : filesForPackage) {
                    FakeLightClassForFileOfPackage fakeLightClass = new FakeLightClassForFileOfPackage(this.psiManager, lightClass, file);
                    answer.add(fakeLightClass);
                }
            }
        }
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/jet/asJava/JavaElementFinder", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/asJava/JavaElementFinder", "getClassNames"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<JetClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        HashSet<String> answer = Sets.newHashSet();
        answer.add(PackageClassUtils.getPackageClassName(packageFQN));
        for (JetClassOrObject declaration : declarations) {
            String name = declaration.getName();
            if (name == null) continue;
            answer.add(name);
        }
        HashSet<String> hashSet = answer;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/JavaElementFinder", "getClassNames"));
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (qualifiedNameString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedNameString", "org/jetbrains/jet/asJava/JavaElementFinder", "findPackage"));
        }
        if (!QualifiedNamesUtil.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName = new FqName(qualifiedNameString);
        GlobalSearchScope allScope = GlobalSearchScope.allScope(this.project);
        if (this.lightClassGenerationSupport.packageExists(fqName, allScope)) {
            return new JetLightPackage(this.psiManager, fqName, allScope);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, final @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/jet/asJava/JavaElementFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/asJava/JavaElementFinder", "getSubPackages"));
        }
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<FqName> subpackages = this.lightClassGenerationSupport.getSubPackages(packageFQN, scope);
        Collection<PsiPackage> answer = Collections2.transform(subpackages, new Function<FqName, PsiPackage>(){

            @Override
            public PsiPackage apply(@Nullable FqName input) {
                return new JetLightPackage(JavaElementFinder.this.psiManager, input, scope);
            }
        });
        PsiPackage[] psiPackageArray = answer.toArray(new PsiPackage[answer.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/JavaElementFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/jet/asJava/JavaElementFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/asJava/JavaElementFinder", "getClasses"));
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        this.findPackageClass(packageFQN, scope, answer);
        Collection<JetClassOrObject> declarations = this.lightClassGenerationSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope);
        for (JetClassOrObject declaration : declarations) {
            PsiClass aClass = LightClassUtil.getPsiClass(declaration);
            if (aClass == null) continue;
            answer.add(aClass);
        }
        PsiClass[] psiClassArray = answer.toArray(new PsiClass[answer.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/asJava/JavaElementFinder", "getClasses"));
        }
        return psiClassArray;
    }

    private static class FindClassesRequest {
        private final String fqName;
        private final GlobalSearchScope scope;

        private FindClassesRequest(@NotNull String fqName, @NotNull GlobalSearchScope scope) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/asJava/JavaElementFinder$FindClassesRequest", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/asJava/JavaElementFinder$FindClassesRequest", "<init>"));
            }
            this.fqName = fqName;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FindClassesRequest request = (FindClassesRequest)o;
            if (!this.fqName.equals(request.fqName)) {
                return false;
            }
            return this.scope.equals(request.scope);
        }

        public int hashCode() {
            int result = this.fqName.hashCode();
            result = 31 * result + this.scope.hashCode();
            return result;
        }
    }
}

