/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.intellij.util.SmartList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.k2js.translate.context.TemporaryConstVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AbstractCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallBuilder;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.InlinedCallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class CallExpressionTranslator
extends AbstractCallExpressionTranslator {
    private final boolean isNativeFunctionCall = AnnotationsUtils.isNativeObject(this.resolvedCall.getCandidateDescriptor());
    private boolean hasSpreadOperator = false;
    private TemporaryConstVariable cachedReceiver = null;
    private List<JsExpression> translatedArguments = null;
    private JsExpression translatedReceiver = null;
    private JsExpression translatedCallee = null;

    @NotNull
    public static JsExpression translate(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (InlinedCallExpressionTranslator.shouldBeInlined(expression, context)) {
            return InlinedCallExpressionTranslator.translate(expression, receiver, callType, context);
        }
        return new CallExpressionTranslator(expression, receiver, callType, context).translate();
    }

    private CallExpressionTranslator(@NotNull JetCallExpression expression, @Nullable JsExpression receiver, @NotNull CallType callType, @NotNull TranslationContext context) {
        super(expression, receiver, callType, context);
    }

    @NotNull
    private JsExpression translate() {
        this.prepareToBuildCall();
        return CallBuilder.build(this.context()).receiver(this.translatedReceiver).callee(this.translatedCallee).args(this.translatedArguments).resolvedCall(this.getResolvedCall()).type(this.callType).translate();
    }

    private void prepareToBuildCall() {
        this.translatedArguments = this.translateArguments();
        this.translatedReceiver = this.getReceiver();
        this.translatedCallee = this.getCalleeExpression();
    }

    @NotNull
    private ResolvedCall<?> getResolvedCall() {
        if (this.resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)this.resolvedCall).getFunctionCall();
        }
        return this.resolvedCall;
    }

    @Nullable
    private JsExpression getReceiver() {
        assert (this.translatedArguments != null) : "the results of this function depends on the results of translateArguments()";
        if (this.receiver == null) {
            return null;
        }
        if (this.cachedReceiver != null) {
            return this.cachedReceiver.assignmentExpression();
        }
        return this.receiver;
    }

    @Nullable
    private JsExpression getCalleeExpression() {
        assert (this.translatedArguments != null) : "the results of this function depends on the results of translateArguments()";
        if (this.isNativeFunctionCall && this.hasSpreadOperator) {
            String functionName = this.resolvedCall.getCandidateDescriptor().getOriginal().getName().getIdentifier();
            return new JsNameRef("apply", functionName);
        }
        Object candidateDescriptor = this.resolvedCall.getCandidateDescriptor();
        if (candidateDescriptor instanceof ExpressionAsFunctionDescriptor) {
            return this.translateExpressionAsFunction();
        }
        if (this.resolvedCall instanceof VariableAsFunctionResolvedCall) {
            return this.translateVariableForVariableAsFunctionResolvedCall();
        }
        return null;
    }

    @NotNull
    private JsExpression translateVariableForVariableAsFunctionResolvedCall() {
        JetExpression callee = PsiUtils.getCallee(this.expression);
        if (callee instanceof JetSimpleNameExpression) {
            return ReferenceTranslator.getAccessTranslator((JetSimpleNameExpression)callee, this.receiver, this.context()).translateAsGet();
        }
        assert (this.receiver != null);
        return Translation.translateAsExpression(callee, this.context());
    }

    @NotNull
    private JsExpression translateExpressionAsFunction() {
        return Translation.translateAsExpression(PsiUtils.getCallee(this.expression), this.context());
    }

    @NotNull
    private List<JsExpression> translateArguments() {
        List<ValueParameterDescriptor> valueParameters = this.resolvedCall.getResultingDescriptor().getValueParameters();
        if (valueParameters.isEmpty()) {
            return Collections.emptyList();
        }
        AbstractList result = new ArrayList<JsExpression>(valueParameters.size());
        List<ResolvedValueArgument> valueArgumentsByIndex = this.resolvedCall.getValueArgumentsByIndex();
        AbstractList argsBeforeVararg = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                assert (!this.hasSpreadOperator);
                List<ValueArgument> arguments = actualArgument.getArguments();
                boolean bl = this.hasSpreadOperator = arguments.size() == 1 && arguments.get(0).getSpreadElement() != null;
                if (this.isNativeFunctionCall && this.hasSpreadOperator) {
                    assert (argsBeforeVararg == null);
                    argsBeforeVararg = result;
                    result = new SmartList();
                }
            }
            this.translateSingleArgument(actualArgument, parameterDescriptor, result);
        }
        if (this.isNativeFunctionCall && this.hasSpreadOperator) {
            assert (argsBeforeVararg != null);
            if (!argsBeforeVararg.isEmpty()) {
                JsInvocation concatArguments = new JsInvocation((JsExpression)new JsNameRef("concat", (JsExpression)new JsArrayLiteral(argsBeforeVararg)), result);
                result = new SmartList<JsInvocation>(concatArguments);
            }
            if (this.receiver != null) {
                this.cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                result.add(0, this.cachedReceiver.reference());
            } else {
                result.add(0, JsLiteral.NULL);
            }
        }
        return result;
    }

    @Override
    public boolean shouldWrapVarargInArray() {
        return !this.isNativeFunctionCall && !this.hasSpreadOperator;
    }
}

