/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import com.google.dart.compiler.backend.js.ast.JsDocComment;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.LabelGenerator;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.ClassAliasingMap;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.declaration.PropertyTranslator;
import org.jetbrains.k2js.translate.expression.LiteralFunctionTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.initializer.ClassInitializerTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class ClassTranslator
extends AbstractTranslator {
    @NotNull
    private final JetClassOrObject classDeclaration;
    @NotNull
    private final ClassDescriptor descriptor;
    @Nullable
    private final ClassAliasingMap aliasingMap;

    @NotNull
    public static JsInvocation generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, null, context).translate();
    }

    @NotNull
    public static JsInvocation generateClassCreation(@NotNull JetClassOrObject classDeclaration, @NotNull ClassDescriptor descriptor, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, descriptor, null, context).translate();
    }

    @NotNull
    public static JsExpression generateObjectLiteral(@NotNull JetObjectDeclaration objectDeclaration, @NotNull TranslationContext context) {
        return new ClassTranslator(objectDeclaration, null, context).translateObjectLiteralExpression();
    }

    @NotNull
    public static JsExpression generateObjectLiteral(@NotNull JetObjectDeclaration objectDeclaration, @NotNull ClassDescriptor descriptor, @NotNull TranslationContext context) {
        return new ClassTranslator(objectDeclaration, descriptor, null, context).translateObjectLiteralExpression();
    }

    ClassTranslator(@NotNull JetClassOrObject classDeclaration, @Nullable ClassAliasingMap aliasingMap, @NotNull TranslationContext context) {
        this(classDeclaration, BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration), aliasingMap, context);
    }

    ClassTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull ClassDescriptor descriptor, @Nullable ClassAliasingMap aliasingMap, @NotNull TranslationContext context) {
        super(context);
        this.aliasingMap = aliasingMap;
        this.descriptor = descriptor;
        this.classDeclaration = classDeclaration;
    }

    @NotNull
    private JsExpression translateObjectLiteralExpression() {
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        if (containingClass == null) {
            return this.translate(this.context());
        }
        return this.context().literalFunctionTranslator().translate(containingClass, this.context(), this.classDeclaration, this.descriptor, this);
    }

    @NotNull
    public JsInvocation translate() {
        return this.translate(this.context());
    }

    @NotNull
    public JsInvocation translate(@NotNull TranslationContext declarationContext) {
        JsInvocation createInvocation = this.context().namer().classCreateInvocation(this.descriptor);
        this.translate(createInvocation, declarationContext);
        return createInvocation;
    }

    private void translate(@NotNull JsInvocation createInvocation, @NotNull TranslationContext context) {
        this.addSuperclassReferences(createInvocation);
        this.addClassOwnDeclarations(createInvocation.getArguments(), context);
    }

    private boolean isTrait() {
        return this.descriptor.getKind().equals((Object)ClassKind.TRAIT);
    }

    private void addClassOwnDeclarations(@NotNull List<JsExpression> invocationArguments, @NotNull TranslationContext declarationContext) {
        boolean hasStaticProperties;
        JsNameRef qualifiedReference;
        boolean isTopLevelDeclaration;
        final SmartList<JsPropertyInitializer> properties = new SmartList<JsPropertyInitializer>();
        final SmartList<JsPropertyInitializer> staticProperties = new SmartList<JsPropertyInitializer>();
        boolean bl = isTopLevelDeclaration = this.context() == declarationContext;
        if (!isTopLevelDeclaration) {
            qualifiedReference = null;
        } else if (this.descriptor.getKind().isObject()) {
            qualifiedReference = null;
            declarationContext.literalFunctionTranslator().setDefinitionPlace(new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

                @Override
                @NotNull
                public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                    return LiteralFunctionTranslator.createPlace(properties, ClassTranslator.this.context().getThisObject(ClassTranslator.this.descriptor));
                }
            });
        } else {
            qualifiedReference = declarationContext.getQualifiedReference(this.descriptor);
            declarationContext.literalFunctionTranslator().setDefinitionPlace(new NotNullLazyValue<Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression>>(){

                @Override
                @NotNull
                public Trinity<List<JsPropertyInitializer>, LabelGenerator, JsExpression> compute() {
                    return LiteralFunctionTranslator.createPlace(staticProperties, qualifiedReference);
                }
            });
        }
        if (!this.isTrait()) {
            JsFunction initializer = new ClassInitializerTranslator(this.classDeclaration, declarationContext).generateInitializeMethod();
            if (this.context().isEcma5()) {
                invocationArguments.add(initializer.getBody().getStatements().isEmpty() ? JsLiteral.NULL : initializer);
            } else {
                properties.add(new JsPropertyInitializer(Namer.initializeMethodReference(), initializer));
            }
        }
        this.translatePropertiesAsConstructorParameters(declarationContext, properties);
        DeclarationBodyVisitor bodyVisitor = new DeclarationBodyVisitor(properties, staticProperties);
        bodyVisitor.traverseContainer(this.classDeclaration, declarationContext);
        this.mayBeAddEnumEntry(bodyVisitor.getEnumEntryList(), staticProperties, declarationContext);
        if (isTopLevelDeclaration) {
            declarationContext.literalFunctionTranslator().setDefinitionPlace(null);
        }
        boolean bl2 = hasStaticProperties = !staticProperties.isEmpty();
        if (!properties.isEmpty() || hasStaticProperties) {
            if (properties.isEmpty()) {
                invocationArguments.add(JsLiteral.NULL);
            } else {
                if (qualifiedReference != null) {
                    invocationArguments.add(new JsDocComment("lends", new JsNameRef("prototype", (JsExpression)qualifiedReference)));
                }
                invocationArguments.add(new JsObjectLiteral(properties, true));
            }
        }
        if (hasStaticProperties) {
            invocationArguments.add(new JsDocComment("lends", qualifiedReference));
            invocationArguments.add(new JsObjectLiteral(staticProperties, true));
        }
    }

    private void mayBeAddEnumEntry(@NotNull List<JsPropertyInitializer> enumEntryList, @NotNull List<JsPropertyInitializer> staticProperties, @NotNull TranslationContext declarationContext) {
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS) {
            JsInvocation invocation = this.context().namer().enumEntriesObjectCreateInvocation();
            invocation.getArguments().add(new JsObjectLiteral(enumEntryList, true));
            JsFunction fun = TranslationUtils.simpleReturnFunction(declarationContext.getScopeForDescriptor(this.descriptor), invocation);
            staticProperties.add(InitializerUtils.createPropertyInitializer(Namer.getNamedForClassObjectInitializer(), fun, declarationContext));
        } else assert (enumEntryList.isEmpty()) : "Only enum class may have enum entry. Class kind is: " + (Object)((Object)this.descriptor.getKind());
    }

    private void addSuperclassReferences(@NotNull JsInvocation jsClassDeclaration) {
        List<JsExpression> expressions;
        List<JsExpression> superClassReferences = this.getSupertypesNameReferences();
        if (superClassReferences.isEmpty()) {
            if (!this.isTrait() || this.context().isEcma5()) {
                jsClassDeclaration.getArguments().add(JsLiteral.NULL);
            }
            return;
        }
        if (superClassReferences.size() > 1) {
            JsArrayLiteral arrayLiteral = new JsArrayLiteral();
            jsClassDeclaration.getArguments().add(arrayLiteral);
            expressions = arrayLiteral.getExpressions();
        } else {
            expressions = jsClassDeclaration.getArguments();
        }
        for (JsExpression superClassReference : superClassReferences) {
            expressions.add(superClassReference);
        }
    }

    @NotNull
    private List<JsExpression> getSupertypesNameReferences() {
        Collection<JetType> supertypes = this.descriptor.getTypeConstructor().getSupertypes();
        if (supertypes.isEmpty()) {
            return Collections.emptyList();
        }
        JsNameRef base = null;
        ArrayList<JsNameRef> list = null;
        block5: for (JetType type : supertypes) {
            ClassDescriptor result = DescriptorUtils.getClassDescriptorForType(type);
            if (!DescriptorUtils.isNotAny(result) || AnnotationsUtils.isNativeObject(result)) continue;
            switch (result.getKind()) {
                case CLASS: {
                    base = this.getClassReference(result);
                    continue block5;
                }
                case TRAIT: {
                    if (list == null) {
                        list = new ArrayList<JsNameRef>();
                    }
                    list.add(this.getClassReference(result));
                    continue block5;
                }
                case ENUM_CLASS: {
                    base = this.getClassReference(result);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("unsupported super class kind " + result.getKind().name());
        }
        if (list == null) {
            return base == null ? Collections.emptyList() : Collections.singletonList(base);
        }
        if (base != null) {
            list.add(0, base);
        }
        return list;
    }

    @NotNull
    private JsNameRef getClassReference(@NotNull ClassDescriptor superClassDescriptor) {
        JsNameRef name;
        if (this.aliasingMap != null && (name = this.aliasingMap.get(superClassDescriptor, this.descriptor)) != null) {
            return name;
        }
        return this.context().getQualifiedReference(superClassDescriptor);
    }

    private void translatePropertiesAsConstructorParameters(@NotNull TranslationContext classDeclarationContext, @NotNull List<JsPropertyInitializer> result) {
        for (JetParameter parameter : PsiUtils.getPrimaryConstructorParameters(this.classDeclaration)) {
            PropertyDescriptor descriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), parameter);
            if (descriptor == null) continue;
            PropertyTranslator.translateAccessors(descriptor, result, classDeclarationContext);
        }
    }
}

