/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsName;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;

public class AliasingContext {
    private static final AliasingContext ROOT = new AliasingContext(null){

        @Override
        protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
            return null;
        }

        @Override
        public JsName getAliasForExpression(@NotNull JetExpression element) {
            return null;
        }

        @Override
        public void registerAlias(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
            throw new IllegalStateException();
        }
    };
    @Nullable
    private Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<JetExpression, JsName> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    public static AliasingContext getCleanContext() {
        return new AliasingContext(ROOT);
    }

    AliasingContext(@Nullable AliasingContext parent) {
        this(parent, null, null);
    }

    private AliasingContext(@Nullable AliasingContext parent, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<JetExpression, JsName> aliasesForExpressions) {
        this.parent = parent;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        return new AliasingContext(this, Collections.singletonMap(descriptor, alias), null);
    }

    @NotNull
    public AliasingContext notShareableThisAliased(final @NotNull DeclarationDescriptor thisDescriptor, final @NotNull JsExpression alias) {
        return new AliasingContext(this){

            @Override
            @Nullable
            protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
                if (!fromChild && thisDescriptor == descriptor) {
                    return alias;
                }
                return super.getAliasForDescriptor(descriptor, fromChild);
            }
        };
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<JetExpression, JsName> aliasesForExpressions) {
        return new AliasingContext(this, null, aliasesForExpressions);
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        return new AliasingContext(this, aliases, null);
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        return this.getAliasForDescriptor(descriptor, false);
    }

    @Nullable
    protected JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor, boolean fromChild) {
        JsExpression alias = this.aliasesForDescriptors == null ? null : this.aliasesForDescriptors.get(descriptor.getOriginal());
        return alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor, true);
    }

    @Nullable
    public JsName getAliasForExpression(@NotNull JetExpression element) {
        JsName alias = this.aliasesForExpressions == null ? null : this.aliasesForExpressions.get(element);
        return alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element);
    }

    public void registerAlias(@NotNull DeclarationDescriptor descriptor, @NotNull JsExpression alias) {
        if (this.aliasesForDescriptors == null) {
            this.aliasesForDescriptors = Collections.singletonMap(descriptor, alias);
        } else {
            if (this.aliasesForDescriptors.size() == 1) {
                Map<DeclarationDescriptor, JsExpression> singletonMap = this.aliasesForDescriptors;
                this.aliasesForDescriptors = new THashMap<DeclarationDescriptor, JsExpression>();
                this.aliasesForDescriptors.put(singletonMap.keySet().iterator().next(), singletonMap.values().iterator().next());
            }
            JsExpression prev = this.aliasesForDescriptors.put(descriptor, alias);
            assert (prev == null);
        }
    }
}

