/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemWithPriorities;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class TypeUtils {
    public static final JetType NO_EXPECTED_TYPE = new JetType(){

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            throw new IllegalStateException();
        }

        @Override
        public boolean isNullable() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            throw new IllegalStateException();
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            throw new IllegalStateException();
        }

        public String toString() {
            return "NO_EXPECTED_TYPE";
        }
    };

    @NotNull
    public static JetType makeNullable(@NotNull JetType type) {
        return TypeUtils.makeNullableAsSpecified(type, true);
    }

    @NotNull
    public static JetType makeNotNullable(@NotNull JetType type) {
        return TypeUtils.makeNullableAsSpecified(type, false);
    }

    @NotNull
    public static JetType makeNullableAsSpecified(@NotNull JetType type, boolean nullable) {
        if (type.isNullable() == nullable) {
            return type;
        }
        if (ErrorUtils.isErrorType(type)) {
            return type;
        }
        return new JetTypeImpl(type.getAnnotations(), type.getConstructor(), nullable, type.getArguments(), type.getMemberScope());
    }

    public static boolean isIntersectionEmpty(@NotNull JetType typeA, @NotNull JetType typeB) {
        return TypeUtils.intersect(JetTypeChecker.INSTANCE, Sets.newLinkedHashSet(Lists.newArrayList(typeA, typeB))) == null;
    }

    @Nullable
    public static JetType intersect(@NotNull JetTypeChecker typeChecker, @NotNull Set<JetType> types) {
        if (types.isEmpty()) {
            return KotlinBuiltIns.getInstance().getNullableAnyType();
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        boolean allNullable = true;
        boolean nothingTypePresent = false;
        ArrayList<JetType> nullabilityStripped = Lists.newArrayList();
        for (JetType type : types) {
            nothingTypePresent |= KotlinBuiltIns.getInstance().isNothingOrNullableNothing(type);
            allNullable &= type.isNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type));
        }
        if (nothingTypePresent) {
            return allNullable ? KotlinBuiltIns.getInstance().getNullableNothingType() : KotlinBuiltIns.getInstance().getNothingType();
        }
        ArrayList<JetType> resultingTypes = Lists.newArrayList();
        block1: for (JetType type : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type)) {
                for (JetType other : nullabilityStripped) {
                    if (TypeUnifier.mayBeEqual(type, other) || typeChecker.isSubtypeOf(type, other) || typeChecker.isSubtypeOf(other, type)) continue;
                    return null;
                }
                return TypeUtils.makeNullableAsSpecified(type, allNullable);
            }
            for (JetType other : nullabilityStripped) {
                if (((Object)type).equals(other) || !typeChecker.isSubtypeOf(other, type)) continue;
                continue block1;
            }
            for (JetType other : resultingTypes) {
                if (!typeChecker.equalTypes(other, type)) continue;
                continue block1;
            }
            resultingTypes.add(type);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((JetType)resultingTypes.get(0), allNullable);
        }
        List<AnnotationDescriptor> noAnnotations = Collections.emptyList();
        IntersectionTypeConstructor constructor = new IntersectionTypeConstructor(noAnnotations, resultingTypes);
        JetScope[] scopes = new JetScope[resultingTypes.size()];
        int i = 0;
        for (JetType type : resultingTypes) {
            scopes[i] = type.getMemberScope();
            ++i;
        }
        return new JetTypeImpl(noAnnotations, constructor, allNullable, Collections.<TypeProjection>emptyList(), new ChainedScope(null, scopes));
    }

    @NotNull
    public static String toString(@NotNull JetType type) {
        List<TypeProjection> arguments = type.getArguments();
        return type.getConstructor() + (arguments.isEmpty() ? "" : "<" + TypeUtils.argumentsToString(arguments) + ">") + (type.isNullable() ? "?" : "");
    }

    private static StringBuilder argumentsToString(List<TypeProjection> arguments) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<TypeProjection> iterator = arguments.iterator();
        while (iterator.hasNext()) {
            TypeProjection argument = iterator.next();
            stringBuilder.append(argument);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder;
    }

    public static boolean canHaveSubtypes(JetTypeChecker typeChecker, JetType type) {
        if (type.isNullable()) {
            return true;
        }
        if (!type.getConstructor().isSealed()) {
            return true;
        }
        List<TypeParameterDescriptor> parameters = type.getConstructor().getParameters();
        List<TypeProjection> arguments = type.getArguments();
        int parametersSize = parameters.size();
        block10: for (int i = 0; i < parametersSize; ++i) {
            TypeParameterDescriptor parameterDescriptor = parameters.get(i);
            TypeProjection typeProjection = arguments.get(i);
            Variance projectionKind = typeProjection.getProjectionKind();
            JetType argument = typeProjection.getType();
            switch (parameterDescriptor.getVariance()) {
                case INVARIANT: {
                    switch (projectionKind) {
                        case INVARIANT: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) && !TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                        case IN_VARIANCE: {
                            if (!TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor)) break;
                            return true;
                        }
                        case OUT_VARIANCE: {
                            if (!TypeUtils.canHaveSubtypes(typeChecker, argument)) break;
                            return true;
                        }
                    }
                    continue block10;
                }
                case IN_VARIANCE: {
                    if (!(projectionKind != Variance.OUT_VARIANCE ? TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor) : TypeUtils.canHaveSubtypes(typeChecker, argument))) continue block10;
                    return true;
                }
                case OUT_VARIANCE: {
                    if (!(projectionKind != Variance.IN_VARIANCE ? TypeUtils.canHaveSubtypes(typeChecker, argument) : TypeUtils.lowerThanBound(typeChecker, argument, parameterDescriptor))) continue block10;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean lowerThanBound(JetTypeChecker typeChecker, JetType argument, TypeParameterDescriptor parameterDescriptor) {
        for (JetType bound : parameterDescriptor.getUpperBounds()) {
            if (!typeChecker.isSubtypeOf(argument, bound) || argument.getConstructor().equals(bound.getConstructor())) continue;
            return true;
        }
        return false;
    }

    public static JetType makeNullableIfNeeded(JetType type, boolean nullable) {
        if (nullable) {
            return TypeUtils.makeNullable(type);
        }
        return type;
    }

    @NotNull
    public static JetType makeUnsubstitutedType(ClassDescriptor classDescriptor, JetScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classDescriptor)) {
            return ErrorUtils.createErrorType("Unsubstituted type for " + classDescriptor);
        }
        List<TypeProjection> arguments = TypeUtils.getDefaultTypeProjections(classDescriptor.getTypeConstructor().getParameters());
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), classDescriptor.getTypeConstructor(), false, arguments, unsubstitutedMemberScope);
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(List<TypeParameterDescriptor> parameters) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result.add(new TypeProjection(parameterDescriptor.getDefaultType()));
        }
        return result;
    }

    @NotNull
    public static List<JetType> getDefaultTypes(List<TypeParameterDescriptor> parameters) {
        ArrayList<JetType> result = Lists.newArrayList();
        for (TypeParameterDescriptor parameterDescriptor : parameters) {
            result.add(parameterDescriptor.getDefaultType());
        }
        return result;
    }

    private static void collectImmediateSupertypes(@NotNull JetType type, @NotNull Collection<JetType> result) {
        TypeSubstitutor substitutor = TypeSubstitutor.create(type);
        for (JetType supertype : type.getConstructor().getSupertypes()) {
            result.add(substitutor.substitute(supertype, Variance.INVARIANT));
        }
    }

    @NotNull
    public static List<JetType> getImmediateSupertypes(@NotNull JetType type) {
        ArrayList<JetType> result = Lists.newArrayList();
        TypeUtils.collectImmediateSupertypes(type, result);
        return result;
    }

    private static void collectAllSupertypes(@NotNull JetType type, @NotNull Set<JetType> result) {
        List<JetType> immediateSupertypes = TypeUtils.getImmediateSupertypes(type);
        result.addAll(immediateSupertypes);
        for (JetType supertype : immediateSupertypes) {
            TypeUtils.collectAllSupertypes(supertype, result);
        }
    }

    @NotNull
    public static Set<JetType> getAllSupertypes(@NotNull JetType type) {
        LinkedHashSet<JetType> result = new LinkedHashSet<JetType>(15);
        TypeUtils.collectAllSupertypes(type, result);
        return result;
    }

    public static boolean hasNullableLowerBound(@NotNull TypeParameterDescriptor typeParameterDescriptor) {
        for (JetType bound : typeParameterDescriptor.getLowerBounds()) {
            if (!bound.isNullable()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNullableSuperType(@NotNull JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (JetType supertype : TypeUtils.getImmediateSupertypes(type)) {
            if (supertype.isNullable()) {
                return true;
            }
            if (!TypeUtils.hasNullableSuperType(supertype)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalClasses(@NotNull JetType type1, @NotNull JetType type2) {
        ClassifierDescriptor declarationDescriptor1 = type1.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor1 == null) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor2 == null) {
            return false;
        }
        return declarationDescriptor1.getOriginal().equals(declarationDescriptor2.getOriginal());
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull JetType type) {
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    @NotNull
    public static JetType substituteParameters(@NotNull ClassDescriptor clazz, @NotNull List<JetType> actualTypeParameters) {
        List<TypeParameterDescriptor> clazzTypeParameters = clazz.getTypeConstructor().getParameters();
        if (clazzTypeParameters.size() != actualTypeParameters.size()) {
            throw new IllegalArgumentException("type parameter counts do not match: " + clazz + ", " + actualTypeParameters);
        }
        HashMap<TypeConstructor, TypeProjection> substitutions = Maps.newHashMap();
        for (int i = 0; i < clazzTypeParameters.size(); ++i) {
            TypeConstructor typeConstructor = clazzTypeParameters.get(i).getTypeConstructor();
            TypeProjection typeProjection = new TypeProjection(actualTypeParameters.get(i));
            substitutions.put(typeConstructor, typeProjection);
        }
        return TypeSubstitutor.create(substitutions).substitute(clazz.getDefaultType(), Variance.INVARIANT);
    }

    private static void addAllClassDescriptors(@NotNull JetType type, @NotNull Set<ClassDescriptor> set) {
        ClassDescriptor cd = TypeUtils.getClassDescriptor(type);
        if (cd != null) {
            set.add(cd);
        }
        for (TypeProjection projection : type.getArguments()) {
            TypeUtils.addAllClassDescriptors(projection.getType(), set);
        }
    }

    @NotNull
    public static List<ClassDescriptor> getAllClassDescriptors(@NotNull JetType type) {
        HashSet<ClassDescriptor> classDescriptors = new HashSet<ClassDescriptor>();
        TypeUtils.addAllClassDescriptors(type, classDescriptors);
        return new ArrayList<ClassDescriptor>(classDescriptors);
    }

    public static boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        return JetTypeChecker.INSTANCE.isSubtypeOf(a, b) && JetTypeChecker.INSTANCE.isSubtypeOf(b, a);
    }

    public static boolean typeConstructorUsedInType(@NotNull TypeConstructor key, @NotNull JetType value) {
        if (value.getConstructor() == key) {
            return true;
        }
        for (TypeProjection projection : value.getArguments()) {
            if (!TypeUtils.typeConstructorUsedInType(key, projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean dependsOnTypeParameters(@NotNull JetType type, @NotNull Collection<TypeParameterDescriptor> typeParameters) {
        return TypeUtils.dependsOnTypeConstructors(type, Collections2.transform(typeParameters, new Function<TypeParameterDescriptor, TypeConstructor>(){

            @Override
            public TypeConstructor apply(@Nullable TypeParameterDescriptor typeParameterDescriptor) {
                assert (typeParameterDescriptor != null);
                return typeParameterDescriptor.getTypeConstructor();
            }
        }));
    }

    public static boolean dependsOnTypeConstructors(@NotNull JetType type, @NotNull Collection<TypeConstructor> typeParameterConstructors) {
        if (typeParameterConstructors.contains(type.getConstructor())) {
            return true;
        }
        for (TypeProjection typeProjection : type.getArguments()) {
            if (!TypeUtils.dependsOnTypeConstructors(typeProjection.getType(), typeParameterConstructors)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOrContainsAsArgument(@Nullable JetType type, JetType ... possibleArgumentTypes) {
        return TypeUtils.equalsOrContainsAsArgument(type, Sets.newHashSet(possibleArgumentTypes));
    }

    private static boolean equalsOrContainsAsArgument(@Nullable JetType type, @NotNull Set<JetType> possibleArgumentTypes) {
        if (type == null) {
            return false;
        }
        if (possibleArgumentTypes.contains(type)) {
            return true;
        }
        if (type instanceof NamespaceType) {
            return false;
        }
        for (TypeProjection projection : type.getArguments()) {
            if (!TypeUtils.equalsOrContainsAsArgument(projection.getType(), possibleArgumentTypes)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getTypeNameAndStarProjectionsString(@NotNull String name, int size) {
        StringBuilder builder = new StringBuilder(name);
        builder.append("<");
        for (int i = 0; i < size; ++i) {
            builder.append("*");
            if (i == size - 1) break;
            builder.append(", ");
        }
        builder.append(">");
        return builder.toString();
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull JetType type, @NotNull JetType other) {
            return TypeUnifier.unify(type, other);
        }

        private static boolean unify(JetType withParameters, JetType expected) {
            ConstraintSystemWithPriorities constraintSystem = new ConstraintSystemWithPriorities(ConstraintResolutionListener.DO_NOTHING);
            final HashMap parameters = Maps.newHashMap();
            Processor<TypeParameterUsage> processor = new Processor<TypeParameterUsage>(){

                @Override
                public boolean process(TypeParameterUsage parameterUsage) {
                    Variance howTheTypeIsUsedBefore = (Variance)((Object)parameters.get(parameterUsage.typeParameterDescriptor));
                    if (howTheTypeIsUsedBefore == null) {
                        howTheTypeIsUsedBefore = Variance.INVARIANT;
                    }
                    parameters.put(parameterUsage.typeParameterDescriptor, parameterUsage.howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                    return true;
                }
            };
            TypeUnifier.processAllTypeParameters(withParameters, Variance.INVARIANT, processor);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor);
            for (Map.Entry entry : parameters.entrySet()) {
                constraintSystem.registerTypeVariable((TypeParameterDescriptor)entry.getKey(), (Variance)((Object)entry.getValue()));
            }
            constraintSystem.addSubtypingConstraint(ConstraintType.VALUE_ARGUMENT.assertSubtyping(withParameters, expected));
            ConstraintSystemSolution solution = constraintSystem.solve();
            return solution.getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(JetType type, Variance howThiTypeIsUsed, Processor<TypeParameterUsage> result) {
            ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
            if (descriptor instanceof TypeParameterDescriptor) {
                result.process(new TypeParameterUsage((TypeParameterDescriptor)descriptor, howThiTypeIsUsed));
            }
            for (TypeProjection projection : type.getArguments()) {
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }
}

