/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.wrapper;

import com.intellij.psi.PsiMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.KotlinSignatureAnnotation;

public abstract class PsiMemberWrapper {
    @NotNull
    protected final PsiMember psiMember;
    private KotlinSignatureAnnotation signatureAnnotation;

    public PsiMemberWrapper(@NotNull PsiMember psiMember) {
        this.psiMember = psiMember;
    }

    @NotNull
    public PsiMember getPsiMember() {
        return this.psiMember;
    }

    public boolean isStatic() {
        return this.psiMember.hasModifierProperty("static");
    }

    public boolean isPrivate() {
        return this.psiMember.hasModifierProperty("private");
    }

    public boolean isFinal() {
        return this.psiMember.hasModifierProperty("final");
    }

    public abstract boolean isAbstract();

    public String getName() {
        return this.psiMember.getName();
    }

    @NotNull
    public KotlinSignatureAnnotation getSignatureAnnotation() {
        if (this.signatureAnnotation == null) {
            this.signatureAnnotation = KotlinSignatureAnnotation.get(this.getPsiMember());
        }
        return this.signatureAnnotation;
    }

    public String toString() {
        return this.psiMember.getText();
    }
}

