/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.vfilefinder;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.jvm.compiler.ClassPath;
import org.jetbrains.jet.lang.resolve.java.resolver.KotlinClassFileHeader;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class CliVirtualFileFinder
implements VirtualFileFinder {
    @NotNull
    private final ClassPath classPath;

    public CliVirtualFileFinder(@NotNull ClassPath path) {
        this.classPath = path;
    }

    @Override
    @Nullable
    public VirtualFile find(@NotNull FqName className, @NotNull GlobalSearchScope scope) {
        return this.find(className);
    }

    @Override
    @Nullable
    public VirtualFile find(@NotNull FqName className) {
        for (VirtualFile root : this.classPath) {
            VirtualFile fileInRoot = CliVirtualFileFinder.findFileInRoot(className.asString(), root);
            if (fileInRoot == null) continue;
            return fileInRoot;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFileInRoot(@NotNull String qName, @NotNull VirtualFile root) {
        String pathComponent;
        VirtualFile child;
        int dot;
        String pathRest = qName;
        VirtualFile cur = root;
        while ((dot = pathRest.indexOf(46)) >= 0 && (child = cur.findChild(pathComponent = pathRest.substring(0, dot))) != null) {
            pathRest = pathRest.substring(dot + 1);
            cur = child;
        }
        String className = pathRest.replace('.', '$');
        VirtualFile vFile = cur.findChild(className + ".class");
        if (vFile != null) {
            if (!vFile.isValid()) {
                return null;
            }
            if (KotlinClassFileHeader.readKotlinHeaderFromClassFile(vFile).getType() != KotlinClassFileHeader.HeaderType.NONE) {
                return vFile;
            }
        }
        return null;
    }
}

