/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class JavaPackageScope
extends JavaBaseScope {
    @NotNull
    private final PsiPackage psiPackage;
    @NotNull
    private final FqName packageFQN;
    @NotNull
    private final PsiClassFinder psiClassFinder;

    public JavaPackageScope(@NotNull NamespaceDescriptor descriptor, @NotNull PsiPackage psiPackage, @NotNull FqName packageFQN, @NotNull JavaDescriptorResolver javaDescriptorResolver, @NotNull PsiClassFinder psiClassFinder) {
        super(descriptor, javaDescriptorResolver, MembersProvider.forPackage(psiClassFinder, psiPackage));
        this.psiPackage = psiPackage;
        this.packageFQN = packageFQN;
        this.psiClassFinder = psiClassFinder;
    }

    @Override
    @NotNull
    public PsiPackage getPsiElement() {
        return this.psiPackage;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassDescriptor classDescriptor = this.javaDescriptorResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (classDescriptor == null || classDescriptor.getKind().isObject()) {
            return null;
        }
        return classDescriptor;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        ClassDescriptor classDescriptor = this.javaDescriptorResolver.resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        if (classDescriptor != null && classDescriptor.getKind().isObject()) {
            return classDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.javaDescriptorResolver.resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN_SOURCES);
    }

    @Override
    @NotNull
    protected Collection<DeclarationDescriptor> computeAllDescriptors() {
        Collection<DeclarationDescriptor> result = super.computeAllDescriptors();
        result.addAll(this.computeAllPackageDeclarations());
        return result;
    }

    @NotNull
    private Collection<DeclarationDescriptor> computeAllPackageDeclarations() {
        HashSet<DeclarationDescriptor> result = Sets.newHashSet();
        for (PsiPackage psiSubPackage : this.psiPackage.getSubPackages()) {
            FqName fqName = new FqName(psiSubPackage.getQualifiedName());
            NamespaceDescriptor childNs = this.javaDescriptorResolver.resolveNamespace(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (childNs == null) continue;
            result.add(childNs);
        }
        for (PsiClass psiClass : this.psiClassFinder.findPsiClasses(this.psiPackage)) {
            NamespaceDescriptor namespace;
            if (DescriptorResolverUtils.isCompiledKotlinPackageClass(psiClass) || psiClass instanceof JetJavaMirrorMarker || !psiClass.hasModifierProperty("public")) continue;
            ProgressIndicatorProvider.checkCanceled();
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) continue;
            FqName fqName = new FqName(qualifiedName);
            ClassDescriptor classDescriptor = this.javaDescriptorResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (classDescriptor != null) {
                result.add(classDescriptor);
            }
            if ((namespace = this.javaDescriptorResolver.resolveNamespace(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES)) == null) continue;
            result.add(namespace);
        }
        return result;
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            return Collections.emptySet();
        }
        return this.javaDescriptorResolver.resolveFunctionGroupForPackage(members, (NamespaceDescriptor)this.descriptor);
    }

    @Override
    @NotNull
    protected Collection<ClassDescriptor> computeInnerClasses() {
        return Collections.emptyList();
    }
}

