/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.scope;

import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.scope.JavaBaseScope;
import org.jetbrains.jet.lang.resolve.java.scope.MembersProvider;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaClassMembersScope
extends JavaBaseScope {
    @NotNull
    protected final PsiClass psiClass;
    private Map<Name, ClassDescriptor> innerClassesMap = null;

    protected JavaClassMembersScope(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull PsiClass psiClass, @NotNull MembersProvider membersProvider, @NotNull JavaDescriptorResolver javaDescriptorResolver) {
        super(descriptor, javaDescriptorResolver, membersProvider);
        this.psiClass = psiClass;
    }

    @Override
    @NotNull
    public PsiClass getPsiElement() {
        return this.psiClass;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Set<FunctionDescriptor> computeFunctionDescriptor(@NotNull Name name) {
        NamedMembers members = this.membersProvider.get(name);
        if (members == null) {
            return Collections.emptySet();
        }
        return this.javaDescriptorResolver.resolveFunctionGroupForClass(members, this.descriptor, this.psiClass);
    }

    @NotNull
    private Map<Name, ClassDescriptor> getInnerClassesMap() {
        if (this.innerClassesMap == null) {
            Collection<ClassDescriptor> innerClasses = this.getInnerClasses();
            this.innerClassesMap = new HashMap<Name, ClassDescriptor>();
            for (ClassDescriptor innerClass : innerClasses) {
                this.innerClassesMap.put(innerClass.getName(), innerClass);
            }
        }
        return this.innerClassesMap;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        ClassDescriptor innerClass = this.getInnerClassesMap().get(name);
        if (innerClass != null && innerClass.getKind().isObject()) {
            return innerClass;
        }
        return null;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassDescriptor innerClass = this.getInnerClassesMap().get(name);
        if (innerClass == null || innerClass.getKind().isObject()) {
            return null;
        }
        return innerClass;
    }
}

