/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaValueParameterResolver {
    private JavaTypeTransformer typeTransformer;

    @NotNull
    private ValueParameterDescriptor resolveParameterDescriptor(DeclarationDescriptor containingDeclaration, int i, PsiParameter parameter, TypeVariableResolver typeVariableResolver) {
        JetType varargElementType;
        PsiType psiType = parameter.getType();
        Name name = Name.identifier(JavaValueParameterResolver.getParameterName(i, parameter));
        TypeUsage typeUsage = JavaTypeTransformer.adjustTypeUsageWithMutabilityAnnotations(parameter, TypeUsage.MEMBER_SIGNATURE_CONTRAVARIANT);
        JetType outType = this.getTypeTransformer().transformToType(psiType, typeUsage, typeVariableResolver);
        if (psiType instanceof PsiEllipsisType) {
            varargElementType = KotlinBuiltIns.getInstance().getArrayElementType(TypeUtils.makeNotNullable(outType));
            outType = TypeUtils.makeNotNullable(outType);
        } else {
            varargElementType = null;
        }
        PsiAnnotation notNullAnnotation = JavaAnnotationResolver.findAnnotationWithExternal(parameter, JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().asString());
        JetType transformedType = notNullAnnotation != null ? TypeUtils.makeNullableAsSpecified(outType, false) : outType;
        return new ValueParameterDescriptorImpl(containingDeclaration, i, Collections.<AnnotationDescriptor>emptyList(), name, transformedType, false, varargElementType);
    }

    @NotNull
    private JavaTypeTransformer getTypeTransformer() {
        return this.typeTransformer;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    @NotNull
    private static String getParameterName(int number, @NotNull PsiParameter parameter) {
        String psiParameterName = parameter.getName();
        return psiParameterName != null ? psiParameterName : "p" + number;
    }

    public JavaDescriptorResolver.ValueParameterDescriptors resolveParameterDescriptors(DeclarationDescriptor containingDeclaration, List<PsiParameter> parameters, TypeVariableResolver typeVariableResolver) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        int indexDelta = 0;
        int parametersLength = parameters.size();
        for (int i = 0; i < parametersLength; ++i) {
            PsiParameter parameter = parameters.get(i);
            ValueParameterDescriptor parameterDescriptor = this.resolveParameterDescriptor(containingDeclaration, i + indexDelta, parameter, typeVariableResolver);
            result.add(parameterDescriptor);
        }
        return new JavaDescriptorResolver.ValueParameterDescriptors(null, result);
    }
}

