/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public final class JavaSupertypeResolver {
    private static final FqName OBJECT_FQ_NAME = new FqName("java.lang.Object");
    private BindingTrace trace;
    private JavaTypeTransformer typeTransformer;
    private JavaClassResolver classResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    public Collection<JetType> getSupertypes(@NotNull ClassDescriptor classDescriptor, @NotNull PsiClass psiClass, @NotNull List<TypeParameterDescriptor> typeParameters) {
        ArrayList<JetType> result = new ArrayList<JetType>();
        String context = "class " + psiClass.getQualifiedName();
        TypeVariableResolver typeVariableResolverForSupertypes = new TypeVariableResolver(typeParameters, classDescriptor, context);
        this.transformSupertypeList(result, psiClass.getExtendsListTypes(), typeVariableResolverForSupertypes);
        this.transformSupertypeList(result, psiClass.getImplementsListTypes(), typeVariableResolverForSupertypes);
        this.reportIncompleteHierarchyForErrorTypes(classDescriptor, result);
        if (result.isEmpty()) {
            this.addBaseClass(psiClass, classDescriptor, result);
        }
        return result;
    }

    private void addBaseClass(@NotNull PsiClass psiClass, @NotNull ClassDescriptor classDescriptor, @NotNull List<JetType> result) {
        if (OBJECT_FQ_NAME.asString().equals(psiClass.getQualifiedName()) || classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            result.add(KotlinBuiltIns.getInstance().getAnyType());
        } else {
            ClassDescriptor object = this.classResolver.resolveClass(OBJECT_FQ_NAME, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
            if (object != null) {
                result.add(object.getDefaultType());
            } else {
                result.add(KotlinBuiltIns.getInstance().getAnyType());
            }
        }
    }

    private void reportIncompleteHierarchyForErrorTypes(ClassDescriptor classDescriptor, List<JetType> result) {
        for (JetType supertype : result) {
            if (!ErrorUtils.isErrorType(supertype)) continue;
            this.trace.record(BindingContext.INCOMPLETE_HIERARCHY, classDescriptor);
        }
    }

    private void transformSupertypeList(List<JetType> result, PsiClassType[] extendsListTypes, TypeVariableResolver typeVariableResolver) {
        for (PsiClassType type : extendsListTypes) {
            JetType transform;
            PsiClass resolved = type.resolve();
            if (resolved != null) {
                String qualifiedName = resolved.getQualifiedName();
                assert (qualifiedName != null);
                if (JvmAbi.JET_OBJECT.getFqName().equalsTo(qualifiedName)) continue;
            }
            if (ErrorUtils.isErrorType(transform = this.typeTransformer.transformToType(type, TypeUsage.SUPERTYPE, typeVariableResolver))) continue;
            result.add(TypeUtils.makeNotNullable(transform));
        }
    }
}

