/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorForObjectImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaCompileTimeConstResolver;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public final class JavaPropertyResolver {
    private JavaTypeTransformer typeTransformer;
    private BindingTrace trace;
    private JavaAnnotationResolver annotationResolver;

    public void setTypeTransformer(@NotNull JavaTypeTransformer javaTypeTransformer) {
        this.typeTransformer = javaTypeTransformer;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @NotNull
    public Set<VariableDescriptor> resolveFieldGroup(@NotNull NamedMembers members, @NotNull ClassOrNamespaceDescriptor ownerDescriptor) {
        PsiFieldWrapper field;
        Name propertyName = members.getName();
        List<PsiFieldWrapper> fields = members.getFields();
        HashSet<PropertyDescriptor> propertiesFromCurrent = new HashSet<PropertyDescriptor>(1);
        assert (fields.size() <= 1);
        if (fields.size() == 1 && DescriptorResolverUtils.isCorrectOwnerForEnumMember(ownerDescriptor, (field = fields.iterator().next()).getPsiField())) {
            propertiesFromCurrent.add(this.resolveProperty(ownerDescriptor, propertyName, "class or namespace " + DescriptorUtils.getFQName(ownerDescriptor), field));
        }
        Set<PropertyDescriptor> propertiesFromSupertypes = JavaPropertyResolver.getPropertiesFromSupertypes(propertyName, ownerDescriptor);
        HashSet<PropertyDescriptor> properties = Sets.newHashSet();
        JavaPropertyResolver.generateOverrides(ownerDescriptor, propertyName, propertiesFromCurrent, propertiesFromSupertypes, properties);
        OverrideResolver.resolveUnknownVisibilities(properties, this.trace);
        properties.addAll(propertiesFromCurrent);
        return Sets.newHashSet(properties);
    }

    private static void generateOverrides(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name propertyName, @NotNull Set<PropertyDescriptor> propertiesFromCurrent, @NotNull Set<PropertyDescriptor> propertiesFromSupertypes, final @NotNull Set<PropertyDescriptor> properties) {
        if (!(owner instanceof ClassDescriptor)) {
            return;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)owner;
        OverrideResolver.generateOverridesInFunctionGroup(propertyName, propertiesFromSupertypes, propertiesFromCurrent, classDescriptor, new OverrideResolver.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                properties.add((PropertyDescriptor)fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
            }
        });
    }

    @NotNull
    private PropertyDescriptor resolveProperty(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name propertyName, @NotNull String context, @NotNull PsiFieldWrapper field) {
        CompileTimeConstant<?> constant;
        PsiExpression initializer;
        boolean isVar = !field.isFinal();
        Visibility visibility = DescriptorResolverUtils.resolveVisibility(field.getPsiField());
        PropertyDescriptorImpl propertyDescriptor = this.createPropertyDescriptor(owner, propertyName, field, isVar, visibility);
        propertyDescriptor.initialize(null, null);
        TypeVariableResolver typeVariableResolverForPropertyInternals = new TypeVariableResolver(Collections.<TypeParameterDescriptor>emptyList(), propertyDescriptor, "property " + propertyName + " in " + context);
        JetType propertyType = this.getPropertyType(field, typeVariableResolverForPropertyInternals);
        propertyType = this.getAlternativeSignatureData(isVar, field, propertyDescriptor, propertyType);
        propertyDescriptor.setType(propertyType, Collections.emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(owner), (JetType)null);
        this.trace.record(BindingContext.VARIABLE, field.getPsiField(), propertyDescriptor);
        this.trace.record(JavaBindingContext.IS_DECLARED_IN_JAVA, propertyDescriptor);
        if (AnnotationUtils.isPropertyAcceptableAsAnnotationParameter(propertyDescriptor) && (initializer = field.getPsiField().getInitializer()) instanceof PsiLiteralExpression && (constant = JavaCompileTimeConstResolver.resolveCompileTimeConstantValue(((PsiLiteralExpression)initializer).getValue(), propertyType)) != null) {
            this.trace.record(BindingContext.COMPILE_TIME_INITIALIZER, propertyDescriptor, constant);
        }
        return propertyDescriptor;
    }

    @NotNull
    private PropertyDescriptorImpl createPropertyDescriptor(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name propertyName, @NotNull PsiFieldWrapper field, boolean isVar, @NotNull Visibility visibility) {
        boolean isEnumEntry = field.getPsiField() instanceof PsiEnumConstant;
        if (isEnumEntry) {
            assert (!isVar) : "Enum entries should be immutable.";
            assert (DescriptorUtils.isEnumClassObject(owner)) : "Enum entries should be put into class object of enum only: " + owner;
            ClassDescriptorImpl dummyClassDescriptorForEnumEntryObject = new ClassDescriptorImpl(owner, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, propertyName);
            dummyClassDescriptorForEnumEntryObject.initialize(true, Collections.emptyList(), Collections.<JetType>emptyList(), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, false);
            return new PropertyDescriptorForObjectImpl(owner, this.annotationResolver.resolveAnnotations(field.getPsiField()), visibility, propertyName, dummyClassDescriptorForEnumEntryObject);
        }
        return new PropertyDescriptorImpl(owner, this.annotationResolver.resolveAnnotations(field.getPsiField()), Modality.FINAL, visibility, isVar, propertyName, CallableMemberDescriptor.Kind.DECLARATION);
    }

    @NotNull
    private JetType getAlternativeSignatureData(boolean isVar, PsiFieldWrapper field, PropertyDescriptor propertyDescriptor, JetType propertyType) {
        AlternativeFieldSignatureData signatureData = new AlternativeFieldSignatureData(field, propertyType, isVar);
        if (signatureData.hasErrors()) {
            this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, propertyDescriptor, Collections.singletonList(signatureData.getError()));
        } else if (signatureData.isAnnotated()) {
            return signatureData.getReturnType();
        }
        return propertyType;
    }

    @NotNull
    private JetType getPropertyType(@NotNull PsiFieldWrapper field, @NotNull TypeVariableResolver typeVariableResolver) {
        boolean hasNotNullAnnotation;
        JetType propertyType = this.typeTransformer.transformToType(field.getType(), typeVariableResolver);
        boolean bl = hasNotNullAnnotation = JavaAnnotationResolver.findAnnotationWithExternal(field.getPsiField(), JvmAnnotationNames.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().asString()) != null;
        if (hasNotNullAnnotation || JavaPropertyResolver.isStaticFinalField(field)) {
            propertyType = TypeUtils.makeNotNullable(propertyType);
        }
        return propertyType;
    }

    @NotNull
    private static Set<PropertyDescriptor> getPropertiesFromSupertypes(@NotNull Name propertyName, @NotNull ClassOrNamespaceDescriptor ownerDescriptor) {
        HashSet<PropertyDescriptor> r = new HashSet<PropertyDescriptor>();
        for (JetType supertype : DescriptorResolverUtils.getSupertypes(ownerDescriptor)) {
            for (VariableDescriptor property : supertype.getMemberScope().getProperties(propertyName)) {
                r.add((PropertyDescriptor)property);
            }
        }
        return r;
    }

    private static boolean isStaticFinalField(@NotNull PsiFieldWrapper wrapper) {
        return wrapper.isFinal() && wrapper.isStatic();
    }
}

