/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;
import org.jetbrains.jet.lang.resolve.java.JavaVisibilities;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeMethodSignatureData;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaFunctionResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaValueParameterResolver;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;

public final class JavaConstructorResolver {
    private BindingTrace trace;
    private JavaTypeTransformer typeTransformer;
    private JavaValueParameterResolver valueParameterResolver;

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setTypeTransformer(JavaTypeTransformer typeTransformer) {
        this.typeTransformer = typeTransformer;
    }

    public void setValueParameterResolver(JavaValueParameterResolver valueParameterResolver) {
        this.valueParameterResolver = valueParameterResolver;
    }

    @NotNull
    public Collection<ConstructorDescriptor> resolveConstructors(@NotNull PsiClass psiClass, @NotNull ClassDescriptor containingClass) {
        ArrayList<ConstructorDescriptor> constructors;
        block8: {
            boolean isStatic;
            PsiMethod[] psiConstructors;
            block9: {
                ConstructorDescriptorImpl constructorDescriptor;
                TypeVariableResolver typeVariableResolver;
                List<TypeParameterDescriptor> typeParameters;
                block10: {
                    block7: {
                        constructors = Lists.newArrayList();
                        typeParameters = containingClass.getTypeConstructor().getParameters();
                        typeVariableResolver = new TypeVariableResolver(typeParameters, containingClass, "class " + psiClass.getQualifiedName());
                        psiConstructors = psiClass.getConstructors();
                        isStatic = psiClass.hasModifierProperty("static");
                        if (containingClass.getKind() != ClassKind.OBJECT && containingClass.getKind() != ClassKind.CLASS_OBJECT) break block7;
                        constructors.add(DescriptorResolver.createPrimaryConstructorForObject(containingClass));
                        break block8;
                    }
                    if (psiConstructors.length != 0) break block9;
                    if (this.trace.get(BindingContext.CONSTRUCTOR, psiClass) == null) break block10;
                    constructors.add(this.trace.get(BindingContext.CONSTRUCTOR, psiClass));
                    break block8;
                }
                Visibility constructorVisibility = JavaConstructorResolver.getConstructorVisibility(containingClass);
                if (!psiClass.isInterface()) {
                    constructorDescriptor = new ConstructorDescriptorImpl(containingClass, Collections.<AnnotationDescriptor>emptyList(), true);
                    constructorDescriptor.initialize(typeParameters, Collections.<ValueParameterDescriptor>emptyList(), constructorVisibility, isStatic);
                    constructors.add(constructorDescriptor);
                    this.trace.record(BindingContext.CONSTRUCTOR, psiClass, constructorDescriptor);
                }
                if (!psiClass.isAnnotationType()) break block8;
                constructorDescriptor = new ConstructorDescriptorImpl(containingClass, Collections.<AnnotationDescriptor>emptyList(), true);
                ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
                PsiMethod[] methods = psiClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    PsiMethod method = methods[i];
                    if (!(method instanceof PsiAnnotationMethod)) continue;
                    PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)method;
                    assert (annotationMethod.getParameterList().getParameters().length == 0);
                    PsiType returnType = annotationMethod.getReturnType();
                    JetType varargElementType = null;
                    if (i == methods.length - 1 && returnType instanceof PsiArrayType) {
                        varargElementType = this.typeTransformer.transformToType(((PsiArrayType)returnType).getComponentType(), typeVariableResolver);
                    }
                    assert (returnType != null);
                    valueParameters.add(new ValueParameterDescriptorImpl(constructorDescriptor, i, Collections.<AnnotationDescriptor>emptyList(), Name.identifier(method.getName()), this.typeTransformer.transformToType(returnType, typeVariableResolver), annotationMethod.getDefaultValue() != null, varargElementType));
                }
                constructorDescriptor.initialize(typeParameters, valueParameters, constructorVisibility, isStatic);
                constructors.add(constructorDescriptor);
                this.trace.record(BindingContext.CONSTRUCTOR, psiClass, constructorDescriptor);
                break block8;
            }
            for (PsiMethod psiConstructor : psiConstructors) {
                ConstructorDescriptor constructor = this.resolveConstructor(psiClass, isStatic, psiConstructor, containingClass);
                if (constructor == null) continue;
                constructors.add(constructor);
                ContainerUtil.addIfNotNull(constructors, this.resolveSamAdapter(constructor));
            }
        }
        for (ConstructorDescriptor constructor : constructors) {
            ((ConstructorDescriptorImpl)constructor).setReturnType(containingClass.getDefaultType());
        }
        return constructors;
    }

    @NotNull
    private static Visibility getConstructorVisibility(@NotNull ClassDescriptor classDescriptor) {
        Visibility visibility = classDescriptor.getVisibility();
        if (visibility == JavaVisibilities.PROTECTED_STATIC_VISIBILITY) {
            return JavaVisibilities.PROTECTED_AND_PACKAGE;
        }
        return visibility;
    }

    @Nullable
    private ConstructorDescriptor resolveConstructor(PsiClass psiClass, boolean aStatic, PsiMethod psiConstructor, ClassDescriptor classDescriptor) {
        PsiMethodWrapper constructor = new PsiMethodWrapper(psiConstructor);
        if (this.trace.get(BindingContext.CONSTRUCTOR, psiConstructor) != null) {
            return this.trace.get(BindingContext.CONSTRUCTOR, psiConstructor);
        }
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
        List<TypeParameterDescriptor> typeParameters = classDescriptor.getTypeConstructor().getParameters();
        JavaDescriptorResolver.ValueParameterDescriptors valueParameterDescriptors = this.valueParameterResolver.resolveParameterDescriptors(constructorDescriptor, constructor.getParameters(), new TypeVariableResolver(typeParameters, classDescriptor, "constructor of class " + psiClass.getQualifiedName()));
        if (valueParameterDescriptors.getReceiverType() != null) {
            throw new IllegalStateException();
        }
        AlternativeMethodSignatureData alternativeMethodSignatureData = new AlternativeMethodSignatureData(constructor, valueParameterDescriptors, null, Collections.<TypeParameterDescriptor>emptyList(), false);
        if (alternativeMethodSignatureData.isAnnotated() && !alternativeMethodSignatureData.hasErrors()) {
            valueParameterDescriptors = alternativeMethodSignatureData.getValueParameters();
        } else if (alternativeMethodSignatureData.hasErrors()) {
            this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, constructorDescriptor, Collections.singletonList(alternativeMethodSignatureData.getError()));
        }
        constructorDescriptor.initialize(typeParameters, valueParameterDescriptors.getDescriptors(), DescriptorResolverUtils.resolveVisibility(psiConstructor), aStatic);
        this.trace.record(BindingContext.CONSTRUCTOR, psiConstructor, constructorDescriptor);
        return constructorDescriptor;
    }

    @Nullable
    private ConstructorDescriptor resolveSamAdapter(@NotNull ConstructorDescriptor original) {
        return SingleAbstractMethodUtils.isSamAdapterNecessary(original) ? JavaFunctionResolver.recordSamAdapter(original, SingleAbstractMethodUtils.createSamAdapterConstructor(original), this.trace) : null;
    }
}

