/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.ClassReader;
import org.jetbrains.asm4.ClassVisitor;
import org.jetbrains.asm4.FieldVisitor;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBufUtil;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.constants.EnumValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.resolver.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaCompileTimeConstResolver;
import org.jetbrains.jet.lang.resolve.java.vfilefinder.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.lazy.storage.LockBasedStorageManager;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.utils.ExceptionUtils;

public class AnnotationDescriptorDeserializer
implements AnnotationDeserializer {
    private PsiClassFinder psiClassFinder;
    private JavaClassResolver javaClassResolver;
    private VirtualFileFinder virtualFileFinder;
    private final LockBasedStorageManager storageManager = new LockBasedStorageManager();
    private final MemoizedFunctionToNotNull<VirtualFile, Map<MemberSignature, List<AnnotationDescriptor>>> memberAnnotations = this.storageManager.createMemoizedFunction(new MemoizedFunctionToNotNull<VirtualFile, Map<MemberSignature, List<AnnotationDescriptor>>>(){

        @Override
        @NotNull
        public Map<MemberSignature, List<AnnotationDescriptor>> fun(@NotNull VirtualFile file) {
            try {
                return AnnotationDescriptorDeserializer.this.loadMemberAnnotationsFromFile(file);
            }
            catch (IOException e) {
                throw ExceptionUtils.rethrow(e);
            }
        }
    }, StorageManager.ReferenceKind.STRONG);

    public void setPsiClassFinder(PsiClassFinder psiClassFinder) {
        this.psiClassFinder = psiClassFinder;
    }

    public void setVirtualFileFinder(VirtualFileFinder virtualFileFinder) {
        this.virtualFileFinder = virtualFileFinder;
    }

    public void setJavaClassResolver(JavaClassResolver javaClassResolver) {
        this.javaClassResolver = javaClassResolver;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ClassDescriptor descriptor, @NotNull ProtoBuf.Class classProto) {
        VirtualFile virtualFile = this.findVirtualFileByClass(descriptor);
        try {
            return this.loadClassAnnotationsFromFile(virtualFile);
        }
        catch (IOException e) {
            throw ExceptionUtils.rethrow(e);
        }
    }

    @NotNull
    private VirtualFile findVirtualFileByDescriptor(@NotNull ClassOrNamespaceDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            return this.findVirtualFileByClass((ClassDescriptor)descriptor);
        }
        if (descriptor instanceof NamespaceDescriptor) {
            return this.findVirtualFileByPackage((NamespaceDescriptor)descriptor);
        }
        throw new IllegalStateException("Unrecognized descriptor: " + descriptor);
    }

    @NotNull
    private VirtualFile findVirtualFileByClass(@NotNull ClassDescriptor descriptor) {
        FqName fqName = DeserializedResolverUtils.kotlinFqNameToJavaFqName(DeserializedResolverUtils.naiveKotlinFqName(descriptor));
        VirtualFile fileForKotlinFile = this.virtualFileFinder.find(fqName);
        if (fileForKotlinFile != null) {
            return fileForKotlinFile;
        }
        PsiClass psiClass = this.psiClassFinder.findPsiClass(fqName, PsiClassFinder.RuntimeClassesHandleMode.IGNORE);
        if (psiClass == null) {
            throw new IllegalStateException("Psi class is not found for class: " + descriptor);
        }
        VirtualFile outerClassFile = psiClass.getContainingFile().getVirtualFile();
        if (outerClassFile == null) {
            throw new IllegalStateException("Outer class file is not found for class: " + descriptor);
        }
        ClassId id = ClassId.fromFqNameAndContainingDeclaration(fqName, (ClassOrNamespaceDescriptor)descriptor.getContainingDeclaration());
        VirtualFile virtualFile = DeserializedResolverUtils.getVirtualFile(id, outerClassFile);
        if (virtualFile == null) {
            throw new IllegalStateException("Virtual file is not found for class: " + descriptor);
        }
        return virtualFile;
    }

    @NotNull
    private VirtualFile findVirtualFileByPackage(@NotNull NamespaceDescriptor descriptor) {
        FqName fqName = PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFQName(descriptor).toSafe());
        VirtualFile virtualFile = this.virtualFileFinder.find(fqName);
        if (virtualFile == null) {
            throw new IllegalStateException("Virtual file is not found for package: " + descriptor);
        }
        return virtualFile;
    }

    @NotNull
    private List<AnnotationDescriptor> loadClassAnnotationsFromFile(@NotNull VirtualFile virtualFile) throws IOException {
        final ArrayList<AnnotationDescriptor> result = new ArrayList<AnnotationDescriptor>();
        new ClassReader(virtualFile.getInputStream()).accept(new ClassVisitor(262144){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return AnnotationDescriptorDeserializer.this.resolveAnnotation(desc, result);
            }
        }, 7);
        return result;
    }

    private static boolean ignoreAnnotation(@NotNull String desc) {
        return desc.equals(JvmAnnotationNames.KOTLIN_CLASS.getDescriptor()) || desc.equals(JvmAnnotationNames.KOTLIN_PACKAGE.getDescriptor()) || desc.startsWith("Ljet/runtime/typeinfo/");
    }

    @NotNull
    private static FqName convertJvmDescriptorToFqName(@NotNull String desc) {
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String fqName = desc.substring(1, desc.length() - 1).replace('$', '.').replace('/', '.');
        return new FqName(fqName);
    }

    @Nullable
    private AnnotationVisitor resolveAnnotation(@NotNull String desc, final @NotNull List<AnnotationDescriptor> result) {
        if (AnnotationDescriptorDeserializer.ignoreAnnotation(desc)) {
            return null;
        }
        FqName annotationFqName = AnnotationDescriptorDeserializer.convertJvmDescriptorToFqName(desc);
        final ClassDescriptor annotationClass = this.javaClassResolver.resolveClass(annotationFqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
        assert (annotationClass != null) : "Annotation class is not found: " + desc;
        final AnnotationDescriptor annotation = new AnnotationDescriptor();
        annotation.setAnnotationType(annotationClass.getDefaultType());
        return new AnnotationVisitor(262144){

            @Override
            public void visit(String name, Object value) {
                CompileTimeConstant<?> argument = JavaCompileTimeConstResolver.resolveCompileTimeConstantValue(value, null);
                if (argument != null) {
                    this.setArgumentValueByName(name, argument);
                }
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                FqName fqName = AnnotationDescriptorDeserializer.convertJvmDescriptorToFqName(desc);
                ClassDescriptor enumClass = AnnotationDescriptorDeserializer.this.javaClassResolver.resolveClass(fqName, DescriptorSearchRule.IGNORE_KOTLIN_SOURCES);
                assert (enumClass != null) : "Enum class referenced in annotation is not found: " + desc;
                JetScope scope = DescriptorUtils.getEnumEntriesScope(enumClass);
                Collection<VariableDescriptor> properties = scope.getProperties(Name.identifier(value));
                assert (properties.size() == 1) : "Enum class should have exactly one property with the referenced name: " + value + "\n" + properties + "\n" + enumClass;
                EnumValue enumValue = new EnumValue((PropertyDescriptor)properties.iterator().next());
                this.setArgumentValueByName(name, enumValue);
            }

            @Override
            public void visitEnd() {
                result.add(annotation);
            }

            private void setArgumentValueByName(@NotNull String name, @NotNull CompileTimeConstant<?> argumentValue) {
                ValueParameterDescriptor parameter = DescriptorResolverUtils.getValueParameterDescriptorForAnnotationParameter(Name.identifier(name), annotationClass);
                if (parameter != null) {
                    annotation.setValueArgument(parameter, argumentValue);
                }
            }
        };
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        MemberSignature signature = AnnotationDescriptorDeserializer.getCallableSignature(proto, nameResolver, kind);
        if (signature == null) {
            return Collections.emptyList();
        }
        VirtualFile file = this.getVirtualFileWithMemberAnnotations(container, proto, nameResolver);
        List<AnnotationDescriptor> annotations = this.memberAnnotations.fun(file).get(signature);
        return annotations == null ? Collections.emptyList() : annotations;
    }

    @NotNull
    private VirtualFile getVirtualFileWithMemberAnnotations(@NotNull ClassOrNamespaceDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (container instanceof NamespaceDescriptor) {
            VirtualFile facadeFile;
            VirtualFile srcFile;
            Name name = JavaProtoBufUtil.loadSrcClassName(proto, nameResolver);
            if (name != null && (srcFile = (facadeFile = this.findVirtualFileByPackage((NamespaceDescriptor)container)).getParent().findChild(name + ".class")) != null) {
                return srcFile;
            }
        } else if (container instanceof ClassDescriptor && ((ClassDescriptor)container).getKind() == ClassKind.CLASS_OBJECT && JavaProtoBufUtil.isStaticFieldInOuter(proto)) {
            return this.findVirtualFileByDescriptor((ClassOrNamespaceDescriptor)container.getContainingDeclaration());
        }
        return this.findVirtualFileByDescriptor(container);
    }

    @Nullable
    private static MemberSignature getCallableSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer.AnnotatedCallableKind kind) {
        switch (kind) {
            case FUNCTION: {
                return MemberSignature.fromMethod(JavaProtoBufUtil.loadMethodSignature(proto, nameResolver));
            }
            case PROPERTY_GETTER: {
                return MemberSignature.fromMethod(JavaProtoBufUtil.loadPropertyGetterSignature(proto, nameResolver));
            }
            case PROPERTY_SETTER: {
                return MemberSignature.fromMethod(JavaProtoBufUtil.loadPropertySetterSignature(proto, nameResolver));
            }
            case PROPERTY: {
                JavaProtoBufUtil.PropertyData data = JavaProtoBufUtil.loadPropertyData(proto, nameResolver);
                return data == null ? null : MemberSignature.fromPropertyData(data.getFieldType(), data.getFieldName(), data.getSyntheticMethodName());
            }
        }
        return null;
    }

    @NotNull
    private Map<MemberSignature, List<AnnotationDescriptor>> loadMemberAnnotationsFromFile(@NotNull VirtualFile file) throws IOException {
        final HashMap<MemberSignature, List<AnnotationDescriptor>> memberAnnotations = new HashMap<MemberSignature, List<AnnotationDescriptor>>();
        new ClassReader(file.getInputStream()).accept(new ClassVisitor(262144){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MemberSignature methodSignature = MemberSignature.fromMethodNameAndDesc(name, desc);
                final ArrayList result = new ArrayList();
                return new MethodVisitor(262144){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return AnnotationDescriptorDeserializer.this.resolveAnnotation(desc, result);
                    }

                    @Override
                    public void visitEnd() {
                        if (!result.isEmpty()) {
                            memberAnnotations.put(methodSignature, result);
                        }
                    }
                };
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                final MemberSignature fieldSignature = MemberSignature.fromFieldNameAndDesc(name, desc);
                final ArrayList result = new ArrayList();
                return new FieldVisitor(262144){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return AnnotationDescriptorDeserializer.this.resolveAnnotation(desc, result);
                    }

                    @Override
                    public void visitEnd() {
                        if (!result.isEmpty()) {
                            memberAnnotations.put(fieldSignature, result);
                        }
                    }
                };
            }
        }, 7);
        return memberAnnotations;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoBuf.Callable.ValueParameter parameterProto) {
        throw new UnsupportedOperationException();
    }

    private static final class MemberSignature {
        private final String signature;

        private MemberSignature(@NotNull String signature) {
            this.signature = signature;
        }

        @Nullable
        public static MemberSignature fromPropertyData(@Nullable Type fieldType, @Nullable String fieldName, @Nullable String syntheticMethodName) {
            if (fieldName != null && fieldType != null) {
                return MemberSignature.fromFieldNameAndDesc(fieldName, fieldType.getDescriptor());
            }
            if (syntheticMethodName != null) {
                return MemberSignature.fromMethodNameAndDesc(syntheticMethodName, "()V");
            }
            return null;
        }

        @Nullable
        public static MemberSignature fromMethod(@Nullable Method method) {
            return method == null ? null : MemberSignature.fromMethodNameAndDesc(method.getName(), method.getDescriptor());
        }

        @NotNull
        public static MemberSignature fromMethodNameAndDesc(@NotNull String name, @NotNull String desc) {
            return new MemberSignature(name + desc);
        }

        @NotNull
        public static MemberSignature fromFieldNameAndDesc(@NotNull String name, @NotNull String desc) {
            return new MemberSignature(name + "#" + desc);
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MemberSignature && this.signature.equals(((MemberSignature)o).signature);
        }

        public String toString() {
            return this.signature;
        }
    }
}

