/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class MembersCache {
    private final Multimap<Name, Runnable> memberProcessingTasks = HashMultimap.create();
    private final Map<Name, NamedMembers> namedMembersMap = new HashMap<Name, NamedMembers>();

    @Nullable
    public NamedMembers get(@NotNull Name name) {
        this.runTasksByName(name);
        return this.namedMembersMap.get(name);
    }

    @NotNull
    public Collection<NamedMembers> allMembers() {
        this.runAllTasks();
        this.memberProcessingTasks.clear();
        return this.namedMembersMap.values();
    }

    @NotNull
    private NamedMembers getOrCreateEmpty(@NotNull Name name) {
        NamedMembers r = this.namedMembersMap.get(name);
        if (r == null) {
            r = new NamedMembers(name);
            this.namedMembersMap.put(name, r);
        }
        return r;
    }

    private void addTask(@NotNull PsiMember member, @NotNull RunOnce task) {
        this.addTask(member.getName(), task);
    }

    private void addTask(@Nullable String name, @NotNull RunOnce task) {
        if (name == null) {
            return;
        }
        this.memberProcessingTasks.put(Name.identifier(name), task);
    }

    private void runTasksByName(Name name) {
        if (!this.memberProcessingTasks.containsKey(name)) {
            return;
        }
        Collection<Runnable> tasks = this.memberProcessingTasks.get(name);
        for (Runnable task : tasks) {
            task.run();
        }
        tasks.clear();
    }

    private void runAllTasks() {
        for (Runnable task : this.memberProcessingTasks.values()) {
            task.run();
        }
    }

    @NotNull
    public static MembersCache buildMembersByNameCache(@NotNull PsiClassFinder finder, @Nullable PsiClass psiClass, @Nullable PsiPackage psiPackage, boolean staticMembers) {
        MembersCache membersCache = new MembersCache();
        if (psiClass != null) {
            MembersCache membersCache2 = membersCache;
            membersCache2.getClass();
            membersCache2.new ClassMemberProcessor(psiClass, staticMembers).process();
        }
        List<PsiClass> classes = psiPackage != null ? finder.findPsiClasses(psiPackage) : finder.findInnerPsiClasses(psiClass);
        MembersCache membersCache3 = membersCache;
        membersCache3.getClass();
        membersCache3.new ExtraPackageMembersProcessor(classes).process();
        return membersCache;
    }

    private static abstract class RunOnce
    implements Runnable {
        private boolean hasRun = false;

        private RunOnce() {
        }

        @Override
        public final void run() {
            if (this.hasRun) {
                return;
            }
            this.hasRun = true;
            this.doRun();
        }

        protected abstract void doRun();
    }

    private class ClassMemberProcessor {
        @NotNull
        private final PsiClass psiClass;
        private final boolean staticMembers;

        private ClassMemberProcessor(@NotNull PsiClass psiClass, boolean staticMembers) {
            this.psiClass = psiClass;
            this.staticMembers = staticMembers;
        }

        public void process() {
            this.processFields();
            this.processMethods();
            this.processNestedClasses();
        }

        private void processFields() {
            for (final PsiField field : this.psiClass.getAllFields()) {
                MembersCache.this.addTask(field, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processField(field);
                    }
                });
            }
        }

        private void processMethods() {
            this.createEntriesForAllMethods();
            this.processOwnMethods();
        }

        private void createEntriesForAllMethods() {
            for (PsiMethod method : this.psiClass.getAllMethods()) {
                MembersCache.this.getOrCreateEmpty(Name.identifier(method.getName()));
            }
        }

        private void processOwnMethods() {
            for (final PsiMethod method : this.psiClass.getMethods()) {
                MembersCache.this.addTask(method, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processOwnMethod(method);
                    }
                });
            }
        }

        private void processNestedClasses() {
            if (!this.staticMembers) {
                return;
            }
            for (final PsiClass nested : this.psiClass.getInnerClasses()) {
                MembersCache.this.addTask(nested, new RunOnce(){

                    @Override
                    public void doRun() {
                        ClassMemberProcessor.this.processNestedClass(nested);
                    }
                });
            }
        }

        private boolean includeMember(PsiMemberWrapper member) {
            if (this.psiClass.isEnum() && this.staticMembers) {
                return member.isStatic();
            }
            if (member.isStatic() != this.staticMembers) {
                return false;
            }
            if (member.getPsiMember().getContainingClass() != this.psiClass) {
                return false;
            }
            if (member.isPrivate()) {
                return false;
            }
            return !DescriptorResolverUtils.isObjectMethodInInterface(member.getPsiMember());
        }

        private void processField(PsiField field) {
            PsiFieldWrapper fieldWrapper = new PsiFieldWrapper(field);
            NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(fieldWrapper.getName()));
            if (!this.includeMember(fieldWrapper)) {
                return;
            }
            namedMembers.addField(fieldWrapper);
        }

        private void processOwnMethod(PsiMethod ownMethod) {
            PsiMethodWrapper method = new PsiMethodWrapper(ownMethod);
            if (!this.includeMember(method)) {
                return;
            }
            NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(method.getName()));
            namedMembers.addMethod(method);
        }

        private void processNestedClass(PsiClass nested) {
            if (SingleAbstractMethodUtils.isSamInterface(nested)) {
                NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(nested.getName()));
                namedMembers.setSamInterface(nested);
            }
        }
    }

    private class ExtraPackageMembersProcessor {
        @NotNull
        private final List<PsiClass> psiClasses;

        private ExtraPackageMembersProcessor(@NotNull List<PsiClass> classes) {
            this.psiClasses = classes;
        }

        private void process() {
            for (PsiClass psiClass : this.psiClasses) {
                if (psiClass instanceof JetJavaMirrorMarker || !SingleAbstractMethodUtils.isSamInterface(psiClass)) continue;
                this.processSamInterface(psiClass);
            }
        }

        private void processSamInterface(@NotNull PsiClass psiClass) {
            NamedMembers namedMembers = MembersCache.this.getOrCreateEmpty(Name.identifier(psiClass.getName()));
            namedMembers.setSamInterface(psiClass);
        }
    }
}

