/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.mapping;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.TypeUsage;
import org.jetbrains.jet.lang.resolve.java.mapping.JavaToKotlinClassMapBuilder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public class JavaToKotlinClassMap
extends JavaToKotlinClassMapBuilder
implements PlatformToKotlinClassMap {
    private static JavaToKotlinClassMap instance = null;
    private final Map<FqName, ClassDescriptor> classDescriptorMap = Maps.newHashMap();
    private final Map<FqName, ClassDescriptor> classDescriptorMapForCovariantPositions = Maps.newHashMap();
    private final Map<String, JetType> primitiveTypesMap = Maps.newHashMap();
    private final Multimap<FqName, ClassDescriptor> packagesWithMappedClasses = HashMultimap.create();

    @NotNull
    public static JavaToKotlinClassMap getInstance() {
        if (instance == null) {
            instance = new JavaToKotlinClassMap();
        }
        return instance;
    }

    private JavaToKotlinClassMap() {
        this.init();
        this.initPrimitives();
    }

    private void initPrimitives() {
        PrimitiveType primitiveType;
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.register(jvmPrimitiveType.getWrapper().getFqName(), builtIns.getPrimitiveClassDescriptor(primitiveType));
        }
        for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
            primitiveType = jvmPrimitiveType.getPrimitiveType();
            this.primitiveTypesMap.put(jvmPrimitiveType.getName(), KotlinBuiltIns.getInstance().getPrimitiveJetType(primitiveType));
            this.primitiveTypesMap.put("[" + jvmPrimitiveType.getName(), KotlinBuiltIns.getInstance().getPrimitiveArrayJetType(primitiveType));
            this.primitiveTypesMap.put(jvmPrimitiveType.getWrapper().getFqName().asString(), KotlinBuiltIns.getInstance().getNullablePrimitiveJetType(primitiveType));
        }
        this.primitiveTypesMap.put("void", KotlinBuiltIns.getInstance().getUnitType());
    }

    @Nullable
    public JetType mapPrimitiveKotlinClass(@NotNull String name) {
        return this.primitiveTypesMap.get(name);
    }

    @Nullable
    public ClassDescriptor mapKotlinClass(@NotNull FqName fqName, @NotNull TypeUsage typeUsage) {
        ClassDescriptor descriptor;
        if ((typeUsage == TypeUsage.MEMBER_SIGNATURE_COVARIANT || typeUsage == TypeUsage.SUPERTYPE) && (descriptor = this.classDescriptorMapForCovariantPositions.get(fqName)) != null) {
            return descriptor;
        }
        return this.classDescriptorMap.get(fqName);
    }

    @Nullable
    public AnnotationDescriptor mapToAnnotationClass(@NotNull FqName fqName) {
        ClassDescriptor classDescriptor = this.classDescriptorMap.get(fqName);
        if (classDescriptor != null && fqName.asString().equals("java.lang.Deprecated")) {
            return JavaToKotlinClassMap.getAnnotationDescriptorForJavaLangDeprecated(classDescriptor);
        }
        return null;
    }

    @NotNull
    private static AnnotationDescriptor getAnnotationDescriptorForJavaLangDeprecated(@NotNull ClassDescriptor classDescriptor) {
        AnnotationDescriptor annotation = new AnnotationDescriptor();
        annotation.setAnnotationType(classDescriptor.getDefaultType());
        ValueParameterDescriptor value = DescriptorResolverUtils.getValueParameterDescriptorForAnnotationParameter(Name.identifier("value"), classDescriptor);
        assert (value != null) : "jet.deprecated must have one parameter called value";
        annotation.setValueArgument(value, new StringValue("Deprecated in Java"));
        return annotation;
    }

    private static FqName getJavaClassFqName(@NotNull Class<?> javaClass) {
        return new FqName(javaClass.getName().replace('$', '.'));
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            this.register(JavaToKotlinClassMap.getJavaClassFqName(javaClass), kotlinDescriptor);
        }
    }

    @Override
    protected void register(@NotNull Class<?> javaClass, @NotNull ClassDescriptor kotlinDescriptor, @NotNull ClassDescriptor kotlinMutableDescriptor, @NotNull JavaToKotlinClassMapBuilder.Direction direction) {
        if (direction == JavaToKotlinClassMapBuilder.Direction.BOTH || direction == JavaToKotlinClassMapBuilder.Direction.JAVA_TO_KOTLIN) {
            FqName javaClassName = JavaToKotlinClassMap.getJavaClassFqName(javaClass);
            this.register(javaClassName, kotlinDescriptor);
            this.registerCovariant(javaClassName, kotlinMutableDescriptor);
        }
    }

    private void register(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        this.classDescriptorMap.put(javaClassName, kotlinDescriptor);
        this.packagesWithMappedClasses.put(javaClassName.parent(), kotlinDescriptor);
    }

    private void registerCovariant(@NotNull FqName javaClassName, @NotNull ClassDescriptor kotlinDescriptor) {
        this.classDescriptorMapForCovariantPositions.put(javaClassName, kotlinDescriptor);
        this.packagesWithMappedClasses.put(javaClassName.parent(), kotlinDescriptor);
    }

    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName) {
        ClassDescriptor kotlinAnalog = this.classDescriptorMap.get(fqName);
        ClassDescriptor kotlinCovariantAnalog = this.classDescriptorMapForCovariantPositions.get(fqName);
        ArrayList<ClassDescriptor> descriptors = Lists.newArrayList();
        if (kotlinAnalog != null) {
            descriptors.add(kotlinAnalog);
        }
        if (kotlinCovariantAnalog != null) {
            descriptors.add(kotlinCovariantAnalog);
        }
        return descriptors;
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor) {
        FqNameUnsafe className = DescriptorUtils.getFQName(classDescriptor);
        if (!className.isSafe()) {
            return Collections.emptyList();
        }
        return this.mapPlatformClass(className.toSafe());
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClassesInside(@NotNull DeclarationDescriptor containingDeclaration) {
        FqNameUnsafe fqName = DescriptorUtils.getFQName(containingDeclaration);
        if (!fqName.isSafe()) {
            return Collections.emptyList();
        }
        return this.packagesWithMappedClasses.get(fqName.toSafe());
    }
}

