/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kotlinSignature;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class KotlinSignatureAnnotation {
    private static final KotlinSignatureAnnotation NULL_ANNOTATION = new KotlinSignatureAnnotation(null);
    @Nullable
    private final PsiAnnotation psiAnnotation;
    private String signature;

    private KotlinSignatureAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        this.psiAnnotation = psiAnnotation;
    }

    @NotNull
    public static KotlinSignatureAnnotation get(@NotNull PsiMember member) {
        PsiAnnotation annotation = JavaAnnotationResolver.findAnnotationWithExternal(member, JvmAnnotationNames.KOTLIN_SIGNATURE.getFqName().asString());
        return annotation != null ? new KotlinSignatureAnnotation(annotation) : NULL_ANNOTATION;
    }

    @NotNull
    private String computeSignature() {
        Object value;
        PsiAnnotationMemberValue attribute;
        if (this.psiAnnotation != null && (attribute = this.psiAnnotation.findAttributeValue("value")) instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)attribute).getValue()) instanceof String) {
            return StringUtil.unescapeStringCharacters((String)value);
        }
        return "";
    }

    @NotNull
    public String signature() {
        if (this.signature == null) {
            this.signature = this.computeSignature();
        }
        return this.signature;
    }

    static {
        NULL_ANNOTATION.computeSignature();
    }
}

