/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.plugin.JetFileType;

public class PsiClassFinderImpl
implements PsiClassFinder {
    private static final Logger LOG = Logger.getInstance(PsiClassFinderImpl.class);
    @NotNull
    private Project project;
    private GlobalSearchScope javaSearchScope;
    private JavaPsiFacadeKotlinHacks javaFacade;

    public void setProject(@NotNull Project project) {
        this.project = project;
    }

    @PostConstruct
    public void initialize() {
        this.javaSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope(this.project)){

            @Override
            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                int compare = super.compare(file1, file2);
                if (compare == 0) {
                    return Comparing.compare(file1.getPath(), file2.getPath());
                }
                return compare;
            }
        };
        this.javaFacade = new JavaPsiFacadeKotlinHacks(this.project);
    }

    @Override
    @Nullable
    public PsiClass findPsiClass(@NotNull FqName qualifiedName, @NotNull PsiClassFinder.RuntimeClassesHandleMode runtimeClassesHandleMode) {
        PsiAnnotation assertInvisibleAnnotation;
        PsiClass original = this.javaFacade.findClass(qualifiedName.asString(), this.javaSearchScope);
        if (original != null) {
            FqName actualQualifiedName;
            String classQualifiedName = original.getQualifiedName();
            FqName fqName = actualQualifiedName = classQualifiedName != null ? new FqName(classQualifiedName) : null;
            if (!qualifiedName.equals(actualQualifiedName)) {
                throw new IllegalStateException("requested " + qualifiedName + ", got " + actualQualifiedName);
            }
        }
        if (original instanceof JetJavaMirrorMarker) {
            throw new IllegalStateException("JetJavaMirrorMaker is not possible in resolve.java, resolving: " + qualifiedName);
        }
        if (original == null) {
            return null;
        }
        if (KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME.equals(qualifiedName.parent()) && (assertInvisibleAnnotation = JavaAnnotationResolver.findOwnAnnotation(original, JvmAnnotationNames.ASSERT_INVISIBLE_IN_RESOLVER.getFqName().asString())) != null) {
            switch (runtimeClassesHandleMode) {
                case IGNORE: {
                    break;
                }
                case REPORT_ERROR: {
                    if (!ApplicationManager.getApplication().isInternal()) break;
                    LOG.error("classpath is configured incorrectly: class " + qualifiedName + " from runtime must not be loaded by compiler");
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown parameter value: " + (Object)((Object)runtimeClassesHandleMode));
                }
            }
            return null;
        }
        return original;
    }

    @Override
    @Nullable
    public PsiPackage findPsiPackage(@NotNull FqName qualifiedName) {
        return this.javaFacade.findPackage(qualifiedName.asString());
    }

    @Override
    @NotNull
    public List<PsiClass> findPsiClasses(@NotNull PsiPackage psiPackage) {
        return PsiClassFinderImpl.filterDuplicateClasses(psiPackage.getClasses());
    }

    @Override
    @NotNull
    public List<PsiClass> findInnerPsiClasses(@NotNull PsiClass psiClass) {
        return PsiClassFinderImpl.filterDuplicateClasses(psiClass.getInnerClasses());
    }

    private static List<PsiClass> filterDuplicateClasses(PsiClass[] classes) {
        HashSet<String> addedQualifiedNames = Sets.newHashSet();
        ArrayList<PsiClass> filteredClasses = Lists.newArrayList();
        for (PsiClass aClass : classes) {
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !addedQualifiedNames.add(qualifiedName)) continue;
            filteredClasses.add(aClass);
        }
        return filteredClasses;
    }
}

