/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.results;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;

public class OverloadResolutionResultsImpl<D extends CallableDescriptor>
implements OverloadResolutionResults<D> {
    private final Collection<ResolvedCallWithTrace<D>> results;
    private final OverloadResolutionResults.Code resultCode;
    private DelegatingBindingTrace trace;

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> success(@NotNull ResolvedCallWithTrace<D> candidate) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SUCCESS, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> nameNotFound() {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.NAME_NOT_FOUND, Collections.<ResolvedCallWithTrace<D>>emptyList());
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> singleFailedCandidate(ResolvedCallWithTrace<D> candidate) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> manyFailedCandidates(Collection<ResolvedCallWithTrace<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> candidatesWithWrongReceiver(Collection<ResolvedCallWithTrace<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> ambiguity(Collection<ResolvedCallWithTrace<D>> candidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.AMBIGUITY, candidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> incompleteTypeInference(Collection<ResolvedCallWithTrace<D>> candidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE, candidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> incompleteTypeInference(ResolvedCallWithTrace<D> candidate) {
        return OverloadResolutionResultsImpl.incompleteTypeInference(Collections.singleton(candidate));
    }

    private OverloadResolutionResultsImpl(@NotNull OverloadResolutionResults.Code resultCode, @NotNull Collection<ResolvedCallWithTrace<D>> results) {
        this.results = results;
        this.resultCode = resultCode;
    }

    @Override
    @NotNull
    public Collection<ResolvedCallWithTrace<D>> getResultingCalls() {
        return this.results;
    }

    @Override
    @NotNull
    public ResolvedCallWithTrace<D> getResultingCall() {
        assert (this.isSingleResult());
        return this.results.iterator().next();
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return this.getResultingCall().getResultingDescriptor();
    }

    @Override
    @NotNull
    public OverloadResolutionResults.Code getResultCode() {
        return this.resultCode;
    }

    @Override
    public boolean isSuccess() {
        return this.resultCode.isSuccess();
    }

    @Override
    public boolean isSingleResult() {
        return this.results.size() == 1 && this.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
    }

    @Override
    public boolean isNothing() {
        return this.resultCode == OverloadResolutionResults.Code.NAME_NOT_FOUND;
    }

    @Override
    public boolean isAmbiguity() {
        return this.resultCode == OverloadResolutionResults.Code.AMBIGUITY;
    }

    @Override
    public boolean isIncomplete() {
        return this.resultCode == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE;
    }

    public DelegatingBindingTrace getTrace() {
        return this.trace;
    }

    public OverloadResolutionResultsImpl<D> setTrace(DelegatingBindingTrace trace) {
        this.trace = trace;
        return this;
    }
}

