/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.ExpressionPosition;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public abstract class ResolutionContext<Context extends ResolutionContext<Context>> {
    public final BindingTrace trace;
    public final JetScope scope;
    public final JetType expectedType;
    public final DataFlowInfo dataFlowInfo;
    public final ExpressionPosition expressionPosition;

    protected ResolutionContext(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionPosition expressionPosition) {
        this.trace = trace;
        this.scope = scope;
        this.expectedType = expectedType;
        this.dataFlowInfo = dataFlowInfo;
        this.expressionPosition = expressionPosition;
    }

    protected abstract Context create(@NotNull BindingTrace var1, @NotNull JetScope var2, @NotNull DataFlowInfo var3, @NotNull JetType var4, @NotNull ExpressionPosition var5);

    protected abstract Context self();

    public Context replaceBindingTrace(@NotNull BindingTrace trace) {
        if (this.trace == trace) {
            return this.self();
        }
        return this.create(trace, this.scope, this.dataFlowInfo, this.expectedType, this.expressionPosition);
    }

    @NotNull
    public Context replaceExpressionPosition(@NotNull ExpressionPosition expressionPosition) {
        if (expressionPosition == this.expressionPosition) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, expressionPosition);
    }

    @NotNull
    public Context replaceDataFlowInfo(@NotNull DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == this.dataFlowInfo) {
            return this.self();
        }
        return this.create(this.trace, this.scope, newDataFlowInfo, this.expectedType, this.expressionPosition);
    }

    @NotNull
    public Context replaceExpectedType(@Nullable JetType newExpectedType) {
        if (newExpectedType == null) {
            return this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        }
        if (this.expectedType == newExpectedType) {
            return this.self();
        }
        return this.create(this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.expressionPosition);
    }

    @NotNull
    public Context replaceScope(@NotNull JetScope newScope) {
        if (newScope == this.scope) {
            return this.self();
        }
        return this.create(this.trace, newScope, this.dataFlowInfo, this.expectedType, this.expressionPosition);
    }
}

