/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.Slices;

public class BindingContextUtils {
    private static final Slices.KeyNormalizer<DeclarationDescriptor> DECLARATION_DESCRIPTOR_NORMALIZER = new Slices.KeyNormalizer<DeclarationDescriptor>(){

        @Override
        public DeclarationDescriptor normalize(DeclarationDescriptor declarationDescriptor) {
            CallableMemberDescriptor callable;
            if (declarationDescriptor instanceof CallableMemberDescriptor && (callable = (CallableMemberDescriptor)declarationDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                throw new IllegalStateException("non-declaration descriptors should be filtered out earlier: " + callable);
            }
            return declarationDescriptor.getOriginal();
        }
    };
    static final ReadOnlySlice<DeclarationDescriptor, PsiElement> DESCRIPTOR_TO_DECLARATION = Slices.sliceBuilder().setKeyNormalizer(DECLARATION_DESCRIPTOR_NORMALIZER).setDebugName("DESCRIPTOR_TO_DECLARATION").build();

    private BindingContextUtils() {
    }

    @Nullable
    public static PsiElement resolveToDeclarationPsiElement(@NotNull BindingContext bindingContext, @Nullable JetReferenceExpression referenceExpression) {
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
        if (declarationDescriptor == null) {
            return bindingContext.get(BindingContext.LABEL_TARGET, referenceExpression);
        }
        PsiElement element = BindingContextUtils.descriptorToDeclaration(bindingContext, declarationDescriptor);
        if (element != null) {
            return element;
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> resolveToDeclarationPsiElements(@NotNull BindingContext bindingContext, @Nullable JetReferenceExpression referenceExpression) {
        DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, referenceExpression);
        if (declarationDescriptor == null) {
            return Lists.newArrayList(bindingContext.get(BindingContext.LABEL_TARGET, referenceExpression));
        }
        return BindingContextUtils.descriptorToDeclarations(bindingContext, declarationDescriptor);
    }

    @Nullable
    public static VariableDescriptor extractVariableDescriptorIfAny(@NotNull BindingContext bindingContext, @Nullable JetElement element, boolean onlyReference) {
        DeclarationDescriptor descriptor = null;
        if (!onlyReference && (element instanceof JetVariableDeclaration || element instanceof JetParameter)) {
            descriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
        } else if (element instanceof JetSimpleNameExpression) {
            descriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, (JetSimpleNameExpression)element);
        } else if (element instanceof JetQualifiedExpression) {
            descriptor = BindingContextUtils.extractVariableDescriptorIfAny(bindingContext, ((JetQualifiedExpression)element).getSelectorExpression(), onlyReference);
        }
        if (descriptor instanceof VariableDescriptor) {
            return (VariableDescriptor)descriptor;
        }
        return null;
    }

    @Nullable
    public static JetFile getContainingFile(@NotNull BindingContext context, @NotNull DeclarationDescriptor declarationDescriptor) {
        DeclarationDescriptor descriptor = DescriptorUtils.findTopLevelParent(declarationDescriptor);
        if (descriptor == null) {
            return null;
        }
        PsiElement declaration = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        if (declaration == null) {
            return null;
        }
        PsiFile containingFile = declaration.getContainingFile();
        if (!(containingFile instanceof JetFile)) {
            return null;
        }
        return (JetFile)containingFile;
    }

    @Nullable
    public static NamespaceDescriptor namespaceDescriptor(@NotNull BindingContext context, @NotNull JetFile source) {
        return context.get(BindingContext.FILE_TO_NAMESPACE, source);
    }

    @Nullable
    private static PsiElement doGetDescriptorToDeclaration(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        return context.get(DESCRIPTOR_TO_DECLARATION, descriptor);
    }

    @Nullable
    public static PsiElement descriptorToDeclaration(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableMemberDescriptor) {
            return BindingContextUtils.callableDescriptorToDeclaration(context, (CallableMemberDescriptor)descriptor);
        }
        if (descriptor instanceof ClassDescriptor) {
            return BindingContextUtils.classDescriptorToDeclaration(context, (ClassDescriptor)descriptor);
        }
        return BindingContextUtils.doGetDescriptorToDeclaration(context, descriptor);
    }

    @NotNull
    public static List<PsiElement> descriptorToDeclarations(@NotNull BindingContext context, @NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableMemberDescriptor) {
            return BindingContextUtils.callableDescriptorToDeclarations(context, (CallableMemberDescriptor)descriptor);
        }
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(context, descriptor);
        if (psiElement != null) {
            return Lists.newArrayList(psiElement);
        }
        return Lists.newArrayList();
    }

    @Nullable
    public static PsiElement callableDescriptorToDeclaration(@NotNull BindingContext context, @NotNull CallableMemberDescriptor callable) {
        if (callable.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            DeclarationDescriptor source = context.get(BindingContext.SOURCE_DESCRIPTOR_FOR_SYNTHESIZED, callable);
            return source != null ? BindingContextUtils.descriptorToDeclaration(context, source) : null;
        }
        if (callable.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return BindingContextUtils.doGetDescriptorToDeclaration(context, callable.getOriginal());
        }
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable.getOverriddenDescriptors();
        if (overriddenDescriptors.size() != 1) {
            throw new IllegalStateException("Cannot find declaration: fake descriptor " + callable + " has more than one overridden descriptor:\n" + StringUtil.join(overriddenDescriptors, ",\n"));
        }
        return BindingContextUtils.callableDescriptorToDeclaration(context, overriddenDescriptors.iterator().next());
    }

    @NotNull
    private static List<PsiElement> callableDescriptorToDeclarations(@NotNull BindingContext context, @NotNull CallableMemberDescriptor callable) {
        if (callable.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            DeclarationDescriptor source = context.get(BindingContext.SOURCE_DESCRIPTOR_FOR_SYNTHESIZED, callable.getOriginal());
            return source != null ? BindingContextUtils.descriptorToDeclarations(context, source) : Collections.emptyList();
        }
        if (callable.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            PsiElement psiElement = BindingContextUtils.doGetDescriptorToDeclaration(context, callable);
            return psiElement != null ? Lists.newArrayList(psiElement) : Lists.newArrayList();
        }
        ArrayList<PsiElement> r = new ArrayList<PsiElement>();
        Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable.getOverriddenDescriptors();
        for (CallableMemberDescriptor callableMemberDescriptor : overriddenDescriptors) {
            r.addAll(BindingContextUtils.callableDescriptorToDeclarations(context, callableMemberDescriptor));
        }
        return r;
    }

    @Nullable
    public static PsiElement classDescriptorToDeclaration(@NotNull BindingContext context, @NotNull ClassDescriptor clazz) {
        return BindingContextUtils.doGetDescriptorToDeclaration(context, clazz);
    }

    public static void recordFunctionDeclarationToDescriptor(@NotNull BindingTrace trace, @NotNull PsiElement psiElement, @NotNull SimpleFunctionDescriptor function) {
        if (function.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            throw new IllegalArgumentException("function of kind " + (Object)((Object)function.getKind()) + " cannot have declaration");
        }
        trace.record(BindingContext.FUNCTION, psiElement, function);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key) {
        return BindingContextUtils.getNotNull(bindingContext, slice, key, "Value at " + slice + " must not be null for " + key);
    }

    @NotNull
    public static <K, V> V getNotNull(@NotNull BindingContext bindingContext, @NotNull ReadOnlySlice<K, V> slice, @NotNull K key, @NotNull String messageIfNull) {
        V value = bindingContext.get(slice, key);
        if (value == null) {
            throw new IllegalStateException(messageIfNull);
        }
        return value;
    }

    @NotNull
    public static DeclarationDescriptor getEnclosingDescriptor(@NotNull BindingContext context, @NotNull JetElement element) {
        JetNamedDeclaration declaration = PsiTreeUtil.getParentOfType((PsiElement)element, JetNamedDeclaration.class);
        if (declaration instanceof JetFunctionLiteral) {
            return BindingContextUtils.getEnclosingDescriptor(context, declaration);
        }
        DeclarationDescriptor descriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, declaration);
        assert (descriptor != null) : "No descriptor for named declaration: " + declaration.getText() + "\n(of type " + declaration.getClass() + ")";
        return descriptor;
    }

    public static void reportAmbiguousLabel(@NotNull BindingTrace trace, @NotNull JetSimpleNameExpression targetLabel, @NotNull Collection<DeclarationDescriptor> declarationsByLabel) {
        ArrayList<PsiElement> targets = Lists.newArrayList();
        for (DeclarationDescriptor descriptor : declarationsByLabel) {
            PsiElement element = BindingContextUtils.descriptorToDeclaration(trace.getBindingContext(), descriptor);
            assert (element != null) : "Label can only point to something in the same lexical scope";
            targets.add(element);
        }
        if (!targets.isEmpty()) {
            trace.record(BindingContext.AMBIGUOUS_LABEL_TARGET, targetLabel, targets);
        }
        trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
    }

    public static void recordExpressionType(@NotNull JetExpression expression, @NotNull BindingTrace trace, @NotNull JetScope resolutionScope, @NotNull JetTypeInfo result) {
        JetType type = result.getType();
        if (type != null) {
            trace.record(BindingContext.EXPRESSION_TYPE, expression, type);
        }
        trace.record(BindingContext.PROCESSED, expression);
        if (result.getDataFlowInfo() != DataFlowInfo.EMPTY) {
            trace.record(BindingContext.EXPRESSION_DATA_FLOW_INFO, expression, result.getDataFlowInfo());
        }
        if (!BindingContextUtils.isExpressionWithValidReference(expression, trace.getBindingContext())) {
            trace.record(BindingContext.RESOLUTION_SCOPE, expression, resolutionScope);
        }
    }

    @Nullable
    public static JetTypeInfo getRecordedTypeInfo(@NotNull JetExpression expression, @NotNull BindingContext context) {
        if (!context.get(BindingContext.PROCESSED, expression).booleanValue()) {
            return null;
        }
        DataFlowInfo dataFlowInfo = context.get(BindingContext.EXPRESSION_DATA_FLOW_INFO, expression);
        if (dataFlowInfo == null) {
            dataFlowInfo = DataFlowInfo.EMPTY;
        }
        JetType type = context.get(BindingContext.EXPRESSION_TYPE, expression);
        return JetTypeInfo.create(type, dataFlowInfo);
    }

    public static boolean isExpressionWithValidReference(@NotNull JetExpression expression, @NotNull BindingContext context) {
        if (expression instanceof JetCallExpression) {
            return BindingContextUtils.isCallExpressionWithValidReference(expression, context);
        }
        return expression instanceof JetReferenceExpression;
    }

    public static boolean isCallExpressionWithValidReference(@NotNull JetExpression expression, @NotNull BindingContext context) {
        JetExpression calleeExpression;
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        return expression instanceof JetCallExpression && (resolvedCall = context.get(BindingContext.RESOLVED_CALL, calleeExpression = ((JetCallExpression)expression).getCalleeExpression())) instanceof VariableAsFunctionResolvedCall;
    }
}

