/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;

public class JetPsiUnparsingUtils {
    private JetPsiUnparsingUtils() {
    }

    @NotNull
    public static String toIf(@Nullable JetExpression condition, @Nullable JetExpression thenExpression, @Nullable JetExpression elseExpression) {
        return JetPsiUnparsingUtils.toIf(JetPsiUtil.getText(condition), JetPsiUtil.getText(thenExpression), elseExpression != null ? elseExpression.getText() : null);
    }

    @NotNull
    public static String toIf(@NotNull String condition, @NotNull String thenExpression, @Nullable String elseExpression) {
        return "if " + JetPsiUnparsingUtils.parenthesizeTextIfNeeded(condition) + " " + thenExpression + (elseExpression != null ? " else " + elseExpression : "");
    }

    @NotNull
    public static String toBinaryExpression(@Nullable JetExpression left, @NotNull String op, @Nullable JetElement right) {
        return JetPsiUnparsingUtils.toBinaryExpression(JetPsiUtil.getText(left), op, JetPsiUtil.getText(right));
    }

    @NotNull
    public static String toBinaryExpression(@NotNull String left, @NotNull String op, @NotNull String right) {
        return left + " " + op + " " + right;
    }

    @NotNull
    public static String parenthesizeIfNeeded(@Nullable JetExpression expression) {
        String text = JetPsiUtil.getText(expression);
        return expression instanceof JetParenthesizedExpression || expression instanceof JetConstantExpression || expression instanceof JetSimpleNameExpression ? text : "(" + text + ")";
    }

    @NotNull
    public static String parenthesizeTextIfNeeded(@NotNull String expressionText) {
        return expressionText.startsWith("(") && expressionText.endsWith(")") ? expressionText : "(" + expressionText + ")";
    }
}

