/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization.descriptors;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorDeserializer;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.TypeDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.AnnotationDeserializer;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedMemberScope;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.impl.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorForObjectImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.TraceUtil;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.NullableLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;

public class DeserializedClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptor {
    private final ClassId classId;
    private final ProtoBuf.Class classProto;
    private final TypeDeserializer typeDeserializer;
    private final DescriptorDeserializer deserializer;
    private final DeserializedMemberScope memberScope;
    private final ReceiverParameterDescriptor thisAsReceiverParameter;
    private final NullableLazyValue<ConstructorDescriptor> primaryConstructor;
    private final AnnotationDeserializer annotationDeserializer;
    private final NotNullLazyValue<List<AnnotationDescriptor>> annotations;
    private final NullableLazyValue<ClassDescriptor> classObjectDescriptor;
    private final NestedClassDescriptors nestedClasses;
    private final NestedClassDescriptors nestedObjects;
    private final Name name;
    private final DeclarationDescriptor containingDeclaration;
    private final DeserializedClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private final boolean isInner;
    private final InnerClassesScopeWrapper innerClassesScope;
    private final DescriptorFinder descriptorFinder;

    public DeserializedClassDescriptor(@NotNull ClassId classId, @NotNull StorageManager storageManager, @NotNull DeclarationDescriptor containingDeclaration, @NotNull NameResolver nameResolver, @NotNull AnnotationDeserializer annotationResolver, final @NotNull DescriptorFinder descriptorFinder, @NotNull ProtoBuf.Class classProto, @Nullable TypeDeserializer outerTypeDeserializer) {
        this.classId = classId;
        this.classProto = classProto;
        this.descriptorFinder = descriptorFinder;
        this.name = nameResolver.getName(classProto.getName());
        TypeDeserializer notNullTypeDeserializer = new TypeDeserializer(storageManager, outerTypeDeserializer, nameResolver, descriptorFinder, "Deserializer for class " + this.name, TypeDeserializer.TypeParameterResolver.NONE);
        DescriptorDeserializer outerDeserializer = DescriptorDeserializer.create(storageManager, notNullTypeDeserializer, this, nameResolver, annotationResolver);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>(classProto.getTypeParameterCount());
        this.deserializer = outerDeserializer.createChildDeserializer(this, classProto.getTypeParameterList(), typeParameters);
        this.typeDeserializer = this.deserializer.getTypeDeserializer();
        this.containingDeclaration = containingDeclaration;
        this.typeConstructor = new DeserializedClassTypeConstructor(typeParameters);
        this.memberScope = new DeserializedClassMemberScope(storageManager, this);
        this.innerClassesScope = new InnerClassesScopeWrapper(this.memberScope);
        this.thisAsReceiverParameter = new LazyClassReceiverParameterDescriptor();
        int flags = classProto.getFlags();
        this.modality = DescriptorDeserializer.modality(Flags.MODALITY.get(flags));
        this.visibility = DescriptorDeserializer.visibility(Flags.VISIBILITY.get(flags));
        this.kind = DescriptorDeserializer.classKind(Flags.CLASS_KIND.get(flags));
        this.isInner = Flags.INNER.get(flags);
        this.annotationDeserializer = annotationResolver;
        this.annotations = storageManager.createLazyValue(new Computable<List<AnnotationDescriptor>>(){

            @Override
            public List<AnnotationDescriptor> compute() {
                return DeserializedClassDescriptor.this.computeAnnotations();
            }
        });
        this.primaryConstructor = storageManager.createNullableLazyValue(new Computable<ConstructorDescriptor>(){

            @Override
            public ConstructorDescriptor compute() {
                return DeserializedClassDescriptor.this.computePrimaryConstructor();
            }
        });
        this.classObjectDescriptor = storageManager.createNullableLazyValue(new Computable<ClassDescriptor>(){

            @Override
            public ClassDescriptor compute() {
                return DeserializedClassDescriptor.this.computeClassObjectDescriptor();
            }
        });
        this.nestedClasses = new NestedClassDescriptors(storageManager, DeserializedClassDescriptor.stringSet(classProto.getNestedClassNameList(), nameResolver)){

            @Override
            protected ClassDescriptor resolveNestedClass(@NotNull Name name) {
                return descriptorFinder.findClass(DeserializedClassDescriptor.this.classId.createNestedClassId(name));
            }
        };
        this.nestedObjects = new NestedClassDescriptors(storageManager, DeserializedClassDescriptor.stringSet(classProto.getNestedObjectNameList(), nameResolver)){

            @Override
            protected ClassDescriptor resolveNestedClass(@NotNull Name name) {
                return descriptorFinder.findClass(DeserializedClassDescriptor.this.classId.createNestedClassId(name));
            }
        };
    }

    @NotNull
    private static Set<String> stringSet(@NotNull List<Integer> nameIndices, @NotNull NameResolver nameResolver) {
        HashSet<String> result = new HashSet<String>(nameIndices.size());
        for (Integer index : nameIndices) {
            result.add(nameResolver.getName(index).asString());
        }
        return result;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean isInner() {
        return this.isInner;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    private List<AnnotationDescriptor> computeAnnotations() {
        if (!Flags.HAS_ANNOTATIONS.get(this.classProto.getFlags()).booleanValue()) {
            return Collections.emptyList();
        }
        return this.annotationDeserializer.loadClassAnnotations(this, this.classProto);
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return this.annotations.compute();
    }

    @Override
    protected JetScope getScopeForMemberLookup() {
        return this.memberScope;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return this.innerClassesScope;
    }

    @Nullable
    private ConstructorDescriptor computePrimaryConstructor() {
        if (!this.classProto.hasPrimaryConstructor()) {
            return null;
        }
        ProtoBuf.Callable constructorProto = this.classProto.getPrimaryConstructor();
        return (ConstructorDescriptor)this.deserializer.loadCallable(constructorProto);
    }

    @Override
    @Nullable
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.primaryConstructor.compute();
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getUnsubstitutedPrimaryConstructor();
        if (constructor == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(constructor);
    }

    @Override
    @Nullable
    public JetType getClassObjectType() {
        ClassDescriptor classObjectDescriptor = this.getClassObjectDescriptor();
        return classObjectDescriptor == null ? null : classObjectDescriptor.getDefaultType();
    }

    @Nullable
    private ClassDescriptor computeClassObjectDescriptor() {
        if (!this.classProto.getClassObjectPresent()) {
            return null;
        }
        if (this.getKind() == ClassKind.ENUM_CLASS) {
            MutableClassDescriptor classObject = this.createEnumClassObject();
            for (int enumEntry : this.classProto.getEnumEntryList()) {
                this.createEnumEntry(classObject, this.deserializer.getNameResolver().getName(enumEntry));
            }
            return classObject;
        }
        return this.descriptorFinder.findClass(this.classId.createNestedClassId(DescriptorUtils.getClassObjectName(this.getName())));
    }

    @NotNull
    private MutableClassDescriptor createEnumClassObject() {
        MutableClassDescriptor classObject = new MutableClassDescriptor(this, this.getScopeForMemberLookup(), ClassKind.CLASS_OBJECT, false, DescriptorUtils.getClassObjectName(this.getName()));
        classObject.setModality(Modality.FINAL);
        classObject.setVisibility(this.getVisibility());
        classObject.setTypeParameterDescriptors(Collections.<TypeParameterDescriptor>emptyList());
        classObject.createTypeConstructor();
        BindingTraceContext trace = new BindingTraceContext();
        ConstructorDescriptorImpl primaryConstructor = DescriptorResolver.createPrimaryConstructorForObject(classObject);
        primaryConstructor.setReturnType(classObject.getDefaultType());
        classObject.setPrimaryConstructor(primaryConstructor, trace);
        classObject.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValuesMethod(classObject, trace));
        classObject.getBuilder().addFunctionDescriptor(DescriptorResolver.createEnumClassObjectValueOfMethod(classObject, trace));
        return classObject;
    }

    private void createEnumEntry(@NotNull MutableClassDescriptor enumClassObject, @NotNull Name name) {
        PropertyDescriptorForObjectImpl property = new PropertyDescriptorForObjectImpl(enumClassObject, Collections.<AnnotationDescriptor>emptyList(), Visibilities.PUBLIC, name, this);
        property.setType(this.getDefaultType(), Collections.emptyList(), enumClassObject.getThisAsReceiverParameter(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
        PropertyGetterDescriptorImpl getter = DescriptorResolver.createDefaultGetter(property);
        getter.initialize(property.getReturnType());
        property.initialize(getter, null);
        enumClassObject.getBuilder().addPropertyDescriptor(property);
    }

    @Override
    @Nullable
    public ClassDescriptor getClassObjectDescriptor() {
        return this.classObjectDescriptor.compute();
    }

    @Override
    @NotNull
    public ReceiverParameterDescriptor getThisAsReceiverParameter() {
        return this.thisAsReceiverParameter;
    }

    private Collection<JetType> computeSuperTypes() {
        ArrayList<JetType> supertypes = new ArrayList<JetType>(this.classProto.getSupertypeCount());
        for (ProtoBuf.Type supertype : this.classProto.getSupertypeList()) {
            supertypes.add(this.typeDeserializer.type(supertype));
        }
        return supertypes;
    }

    public String toString() {
        return "deserialized class " + this.getName().toString();
    }

    private class LazyClassReceiverParameterDescriptor
    extends AbstractReceiverParameterDescriptor {
        private final ClassReceiver classReceiver;

        private LazyClassReceiverParameterDescriptor() {
            this.classReceiver = new ClassReceiver(DeserializedClassDescriptor.this);
        }

        @Override
        @NotNull
        public JetType getType() {
            return DeserializedClassDescriptor.this.getDefaultType();
        }

        @Override
        @NotNull
        public ReceiverValue getValue() {
            return this.classReceiver;
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return DeserializedClassDescriptor.this;
        }
    }

    private static abstract class NestedClassDescriptors {
        private final Set<String> declaredNames;
        private final MemoizedFunctionToNullable<Name, ClassDescriptor> findClass;

        public NestedClassDescriptors(@NotNull StorageManager storageManager, @NotNull Set<String> declaredNames) {
            this.declaredNames = declaredNames;
            this.findClass = storageManager.createMemoizedFunctionWithNullableValues(new Function<Name, ClassDescriptor>(){

                @Override
                public ClassDescriptor fun(Name name) {
                    NestedClassDescriptors _this = NestedClassDescriptors.this;
                    if (!_this.declaredNames.contains(name.asString())) {
                        return null;
                    }
                    return NestedClassDescriptors.this.resolveNestedClass(name);
                }
            }, StorageManager.ReferenceKind.STRONG);
        }

        protected abstract ClassDescriptor resolveNestedClass(@NotNull Name var1);

        @NotNull
        public Collection<ClassDescriptor> getAllDescriptors() {
            ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(this.declaredNames.size());
            for (String name : this.declaredNames) {
                ClassDescriptor descriptor = this.findClass.fun(Name.identifier(name));
                if (descriptor == null) continue;
                result.add(descriptor);
            }
            return result;
        }
    }

    private static class DeserializedClassMemberScope
    extends DeserializedMemberScope {
        private final DeserializedClassDescriptor classDescriptor;

        public DeserializedClassMemberScope(@NotNull StorageManager storageManager, @NotNull DeserializedClassDescriptor classDescriptor) {
            super(storageManager, classDescriptor, classDescriptor.deserializer, classDescriptor.classProto.getMemberList());
            this.classDescriptor = classDescriptor;
        }

        @Override
        protected void computeNonDeclaredFunctions(@NotNull Name name, @NotNull Collection<FunctionDescriptor> functions) {
            ArrayList<FunctionDescriptor> fromSupertypes = new ArrayList<FunctionDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getFunctions(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, functions);
        }

        @Override
        protected void computeNonDeclaredProperties(@NotNull Name name, @NotNull Collection<PropertyDescriptor> property) {
            ArrayList<VariableDescriptor> fromSupertypes = new ArrayList<VariableDescriptor>();
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                fromSupertypes.addAll(supertype.getMemberScope().getProperties(name));
            }
            this.generateFakeOverrides(name, fromSupertypes, property);
        }

        private <D extends CallableMemberDescriptor> void generateFakeOverrides(@NotNull Name name, @NotNull Collection<D> fromSupertypes, final @NotNull Collection<D> result) {
            ArrayList<D> fromCurrent = new ArrayList<D>(result);
            OverrideResolver.generateOverridesInFunctionGroup(name, fromSupertypes, fromCurrent, this.classDescriptor, new OverrideResolver.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    OverrideResolver.resolveUnknownVisibilityForMember(null, fakeOverride, TraceUtil.TRACE_STUB);
                    result.add(fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
        }

        @Override
        protected void addNonDeclaredDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
            for (JetType supertype : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                    if (descriptor instanceof FunctionDescriptor) {
                        result.addAll(this.getFunctions(descriptor.getName()));
                        continue;
                    }
                    if (!(descriptor instanceof PropertyDescriptor)) continue;
                    result.addAll(this.getProperties(descriptor.getName()));
                }
            }
        }

        @Override
        @Nullable
        protected ReceiverParameterDescriptor getImplicitReceiver() {
            return this.classDescriptor.getThisAsReceiverParameter();
        }

        @Override
        @Nullable
        protected ClassifierDescriptor getClassDescriptor(@NotNull Name name) {
            return (ClassifierDescriptor)this.classDescriptor.nestedClasses.findClass.fun(name);
        }

        @Override
        protected void addAllClassDescriptors(@NotNull Collection<DeclarationDescriptor> result) {
            result.addAll(this.classDescriptor.nestedClasses.getAllDescriptors());
        }

        @Override
        @Nullable
        public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
            return (ClassDescriptor)this.classDescriptor.nestedObjects.findClass.fun(name);
        }

        @Override
        @NotNull
        protected Collection<ClassDescriptor> computeAllObjectDescriptors() {
            return this.classDescriptor.nestedObjects.getAllDescriptors();
        }
    }

    private class DeserializedClassTypeConstructor
    implements TypeConstructor {
        private final Collection<JetType> supertypes;
        private final List<TypeParameterDescriptor> parameters;

        public DeserializedClassTypeConstructor(@NotNull List<TypeParameterDescriptor> typeParameters) {
            this.supertypes = DeserializedClassDescriptor.this.computeSuperTypes();
            this.parameters = typeParameters;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            return this.parameters;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            return this.supertypes;
        }

        @Override
        public boolean isSealed() {
            return !DeserializedClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        @Nullable
        public ClassifierDescriptor getDeclarationDescriptor() {
            return DeserializedClassDescriptor.this;
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return DeserializedClassDescriptor.this.getName().toString();
        }
    }
}

