/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.intellij.openapi.util.Computable;
import com.intellij.util.Function;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorFinder;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedTypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.lang.resolve.lazy.storage.NotNullLazyValue;
import org.jetbrains.jet.lang.resolve.lazy.storage.StorageManager;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class TypeDeserializer {
    private final NameResolver nameResolver;
    private final DescriptorFinder descriptorFinder;
    private final TypeDeserializer parent;
    private final TIntObjectHashMap<TypeParameterDescriptor> typeParameterDescriptors = new TIntObjectHashMap();
    private final MemoizedFunctionToNullable<Integer, ClassDescriptor> classDescriptors;
    private final String debugName;
    private final StorageManager storageManager;

    public TypeDeserializer(@NotNull StorageManager storageManager, @NotNull TypeDeserializer parent, @NotNull String debugName, @NotNull TypeParameterResolver typeParameterResolver) {
        this(storageManager, parent, parent.nameResolver, parent.descriptorFinder, debugName, typeParameterResolver);
    }

    public TypeDeserializer(@NotNull StorageManager storageManager, @Nullable TypeDeserializer parent, @NotNull NameResolver nameResolver, @NotNull DescriptorFinder descriptorFinder, @NotNull String debugName, @NotNull TypeParameterResolver typeParameterResolver) {
        this.storageManager = storageManager;
        this.parent = parent;
        this.nameResolver = nameResolver;
        this.descriptorFinder = descriptorFinder;
        this.debugName = debugName + (parent == null ? "" : ". Child of " + parent.debugName);
        for (DeserializedTypeParameterDescriptor typeParameterDescriptor : typeParameterResolver.getTypeParameters(this)) {
            this.typeParameterDescriptors.put(typeParameterDescriptor.getProtoId(), typeParameterDescriptor);
        }
        this.classDescriptors = storageManager.createMemoizedFunctionWithNullableValues(new Function<Integer, ClassDescriptor>(){

            @Override
            public ClassDescriptor fun(Integer fqNameIndex) {
                return TypeDeserializer.this.computeClassDescriptor(fqNameIndex);
            }
        }, StorageManager.ReferenceKind.STRONG);
    }

    DescriptorFinder getDescriptorFinder() {
        return this.descriptorFinder;
    }

    @Nullable
    public JetType typeOrNull(@Nullable ProtoBuf.Type proto) {
        if (proto == null) {
            return null;
        }
        return this.type(proto);
    }

    @NotNull
    public JetType type(@NotNull ProtoBuf.Type proto) {
        return new DeserializedType(proto);
    }

    private TypeConstructor typeConstructor(ProtoBuf.Type proto) {
        ProtoBuf.Type.Constructor constructorProto = proto.getConstructor();
        int id = constructorProto.getId();
        TypeConstructor typeConstructor = this.typeConstructor(constructorProto);
        if (typeConstructor == null) {
            String message = constructorProto.getKind() == ProtoBuf.Type.Constructor.Kind.CLASS ? this.nameResolver.getClassId(id).asSingleFqName().asString() : "Unknown type parameter " + id;
            typeConstructor = ErrorUtils.createErrorType(message).getConstructor();
        }
        return typeConstructor;
    }

    @Nullable
    private TypeConstructor typeConstructor(@NotNull ProtoBuf.Type.Constructor proto) {
        switch (proto.getKind()) {
            case CLASS: {
                ClassDescriptor classDescriptor = this.classDescriptors.fun(proto.getId());
                if (classDescriptor == null) {
                    return null;
                }
                return classDescriptor.getTypeConstructor();
            }
            case TYPE_PARAMETER: {
                TypeParameterDescriptor descriptor = this.typeParameterDescriptors.get(proto.getId());
                if (descriptor == null && this.parent != null) {
                    descriptor = this.parent.typeParameterDescriptors.get(proto.getId());
                }
                if (descriptor == null) {
                    return null;
                }
                return descriptor.getTypeConstructor();
            }
        }
        throw new IllegalStateException("Unknown kind " + proto.getKind());
    }

    @Nullable
    private ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId classId = this.nameResolver.getClassId(fqNameIndex);
        return this.descriptorFinder.findClass(classId);
    }

    private List<TypeProjection> typeArguments(List<ProtoBuf.Type.Argument> protos) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>(protos.size());
        for (ProtoBuf.Type.Argument proto : protos) {
            result.add(this.typeProjection(proto));
        }
        return result;
    }

    private TypeProjection typeProjection(ProtoBuf.Type.Argument proto) {
        return new TypeProjection(TypeDeserializer.variance(proto.getProjection()), this.type(proto.getType()));
    }

    private static Variance variance(ProtoBuf.Type.Argument.Projection proto) {
        switch (proto) {
            case IN: {
                return Variance.IN_VARIANCE;
            }
            case OUT: {
                return Variance.OUT_VARIANCE;
            }
            case INV: {
                return Variance.INVARIANT;
            }
        }
        throw new IllegalStateException("Unknown projection: " + proto);
    }

    @NotNull
    private static JetScope getTypeMemberScope(@NotNull TypeConstructor constructor, @NotNull List<TypeProjection> typeArguments) {
        ClassifierDescriptor descriptor = constructor.getDeclarationDescriptor();
        if (descriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor;
            return typeParameterDescriptor.getDefaultType().getMemberScope();
        }
        return ((ClassDescriptor)descriptor).getMemberScope(typeArguments);
    }

    public String toString() {
        return this.debugName;
    }

    private class DeserializedType
    implements JetType {
        private final ProtoBuf.Type typeProto;
        private final NotNullLazyValue<TypeConstructor> constructor;
        private final List<TypeProjection> arguments;
        private final NotNullLazyValue<JetScope> memberScope;

        public DeserializedType(@NotNull ProtoBuf.Type proto) {
            this.typeProto = proto;
            this.arguments = TypeDeserializer.this.typeArguments(proto.getArgumentList());
            this.constructor = TypeDeserializer.this.storageManager.createLazyValue(new Computable<TypeConstructor>(){

                @Override
                public TypeConstructor compute() {
                    return TypeDeserializer.this.typeConstructor(DeserializedType.this.typeProto);
                }
            });
            this.memberScope = TypeDeserializer.this.storageManager.createLazyValue(new Computable<JetScope>(){

                @Override
                public JetScope compute() {
                    return DeserializedType.this.computeMemberScope();
                }
            });
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            return this.constructor.compute();
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isNullable() {
            return this.typeProto.getNullable();
        }

        @NotNull
        private JetScope computeMemberScope() {
            TypeConstructor typeConstructor = this.getConstructor();
            if (ErrorUtils.isError(typeConstructor)) {
                return ErrorUtils.createErrorScope(typeConstructor.toString());
            }
            return TypeDeserializer.getTypeMemberScope(typeConstructor, this.getArguments());
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            return this.memberScope.compute();
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return TypeUtils.toString(this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JetType)) {
                return false;
            }
            JetType type = (JetType)o;
            return this.isNullable() == type.isNullable() && JetTypeChecker.INSTANCE.equalTypes(this, type);
        }

        public int hashCode() {
            int result = this.getConstructor().hashCode();
            result = 31 * result + ((Object)this.getArguments()).hashCode();
            result = 31 * result + (this.isNullable() ? 1 : 0);
            return result;
        }
    }

    public static interface TypeParameterResolver {
        public static final TypeParameterResolver NONE = new TypeParameterResolver(){

            @Override
            @NotNull
            public List<DeserializedTypeParameterDescriptor> getTypeParameters(@NotNull TypeDeserializer typeDeserializer) {
                return Collections.emptyList();
            }
        };

        @NotNull
        public List<DeserializedTypeParameterDescriptor> getTypeParameters(@NotNull TypeDeserializer var1);
    }
}

