/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.ClassId;
import org.jetbrains.jet.descriptors.serialization.DescriptorSerializer;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;

public class ClassSerializationUtil {
    private ClassSerializationUtil() {
    }

    public static void serializeClass(@NotNull ClassDescriptor classDescriptor, @NotNull DescriptorSerializer serializer, @NotNull Sink sink) {
        ProtoBuf.Class classProto = serializer.classProto(classDescriptor).build();
        sink.writeClass(classDescriptor, classProto);
        ClassSerializationUtil.serializeClasses(classDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors(), serializer, sink);
        ClassSerializationUtil.serializeClasses(classDescriptor.getUnsubstitutedInnerClassesScope().getObjectDescriptors(), serializer, sink);
        ClassDescriptor classObjectDescriptor = classDescriptor.getClassObjectDescriptor();
        if (classObjectDescriptor != null) {
            ClassSerializationUtil.serializeClass(classObjectDescriptor, serializer, sink);
        }
    }

    public static void serializeClasses(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorSerializer serializer, @NotNull Sink sink) {
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
            ClassSerializationUtil.serializeClass((ClassDescriptor)declarationDescriptor, serializer, sink);
        }
    }

    @NotNull
    public static ClassId getClassId(@NotNull ClassDescriptor classDescriptor) {
        DeclarationDescriptor containingDeclaration = classDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor) {
            NamespaceDescriptor namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
            return new ClassId(ClassSerializationUtil.getPackageFqName(namespaceDescriptor), FqNameUnsafe.topLevel(classDescriptor.getName()));
        }
        ClassDescriptor outer = (ClassDescriptor)containingDeclaration;
        ClassId outerId = ClassSerializationUtil.getClassId(outer);
        return outerId.createNestedClassId(classDescriptor.getName());
    }

    @NotNull
    public static FqName getPackageFqName(@NotNull NamespaceDescriptor namespaceDescriptor) {
        if (DescriptorUtils.isRootNamespace(namespaceDescriptor)) {
            return FqName.ROOT;
        }
        NamespaceDescriptor parent = (NamespaceDescriptor)namespaceDescriptor.getContainingDeclaration();
        return ClassSerializationUtil.getPackageFqName(parent).child(namespaceDescriptor.getName());
    }

    public static interface Sink {
        public void writeClass(@NotNull ClassDescriptor var1, @NotNull ProtoBuf.Class var2);
    }
}

