/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.config;

import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.config.CompilerConfigurationKey;

public class CompilerConfiguration {
    private final Map<Key, Object> map = new HashMap<Key, Object>();
    private boolean readOnly = false;

    @Nullable
    public <T> T get(@NotNull CompilerConfigurationKey<T> key) {
        Object data = this.map.get(key.ideaKey);
        return (T)(data == null ? null : CompilerConfiguration.unmodifiable(data));
    }

    @NotNull
    public <T> T get(@NotNull CompilerConfigurationKey<T> key, @NotNull T defaultValue) {
        Object data = this.map.get(key.ideaKey);
        return (T)(data == null ? defaultValue : CompilerConfiguration.unmodifiable(data));
    }

    @NotNull
    public <T> List<T> getList(@NotNull CompilerConfigurationKey<List<T>> key) {
        List data = (List)this.map.get(key.ideaKey);
        if (data == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(data);
    }

    public <T> void put(@NotNull CompilerConfigurationKey<T> key, @Nullable T value) {
        this.checkReadOnly();
        this.map.put(key.ideaKey, value);
    }

    public <T> void add(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull T value) {
        this.checkReadOnly();
        Key ideaKey = key.ideaKey;
        if (this.map.get(ideaKey) == null) {
            this.map.put(ideaKey, new ArrayList());
        }
        List list = (List)this.map.get(ideaKey);
        list.add(value);
    }

    public <T> void addAll(@NotNull CompilerConfigurationKey<List<T>> key, @NotNull Collection<T> values) {
        this.checkReadOnly();
        CompilerConfiguration.checkForNullElements(values);
        Key ideaKey = key.ideaKey;
        if (this.map.get(ideaKey) == null) {
            this.map.put(ideaKey, new ArrayList());
        }
        List list = (List)this.map.get(ideaKey);
        list.addAll(values);
    }

    public CompilerConfiguration copy() {
        CompilerConfiguration copy = new CompilerConfiguration();
        copy.map.putAll(this.map);
        return copy;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            throw new IllegalStateException("CompilerConfiguration is read-only");
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (readOnly != this.readOnly) {
            this.checkReadOnly();
            this.readOnly = readOnly;
        }
    }

    @NotNull
    private static <T> T unmodifiable(@NotNull T object) {
        if (object instanceof List) {
            return (T)Collections.unmodifiableList((List)object);
        }
        if (object instanceof Map) {
            return (T)Collections.unmodifiableMap((Map)object);
        }
        if (object instanceof Collection) {
            return (T)Collections.unmodifiableCollection((Collection)object);
        }
        return object;
    }

    private static <T> void checkForNullElements(Collection<T> values) {
        int index = 0;
        for (T value : values) {
            if (value == null) {
                throw new IllegalArgumentException("Element " + index + " is null, while null values in compiler configuration are not allowed");
            }
            ++index;
        }
    }
}

