/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.intrinsics;

import com.google.common.collect.Maps;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

class IntrinsicsMap {
    private final Map<Key, IntrinsicMethod> intrinsicsMap = Maps.newHashMap();

    IntrinsicsMap() {
    }

    private static int valueParameterCountForKey(@NotNull CallableMemberDescriptor member) {
        if (member instanceof PropertyDescriptor) {
            return -1;
        }
        return member.getValueParameters().size();
    }

    public void registerIntrinsic(@NotNull FqNameUnsafe owner, @NotNull Name name, int valueParameterCount, @NotNull IntrinsicMethod impl) {
        this.intrinsicsMap.put(new Key(owner, name, valueParameterCount), impl);
    }

    public void registerIntrinsic(@NotNull FqName owner, @NotNull Name name, int valueParameterCount, @NotNull IntrinsicMethod impl) {
        this.registerIntrinsic(owner.toUnsafe(), name, valueParameterCount, impl);
    }

    @Nullable
    public IntrinsicMethod getIntrinsic(@NotNull CallableMemberDescriptor descriptor) {
        Key key = new Key(DescriptorUtils.getFQName(descriptor.getContainingDeclaration()), descriptor.getName(), IntrinsicsMap.valueParameterCountForKey(descriptor));
        return this.intrinsicsMap.get(key);
    }

    private static final class Key {
        @NotNull
        private final FqNameUnsafe owner;
        @NotNull
        private final Name name;
        private final int valueParameterCount;

        private Key(@NotNull FqNameUnsafe owner, @NotNull Name name, int valueParameterCount) {
            this.owner = owner;
            this.name = name;
            this.valueParameterCount = valueParameterCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.valueParameterCount != key.valueParameterCount) {
                return false;
            }
            if (!this.name.equals(key.name)) {
                return false;
            }
            return this.owner.equals(key.owner);
        }

        public int hashCode() {
            int result = this.owner.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.valueParameterCount;
            return result;
        }
    }
}

