/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.JavaElementFinder;
import org.jetbrains.jet.asJava.LightClassGenerationSupport;
import org.jetbrains.jet.codegen.binding.PsiCodegenPredictor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.java.JetClsMethod;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.utils.ExceptionUtils;
import org.jetbrains.jet.utils.KotlinVfsUtil;

public class LightClassUtil {
    private static final Logger LOG = Logger.getInstance(LightClassUtil.class);
    public static final File BUILT_INS_SRC_DIR = new File("idea/builtinsSrc", "jet");

    public static boolean belongsToKotlinBuiltIns(@NotNull JetFile file) {
        VirtualFile parent;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (parent = virtualFile.getParent()) != null) {
            try {
                String jetVfsPathUrl = KotlinVfsUtil.convertFromUrl(LightClassUtil.getBuiltInsDirUrl());
                String fileDirVfsUrl = parent.getUrl();
                if (jetVfsPathUrl.equals(fileDirVfsUrl)) {
                    return true;
                }
            }
            catch (MalformedURLException e) {
                LOG.error(e);
            }
        }
        return false;
    }

    @NotNull
    public static URL getBuiltInsDirUrl() {
        String builtInFilePath = "/jet/Library.jet";
        URL url = KotlinBuiltIns.class.getResource(builtInFilePath);
        if (url == null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    return new URL(StandardFileSystems.FILE_PROTOCOL, "", FileUtil.toSystemIndependentName(BUILT_INS_SRC_DIR.getAbsolutePath()));
                }
                catch (MalformedURLException e) {
                    throw ExceptionUtils.rethrow(e);
                }
            }
            throw new IllegalStateException("Built-ins file wasn't found at url: " + builtInFilePath);
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), PathUtil.getParentPath(url.getFile()));
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Nullable
    static PsiClass findClass(@NotNull FqName fqn, @NotNull StubElement<?> stub) {
        if (stub instanceof PsiClassStub && Comparing.equal(fqn.asString(), ((PsiClassStub)stub).getQualifiedName())) {
            return (PsiClass)stub.getPsi();
        }
        if (stub instanceof PsiClassStub || stub instanceof PsiFileStub) {
            for (StubElement child : stub.getChildrenStubs()) {
                PsiClass answer = LightClassUtil.findClass(fqn, child);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            return null;
        }
        return LightClassGenerationSupport.getInstance(classOrObject.getProject()).getPsiClass(classOrObject);
    }

    @Nullable
    public static PsiMethod getLightClassAccessorMethod(@NotNull JetPropertyAccessor accessor) {
        return LightClassUtil.getPsiMethodWrapper(accessor);
    }

    @NotNull
    public static PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull JetProperty property) {
        JetPropertyAccessor getter = property.getGetter();
        JetPropertyAccessor setter = property.getSetter();
        PsiMethod getterWrapper = getter != null ? LightClassUtil.getLightClassAccessorMethod(getter) : null;
        PsiMethod setterWrapper = setter != null ? LightClassUtil.getLightClassAccessorMethod(setter) : null;
        return LightClassUtil.extractPropertyAccessors(property, getterWrapper, setterWrapper);
    }

    public static PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull JetParameter parameter) {
        return LightClassUtil.extractPropertyAccessors(parameter, null, null);
    }

    @Nullable
    public static PsiMethod getLightClassMethod(@NotNull JetNamedFunction function) {
        return LightClassUtil.getPsiMethodWrapper(function);
    }

    @Nullable
    private static PsiMethod getPsiMethodWrapper(@NotNull JetDeclaration declaration) {
        List<PsiMethod> wrappers = LightClassUtil.getPsiMethodWrappers(declaration, false);
        return !wrappers.isEmpty() ? wrappers.get(0) : null;
    }

    @NotNull
    private static List<PsiMethod> getPsiMethodWrappers(@NotNull JetDeclaration declaration, boolean collectAll) {
        PsiClass psiClass = LightClassUtil.getWrappingClass(declaration);
        if (psiClass == null) {
            return Collections.emptyList();
        }
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        for (PsiMethod method : psiClass.getMethods()) {
            try {
                if (!(method instanceof JetClsMethod) || ((JetClsMethod)method).getOrigin() != declaration) continue;
                methods.add(method);
                if (collectAll) continue;
                return methods;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException("Error while wrapping declaration " + declaration.getName() + "Context\n:" + String.format("=== In file ===\n%s\n=== On element ===\n%s\n=== WrappedElement ===\n%s\n", declaration.getContainingFile().getText(), declaration.getText(), method.toString()), e);
            }
        }
        return methods;
    }

    @Nullable
    private static PsiClass getWrappingClass(@NotNull JetDeclaration declaration) {
        JetClass constructorClass;
        if (declaration instanceof JetParameter && (constructorClass = JetPsiUtil.getClassIfParameterIsProperty((JetParameter)declaration)) != null) {
            return LightClassUtil.getPsiClass(constructorClass);
        }
        if (declaration instanceof JetPropertyAccessor) {
            PsiElement propertyParent = declaration.getParent();
            assert (propertyParent instanceof JetProperty) : "JetProperty is expected to be parent of accessor";
            declaration = (JetProperty)propertyParent;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)declaration, JetFunction.class, JetProperty.class) != null) {
            return null;
        }
        PsiElement parent = declaration.getParent();
        if (parent instanceof JetFile) {
            JvmClassName jvmName = PsiCodegenPredictor.getPredefinedJvmClassName((JetFile)parent, true);
            if (jvmName != null) {
                Project project = declaration.getProject();
                String fqName = jvmName.getFqName().asString();
                return JavaElementFinder.getInstance(project).findClass(fqName, GlobalSearchScope.allScope(project));
            }
        } else if (parent instanceof JetClassBody) {
            assert (parent.getParent() instanceof JetClassOrObject);
            return LightClassUtil.getPsiClass((JetClassOrObject)parent.getParent());
        }
        return null;
    }

    private static PropertyAccessorsPsiMethods extractPropertyAccessors(@NotNull JetDeclaration jetDeclaration, @Nullable PsiMethod specialGetter, @Nullable PsiMethod specialSetter) {
        PsiMethod getterWrapper = specialGetter;
        PsiMethod setterWrapper = specialSetter;
        if (getterWrapper == null || setterWrapper == null) {
            List<PsiMethod> wrappers = LightClassUtil.getPsiMethodWrappers(jetDeclaration, true);
            assert (wrappers.size() <= 2) : "Maximum two wrappers are expected to be generated for declaration: " + jetDeclaration.getText();
            for (PsiMethod wrapper : wrappers) {
                if (wrapper.getName().startsWith("set")) {
                    assert (setterWrapper == null) : String.format("Setter accessor isn't expected to be reassigned (old: %s, new: %s)", setterWrapper, wrapper);
                    setterWrapper = wrapper;
                    continue;
                }
                assert (getterWrapper == null) : String.format("Getter accessor isn't expected to be reassigned (old: %s, new: %s)", getterWrapper, wrapper);
                getterWrapper = wrapper;
            }
        }
        return new PropertyAccessorsPsiMethods(getterWrapper, setterWrapper);
    }

    private LightClassUtil() {
    }

    public static class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod> {
        private final PsiMethod getter;
        private final PsiMethod setter;
        private final Collection<PsiMethod> accessors = new ArrayList<PsiMethod>(2);

        PropertyAccessorsPsiMethods(@Nullable PsiMethod getter, @Nullable PsiMethod setter) {
            this.getter = getter;
            if (getter != null) {
                this.accessors.add(getter);
            }
            this.setter = setter;
            if (setter != null) {
                this.accessors.add(setter);
            }
        }

        @Nullable
        public PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public PsiMethod getSetter() {
            return this.setter;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            return this.accessors.iterator();
        }
    }
}

