/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import com.google.common.collect.Sets;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.KotlinJavaFileStubProvider;
import org.jetbrains.jet.asJava.KotlinLightClass;
import org.jetbrains.jet.asJava.KotlinLightClassForPackageBase;
import org.jetbrains.jet.asJava.LightClassUtil;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class KotlinLightClassForPackage
extends KotlinLightClassForPackageBase
implements KotlinLightClass,
JetJavaMirrorMarker {
    private final FqName packageFqName;
    private final FqName packageClassFqName;
    private final GlobalSearchScope searchScope;
    private final Collection<JetFile> files;
    private final int hashCode;
    private final CachedValue<PsiJavaFileStub> javaFileStub;

    @Nullable
    public static KotlinLightClassForPackage create(@NotNull PsiManager manager, @NotNull FqName qualifiedName, @NotNull GlobalSearchScope searchScope, @NotNull Collection<JetFile> files) {
        for (JetFile file : files) {
            if (!LightClassUtil.belongsToKotlinBuiltIns(file)) continue;
            return null;
        }
        return new KotlinLightClassForPackage(manager, qualifiedName, searchScope, files);
    }

    private KotlinLightClassForPackage(@NotNull PsiManager manager, @NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope, @NotNull Collection<JetFile> files) {
        super(manager);
        this.packageFqName = packageFqName;
        this.packageClassFqName = PackageClassUtils.getPackageClassFqName(packageFqName);
        this.searchScope = searchScope;
        assert (!files.isEmpty()) : "No files for package " + packageFqName;
        this.files = Sets.newHashSet(files);
        this.hashCode = this.computeHashCode();
        KotlinJavaFileStubProvider stubProvider = KotlinJavaFileStubProvider.createForPackageClass(this.getProject(), packageFqName, searchScope);
        this.javaFileStub = CachedValuesManager.getManager(this.getProject()).createCachedValue(stubProvider, false);
    }

    @Override
    @NotNull
    public FqName getFqName() {
        return this.packageClassFqName;
    }

    @Override
    @Nullable
    public String getName() {
        return this.packageClassFqName.shortName().asString();
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.packageClassFqName.asString();
    }

    @Override
    public boolean isValid() {
        return KotlinLightClassForPackage.allValid(this.files);
    }

    private static boolean allValid(Collection<JetFile> files) {
        for (JetFile file : files) {
            if (file.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement copy() {
        return new KotlinLightClassForPackage(this.getManager(), this.packageFqName, this.searchScope, this.files);
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        PsiClass psiClass = LightClassUtil.findClass(this.packageClassFqName, this.javaFileStub.getValue());
        if (psiClass == null) {
            throw new IllegalStateException("Package class was not found " + this.packageFqName);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        return this.files.iterator().next();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof PsiClass && Comparing.equal(((PsiClass)another).getQualifiedName(), this.getQualifiedName());
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        throw new UnsupportedOperationException("This should be done byt JetIconProvider");
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.getManager().hashCode();
        result = 31 * result + ((Object)this.files).hashCode();
        result = 31 * result + this.packageFqName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KotlinLightClassForPackage lightClass = (KotlinLightClassForPackage)obj;
        if (this.hashCode != lightClass.hashCode) {
            return false;
        }
        if (this.getManager() != lightClass.getManager()) {
            return false;
        }
        if (!((Object)this.files).equals(lightClass.files)) {
            return false;
        }
        return this.packageFqName.equals(lightClass.packageFqName);
    }

    @Override
    public String toString() {
        try {
            return KotlinLightClassForPackage.class.getSimpleName() + ":" + this.getQualifiedName();
        }
        catch (Throwable e) {
            return KotlinLightClassForPackage.class.getSimpleName() + ":" + e.toString();
        }
    }
}

