/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.LinkedDiffPaths;
import java.util.Arrays;

class IntLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final LinkedDiffPaths myPathsMatrix;
    private final int[] myPrevPathKey;
    private int[] myPrevEnds;
    private int[] myCurrentEnds;
    private final int myMaxX;
    private final int myMaxY;

    public IntLCS(int[] first, int[] second) {
        this.myFirst = first;
        this.mySecond = second;
        this.myMaxX = this.myFirst.length;
        this.myMaxY = this.mySecond.length;
        this.myPathsMatrix = new LinkedDiffPaths(this.myMaxX, this.myMaxY);
        this.myPrevPathKey = new int[this.myMaxX + this.myMaxY + 1];
        Arrays.fill(this.myPrevPathKey, -1);
        this.myPrevEnds = new int[this.myMaxX + this.myMaxY + 1];
        this.myCurrentEnds = new int[this.myMaxX + this.myMaxY + 1];
    }

    public int execute() throws FilesTooBigForDiffException {
        for (int d = 0; d <= this.myMaxX + this.myMaxY; ++d) {
            int minDiag = -this.calcBound(this.myMaxY, d);
            int maxDiag = this.calcBound(this.myMaxX, d);
            if (d == 0) {
                int end = this.skipEquals(0, 0);
                if (end > 0) {
                    int xy = end - 1;
                    this.myPrevPathKey[this.myMaxY] = this.myPathsMatrix.encodeStep(xy, xy, end, false, -1);
                }
                if (this.myMaxX == this.myMaxY && end == this.myMaxX) {
                    return 0;
                }
                this.myPrevEnds[this.myMaxY] = end;
                continue;
            }
            System.arraycopy(this.myPrevEnds, minDiag + this.myMaxY, this.myCurrentEnds, minDiag + this.myMaxY, maxDiag - minDiag);
            for (int k = minDiag; k <= maxDiag; k += 2) {
                int prevEndH;
                int end;
                if (k == -d) {
                    int prevEndV = this.myPrevEnds[k + 1 + this.myMaxY];
                    int vertical = this.findDiagonalEnd(k + 1, prevEndV, true);
                    end = this.encodeStep(prevEndV, vertical, k, true);
                } else if (k == d) {
                    prevEndH = this.myPrevEnds[k - 1 + this.myMaxY];
                    int horisontal = this.findDiagonalEnd(k - 1, prevEndH, false);
                    end = this.encodeStep(prevEndH, horisontal, k, false);
                } else {
                    prevEndH = this.myPrevEnds[k - 1 + this.myMaxY];
                    int prevEndV = this.myPrevEnds[k + 1 + this.myMaxY];
                    if (prevEndH + 1 > prevEndV) {
                        int horisontal = this.findDiagonalEnd(k - 1, prevEndH, false);
                        end = this.encodeStep(prevEndH, horisontal, k, false);
                    } else {
                        int vertical = this.findDiagonalEnd(k + 1, prevEndV, true);
                        end = this.encodeStep(prevEndV, vertical, k, true);
                    }
                }
                this.myCurrentEnds[k + this.myMaxY] = end;
                if (k != this.myMaxX - this.myMaxY || end != this.myMaxX) continue;
                return d;
            }
            int[] temps = this.myCurrentEnds;
            this.myCurrentEnds = this.myPrevEnds;
            this.myPrevEnds = temps;
        }
        throw new RuntimeException();
    }

    public LinkedDiffPaths getPaths() {
        return this.myPathsMatrix;
    }

    private int findDiagonalEnd(int prevDiagonal, int prevEnd, boolean isVertical) {
        int x = prevEnd;
        int y = x - prevDiagonal;
        if (isVertical) {
            ++y;
        } else {
            ++x;
        }
        return this.skipEquals(x, y);
    }

    private int encodeStep(int prevEnd, int diagLength, int tDiagonal, boolean afterVertical) throws FilesTooBigForDiffException {
        int end = prevEnd + diagLength;
        int prevDiagonal = tDiagonal + this.myMaxY;
        if (!afterVertical) {
            ++end;
        }
        prevDiagonal = afterVertical ? ++prevDiagonal : --prevDiagonal;
        int x = end - 1;
        int y = x - tDiagonal;
        if (x == -1 || y == -1 || x >= this.myMaxX || y >= this.myMaxY) {
            return end;
        }
        this.myPrevPathKey[tDiagonal + this.myMaxY] = this.myPathsMatrix.encodeStep(x, y, diagLength, afterVertical, this.myPrevPathKey[prevDiagonal]);
        return end;
    }

    private int calcBound(int bound, int d) {
        return d <= bound ? d : 2 * bound - d;
    }

    private int skipEquals(int x, int y) {
        int skipped = 0;
        while (x < this.myMaxX && y < this.myMaxY && this.myFirst[x] == this.mySecond[y]) {
            ++skipped;
            ++x;
            ++y;
        }
        return skipped;
    }
}

