/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.IgnorePsiEventsMarker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.TextBlock;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.util.messages.MessageBus;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiToDocumentSynchronizer
extends PsiTreeChangeAdapter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiToDocumentSynchronizer");
    private final PsiDocumentManagerBase myPsiDocumentManager;
    private final MessageBus myBus;
    private final Map<Document, Pair<DocumentChangeTransaction, Integer>> myTransactionsMap = new HashMap<Document, Pair<DocumentChangeTransaction, Integer>>();
    private volatile Document mySyncDocument = null;
    private boolean myIgnorePsiEvents;

    public PsiToDocumentSynchronizer(PsiDocumentManagerBase psiDocumentManager, MessageBus bus) {
        this.myPsiDocumentManager = psiDocumentManager;
        this.myBus = bus;
    }

    @Nullable
    public DocumentChangeTransaction getTransaction(Document document) {
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(document);
        return pair != null ? pair.getFirst() : null;
    }

    public boolean isInSynchronization(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "isInSynchronization"));
        }
        return this.mySyncDocument == document;
    }

    void cleanupForNextTest() {
        this.myTransactionsMap.clear();
        this.mySyncDocument = null;
    }

    private void doSync(final @NotNull PsiTreeChangeEvent event, boolean force, final @NotNull DocSyncAction syncAction) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "doSync"));
        }
        if (syncAction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "doSync"));
        }
        if (!this.toProcessPsiEvent()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        if (psiFile == null || psiFile.getNode() == null) {
            return;
        }
        final DocumentEx document = (DocumentEx)this.myPsiDocumentManager.getCachedDocument(psiFile);
        if (document == null || document instanceof DocumentWindow) {
            return;
        }
        if (!force && this.getTransaction(document) == null) {
            return;
        }
        TextBlock textBlock = TextBlock.get(psiFile);
        if (!textBlock.isEmpty()) {
            throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
        }
        textBlock.performAtomically(new Runnable(){

            @Override
            public void run() {
                syncAction.syncDocument(document, (PsiTreeChangeEventImpl)event);
            }
        });
        boolean insideTransaction = this.myTransactionsMap.containsKey(document);
        if (!insideTransaction) {
            document.setModificationStamp(psiFile.getViewProvider().getModificationStamp());
            if (LOG.isDebugEnabled()) {
                PsiDocumentManagerBase.checkConsistency(psiFile, document);
            }
        }
        psiFile.getViewProvider().contentsSynchronized();
    }

    @Override
    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "childAdded"));
        }
        if (!(event.getChild() instanceof ForeignLeafPsiElement)) {
            this.doSync(event, false, new DocSyncAction(){

                @Override
                public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer$2", "syncDocument"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiToDocumentSynchronizer$2", "syncDocument"));
                    }
                    PsiToDocumentSynchronizer.this.insertString(document, event.getOffset(), event.getChild().getText());
                }
            });
        }
    }

    @Override
    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "childRemoved"));
        }
        if (!(event.getChild() instanceof ForeignLeafPsiElement)) {
            this.doSync(event, false, new DocSyncAction(){

                @Override
                public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer$3", "syncDocument"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiToDocumentSynchronizer$3", "syncDocument"));
                    }
                    PsiToDocumentSynchronizer.this.deleteString(document, event.getOffset(), event.getOffset() + event.getOldLength());
                }
            });
        }
    }

    @Override
    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "childReplaced"));
        }
        this.doSync(event, false, new DocSyncAction(){

            @Override
            public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer$4", "syncDocument"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiToDocumentSynchronizer$4", "syncDocument"));
                }
                int oldLength = event.getOldChild() instanceof ForeignLeafPsiElement ? 0 : event.getOldLength();
                String newText = event.getNewChild() instanceof ForeignLeafPsiElement ? "" : event.getNewChild().getText();
                PsiToDocumentSynchronizer.this.replaceString(document, event.getOffset(), event.getOffset() + oldLength, newText);
            }
        });
    }

    @Override
    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "childrenChanged"));
        }
        this.doSync(event, false, new DocSyncAction(){

            @Override
            public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer$5", "syncDocument"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiToDocumentSynchronizer$5", "syncDocument"));
                }
                PsiToDocumentSynchronizer.this.replaceString(document, event.getOffset(), event.getOffset() + event.getOldLength(), event.getParent().getText());
            }
        });
    }

    public void setIgnorePsiEvents(boolean ignorePsiEvents) {
        this.myIgnorePsiEvents = ignorePsiEvents;
    }

    public boolean isIgnorePsiEvents() {
        return this.myIgnorePsiEvents;
    }

    private boolean toProcessPsiEvent() {
        return !this.myIgnorePsiEvents && !ApplicationManager.getApplication().hasWriteAction(IgnorePsiEventsMarker.class);
    }

    public void replaceString(Document document, int startOffset, int endOffset, String s) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, s);
        }
    }

    public void insertString(Document document, int offset, String s) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(offset, 0, s);
        }
    }

    private void deleteString(Document document, int startOffset, int endOffset) {
        DocumentChangeTransaction documentChangeTransaction = this.getTransaction(document);
        if (documentChangeTransaction != null) {
            documentChangeTransaction.replace(startOffset, endOffset - startOffset, "");
        }
    }

    public void startTransaction(@NotNull Project project, Document doc, PsiElement scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "startTransaction"));
        }
        LOG.assertTrue(!project.isDisposed());
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            PsiFile psiFile = scope != null ? scope.getContainingFile() : null;
            pair = new Pair<DocumentChangeTransaction, Integer>(new DocumentChangeTransaction(doc, scope != null ? psiFile : null), 0);
            this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionStarted(doc, psiFile);
        } else {
            pair = new Pair<DocumentChangeTransaction, Integer>(pair.getFirst(), pair.getSecond() + 1);
        }
        this.myTransactionsMap.put(doc, pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final DocumentChangeTransaction documentChangeTransaction = this.removeTransaction(document);
        if (documentChangeTransaction == null) {
            return false;
        }
        PsiFile changeScope = documentChangeTransaction.getChangeScope();
        try {
            this.mySyncDocument = document;
            PsiTreeChangeEventImpl fakeEvent = new PsiTreeChangeEventImpl(changeScope.getManager());
            fakeEvent.setParent(changeScope);
            fakeEvent.setFile(changeScope.getContainingFile());
            this.doSync(fakeEvent, true, new DocSyncAction(){

                @Override
                public void syncDocument(@NotNull Document document, @NotNull PsiTreeChangeEventImpl event) {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer$6", "syncDocument"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiToDocumentSynchronizer$6", "syncDocument"));
                    }
                    PsiToDocumentSynchronizer.doCommitTransaction(document, documentChangeTransaction);
                }
            });
            this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionCompleted(document, changeScope);
        }
        finally {
            this.mySyncDocument = null;
        }
        return true;
    }

    public void doCommitTransaction(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "doCommitTransaction"));
        }
        PsiToDocumentSynchronizer.doCommitTransaction(document, this.getTransaction(document));
        this.myBus.syncPublisher(PsiDocumentTransactionListener.TOPIC).transactionCompleted(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCommitTransaction(@NotNull Document document, @NotNull DocumentChangeTransaction documentChangeTransaction) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "doCommitTransaction"));
        }
        if (documentChangeTransaction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/PsiToDocumentSynchronizer", "doCommitTransaction"));
        }
        DocumentEx ex = (DocumentEx)document;
        ex.suppressGuardedExceptions();
        try {
            boolean isReadOnly = !document.isWritable();
            ex.setReadOnly(false);
            Set<Pair<MutableTextRange, StringBuffer>> affectedFragments = documentChangeTransaction.getAffectedFragments();
            for (Pair<MutableTextRange, StringBuffer> pair : affectedFragments) {
                StringBuffer replaceBuffer = pair.getSecond();
                MutableTextRange range = pair.getFirst();
                if (replaceBuffer.length() == 0) {
                    ex.deleteString(range.getStartOffset(), range.getEndOffset());
                    continue;
                }
                if (range.getLength() == 0) {
                    ex.insertString(range.getStartOffset(), replaceBuffer);
                    continue;
                }
                ex.replaceString(range.getStartOffset(), range.getEndOffset(), replaceBuffer);
            }
            ex.setReadOnly(isReadOnly);
        }
        finally {
            ex.unSuppressGuardedExceptions();
        }
    }

    @Nullable
    private DocumentChangeTransaction removeTransaction(Document doc) {
        Pair<DocumentChangeTransaction, Integer> pair = this.myTransactionsMap.get(doc);
        if (pair == null) {
            return null;
        }
        if (pair.getSecond() > 0) {
            pair = new Pair<DocumentChangeTransaction, Integer>(pair.getFirst(), pair.getSecond() - 1);
            this.myTransactionsMap.put(doc, pair);
            return null;
        }
        this.myTransactionsMap.remove(doc);
        return pair.getFirst();
    }

    public boolean isDocumentAffectedByTransactions(Document document) {
        return this.myTransactionsMap.containsKey(document);
    }

    public static class MutableTextRange {
        private final int myLength;
        private int myStartOffset;

        public MutableTextRange(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myLength = endOffset - startOffset;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myStartOffset + this.myLength;
        }

        public int getLength() {
            return this.myLength;
        }

        public String toString() {
            return "[" + this.getStartOffset() + ", " + this.getEndOffset() + "]";
        }

        public void shift(int lengthDiff) {
            this.myStartOffset += lengthDiff;
        }
    }

    public static class DocumentChangeTransaction {
        private final Set<Pair<MutableTextRange, StringBuffer>> myAffectedFragments = new TreeSet<Pair<MutableTextRange, StringBuffer>>(new Comparator<Pair<MutableTextRange, StringBuffer>>(){

            @Override
            public int compare(Pair<MutableTextRange, StringBuffer> o1, Pair<MutableTextRange, StringBuffer> o2) {
                return o1.getFirst().getStartOffset() - o2.getFirst().getStartOffset();
            }
        });
        private final Document myDocument;
        private final PsiFile myChangeScope;

        public DocumentChangeTransaction(Document doc, PsiFile scope) {
            this.myDocument = doc;
            this.myChangeScope = scope;
        }

        public Set<Pair<MutableTextRange, StringBuffer>> getAffectedFragments() {
            return this.myAffectedFragments;
        }

        public PsiFile getChangeScope() {
            return this.myChangeScope;
        }

        public void replace(int initialStart, int length, String replace) {
            int newStartInReplace;
            int start = 0;
            int end = start + length;
            int replaceLength = replace.length();
            String chars = this.getText(start + initialStart, end + initialStart);
            if (chars.equals(replace)) {
                return;
            }
            int newEndInReplace = replaceLength;
            for (newStartInReplace = 0; newStartInReplace < replaceLength && start < end && replace.charAt(newStartInReplace) == chars.charAt(start); ++start, ++newStartInReplace) {
            }
            while (start < end && newStartInReplace < newEndInReplace && replace.charAt(newEndInReplace - 1) == chars.charAt(end - 1)) {
                --newEndInReplace;
                --end;
            }
            if (newStartInReplace == newEndInReplace && start > 0 && start < end && StringUtil.indexOf(chars, '\n', start, end) != -1) {
                while (start > 0 && newStartInReplace > 0 && chars.charAt(start - 1) == chars.charAt(end - 1) && chars.charAt(end - 1) != '\n') {
                    --start;
                    --end;
                    --newStartInReplace;
                    --newEndInReplace;
                }
            }
            start += initialStart;
            end += initialStart;
            CharSequence charsSequence = this.myDocument.getCharsSequence();
            while (start < charsSequence.length() && end < charsSequence.length() && start > 0 && ((Object)charsSequence.subSequence(start, end)).toString().endsWith("><") && charsSequence.charAt(start - 1) == '<') {
                --start;
                --newStartInReplace;
                --end;
                --newEndInReplace;
            }
            replace = replace.substring(newStartInReplace, newEndInReplace);
            length = end - start;
            Pair<MutableTextRange, StringBuffer> fragment = this.getFragmentByRange(start, length);
            StringBuffer fragmentReplaceText = fragment.getSecond();
            int startInFragment = start - fragment.getFirst().getStartOffset();
            int lengthDiff = replace.length() - length;
            Iterator<Pair<MutableTextRange, StringBuffer>> iterator = this.myAffectedFragments.iterator();
            boolean adjust = false;
            while (iterator.hasNext()) {
                Pair<MutableTextRange, StringBuffer> pair = iterator.next();
                if (adjust) {
                    pair.getFirst().shift(lengthDiff);
                }
                if (pair != fragment) continue;
                adjust = true;
            }
            fragmentReplaceText.replace(startInFragment, startInFragment + length, replace);
        }

        private String getText(int start, int end) {
            int currentOldDocumentOffset = 0;
            int currentNewDocumentOffset = 0;
            StringBuilder text = new StringBuilder();
            Iterator<Pair<MutableTextRange, StringBuffer>> iterator = this.myAffectedFragments.iterator();
            while (iterator.hasNext() && currentNewDocumentOffset < end) {
                Pair<MutableTextRange, StringBuffer> pair = iterator.next();
                MutableTextRange range = pair.getFirst();
                StringBuffer buffer = pair.getSecond();
                int fragmentEndInNewDocument = range.getStartOffset() + buffer.length();
                if (range.getStartOffset() <= start && fragmentEndInNewDocument >= end) {
                    return buffer.substring(start - range.getStartOffset(), end - range.getStartOffset());
                }
                if (range.getStartOffset() >= start) {
                    int effectiveStart = Math.max(currentNewDocumentOffset, start);
                    text.append(this.myDocument.getCharsSequence(), effectiveStart - currentNewDocumentOffset + currentOldDocumentOffset, Math.min(range.getStartOffset(), end) - currentNewDocumentOffset + currentOldDocumentOffset);
                    if (end > range.getStartOffset()) {
                        text.append(buffer.substring(0, Math.min(end - range.getStartOffset(), buffer.length())));
                    }
                }
                currentOldDocumentOffset += range.getEndOffset() - currentNewDocumentOffset;
                currentNewDocumentOffset = fragmentEndInNewDocument;
            }
            if (currentNewDocumentOffset < end) {
                int effectiveStart = Math.max(currentNewDocumentOffset, start);
                text.append(this.myDocument.getCharsSequence(), effectiveStart - currentNewDocumentOffset + currentOldDocumentOffset, end - currentNewDocumentOffset + currentOldDocumentOffset);
            }
            return text.toString();
        }

        private Pair<MutableTextRange, StringBuffer> getFragmentByRange(int start, int length) {
            StringBuffer fragmentBuffer = new StringBuffer();
            int end = start + length;
            int documentOffset = 0;
            int effectiveOffset = 0;
            Iterator<Pair<MutableTextRange, StringBuffer>> iterator = this.myAffectedFragments.iterator();
            while (iterator.hasNext() && effectiveOffset <= end) {
                Pair<MutableTextRange, StringBuffer> pair = iterator.next();
                MutableTextRange range = pair.getFirst();
                StringBuffer buffer = pair.getSecond();
                int effectiveFragmentEnd = range.getStartOffset() + buffer.length();
                if (range.getStartOffset() <= start && effectiveFragmentEnd >= end) {
                    return pair;
                }
                if (effectiveFragmentEnd >= start) {
                    int effectiveStart = Math.max(effectiveOffset, start);
                    if (range.getStartOffset() > start) {
                        fragmentBuffer.append(this.myDocument.getCharsSequence(), effectiveStart - effectiveOffset + documentOffset, Math.min(range.getStartOffset(), end) - effectiveOffset + documentOffset);
                    }
                    if (end >= range.getStartOffset()) {
                        fragmentBuffer.append(buffer);
                        end = end > effectiveFragmentEnd ? end - (buffer.length() - range.getLength()) : range.getEndOffset();
                        effectiveFragmentEnd = range.getEndOffset();
                        start = Math.min(start, range.getStartOffset());
                        iterator.remove();
                    }
                }
                documentOffset += range.getEndOffset() - effectiveOffset;
                effectiveOffset = effectiveFragmentEnd;
            }
            if (effectiveOffset < end) {
                int effectiveStart = Math.max(effectiveOffset, start);
                fragmentBuffer.append(this.myDocument.getCharsSequence(), effectiveStart - effectiveOffset + documentOffset, end - effectiveOffset + documentOffset);
            }
            MutableTextRange newRange = new MutableTextRange(start, end);
            Pair<MutableTextRange, StringBuffer> pair = new Pair<MutableTextRange, StringBuffer>(newRange, fragmentBuffer);
            for (Pair<MutableTextRange, StringBuffer> affectedFragment : this.myAffectedFragments) {
                MutableTextRange range = affectedFragment.getFirst();
                assert (end <= range.getStartOffset() || range.getEndOffset() <= start) : "Range :" + range + "; Added: " + newRange;
            }
            this.myAffectedFragments.add(pair);
            return pair;
        }
    }

    private static interface DocSyncAction {
        public void syncDocument(@NotNull Document var1, @NotNull PsiTreeChangeEventImpl var2);
    }
}

