/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ReadOnlyModificationException;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.CharArray;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.PersistentRangeMarker;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocumentImpl
extends UserDataHolderBase
implements DocumentEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.editor.impl.DocumentImpl");
    public static boolean CHECK_DOCUMENT_CONSISTENCY = ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isUnitTestMode();
    private final List<DocumentListener> myDocumentListeners;
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers;
    private final List<RangeMarker> myGuardedBlocks;
    private final LineSet myLineSet;
    private final CharArray myText;
    private boolean myIsReadOnly;
    private boolean isStripTrailingSpacesEnabled;
    private volatile long myModificationStamp;
    private final PropertyChangeSupport myPropertyChangeSupport;
    private final Ref<DocumentListener[]> myCachedDocumentListeners;
    private final List<EditReadOnlyListener> myReadOnlyListeners;
    private int myCheckGuardedBlocks;
    private boolean myGuardsSuppressed;
    private boolean myEventsHandling;
    private final boolean myAssertThreading;
    private volatile boolean myDoingBulkUpdate;
    private volatile boolean myAcceptSlashR;
    private boolean myChangeInProgress;

    public DocumentImpl(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this(chars, false);
    }

    public DocumentImpl(@NotNull CharSequence chars, boolean forUseInNonAWTThread) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "<init>"));
        }
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRangeMarkers = new RangeMarkerTree(this);
        this.myGuardedBlocks = new ArrayList<RangeMarker>();
        this.myLineSet = new LineSet();
        this.myIsReadOnly = false;
        this.isStripTrailingSpacesEnabled = true;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myCachedDocumentListeners = Ref.create(null);
        this.myReadOnlyListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCheckGuardedBlocks = 0;
        this.myGuardsSuppressed = false;
        this.myEventsHandling = false;
        this.myDoingBulkUpdate = false;
        this.myAcceptSlashR = false;
        this.assertValidSeparators(chars);
        this.myText = new MyCharArray(CharArrayUtil.fromSequence(chars), chars.length());
        this.myLineSet.documentCreated(this);
        this.setCyclicBufferSize(0);
        this.setModificationStamp(LocalTimeCounter.currentTime());
        this.myAssertThreading = !forUseInNonAWTThread;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        if (this.myIsReadOnly != isReadOnly) {
            this.myIsReadOnly = isReadOnly;
            this.myPropertyChangeSupport.firePropertyChange("writable", !isReadOnly, isReadOnly);
        }
    }

    @Override
    public boolean isWritable() {
        return !this.myIsReadOnly;
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removeRangeMarker"));
        }
        return this.myRangeMarkers.removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "registerRangeMarker"));
        }
        this.myRangeMarkers.addInterval(rangeMarker, start, end, greedyToLeft, greedyToRight, layer);
    }

    public RangeMarker getRangeGuard(int start, int end) {
        for (RangeMarker block : this.myGuardedBlocks) {
            if (!DocumentImpl.rangesIntersect(start, true, block.getStartOffset(), block.isGreedyToLeft(), end, true, block.getEndOffset(), block.isGreedyToRight())) continue;
            return block;
        }
        return null;
    }

    private static boolean rangesIntersect(int start0, boolean leftInclusive0, int start1, boolean leftInclusive1, int end0, boolean rightInclusive0, int end1, boolean rightInclusive1) {
        if (start0 > start1 || start0 == start1 && !leftInclusive0) {
            return DocumentImpl.rangesIntersect(start1, leftInclusive1, start0, leftInclusive0, end1, rightInclusive1, end0, rightInclusive0);
        }
        if (end0 == start1) {
            return leftInclusive1 && rightInclusive0;
        }
        return end0 > start1;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (0 > startOffset || startOffset > endOffset || endOffset > this.getTextLength()) {
            LOG.error("Incorrect offsets: startOffset=" + startOffset + ", endOffset=" + endOffset + ", text length=" + this.getTextLength());
        }
        RangeMarkerImpl rangeMarkerImpl = surviveOnExternalChange ? new PersistentRangeMarker(this, startOffset, endOffset, true) : new RangeMarkerImpl(this, startOffset, endOffset, true);
        if (rangeMarkerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "createRangeMarker"));
        }
        return rangeMarkerImpl;
    }

    @Override
    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModificationStamp = modificationStamp;
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/DocumentImpl", "insertString"));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset);
        }
        if (offset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset + "; documentLength: " + this.getTextLength() + "; " + s.subSequence(Math.max(0, s.length() - 20), s.length()));
        }
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        this.assertNotNestedModification();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (s.length() == 0) {
            return;
        }
        RangeMarker marker = this.getRangeGuard(offset, offset);
        if (marker != null) {
            this.throwGuardedFragment(marker, offset, null, ((Object)s).toString());
        }
        this.myText.insert(s, offset);
    }

    @Override
    public void deleteString(int startOffset, int endOffset) {
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        if (startOffset == endOffset) {
            return;
        }
        this.assertNotNestedModification();
        CharSequence sToDelete = this.myText.substring(startOffset, endOffset);
        RangeMarker marker = this.getRangeGuard(startOffset, endOffset);
        if (marker != null) {
            this.throwGuardedFragment(marker, startOffset, ((Object)sToDelete).toString(), null);
        }
        this.myText.remove(startOffset, endOffset, sToDelete);
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/DocumentImpl", "replaceString"));
        }
        this.replaceString(startOffset, endOffset, s, LocalTimeCounter.currentTime(), startOffset == 0 && endOffset == this.getTextLength());
    }

    private void replaceString(int startOffset, int endOffset, CharSequence s, long newModificationStamp, boolean wholeTextReplaced) {
        int newStartInString;
        this.assertBounds(startOffset, endOffset);
        this.assertWriteAccess();
        this.assertValidSeparators(s);
        if (!this.isWritable()) {
            throw new ReadOnlyModificationException(this);
        }
        this.assertNotNestedModification();
        int newStringLength = s.length();
        CharSequence chars = this.getCharsSequence();
        int newEndInString = newStringLength;
        for (newStartInString = 0; newStartInString < newStringLength && startOffset < endOffset && s.charAt(newStartInString) == chars.charAt(startOffset); ++startOffset, ++newStartInString) {
        }
        while (endOffset > startOffset && newEndInString > newStartInString && s.charAt(newEndInString - 1) == chars.charAt(endOffset - 1)) {
            --newEndInString;
            --endOffset;
        }
        s = s.subSequence(newStartInString, newEndInString);
        CharSequence sToDelete = this.myText.substring(startOffset, endOffset);
        RangeMarker guard = this.getRangeGuard(startOffset, endOffset);
        if (guard != null) {
            this.throwGuardedFragment(guard, startOffset, ((Object)sToDelete).toString(), ((Object)s).toString());
        }
        this.myText.replace(startOffset, endOffset, sToDelete, s, newModificationStamp, wholeTextReplaced);
    }

    private void assertBounds(int startOffset, int endOffset) {
        if (startOffset < 0 || startOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong startOffset: " + startOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < 0 || endOffset > this.getTextLength()) {
            throw new IndexOutOfBoundsException("Wrong endOffset: " + endOffset + "; documentLength: " + this.getTextLength());
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset < startOffset: " + endOffset + " < " + startOffset + "; documentLength: " + this.getTextLength());
        }
    }

    private void assertWriteAccess() {
        Application application;
        if (this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
            application.assertWriteAccessAllowed();
        }
    }

    private void assertValidSeparators(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "assertValidSeparators"));
        }
        if (this.myAcceptSlashR) {
            return;
        }
        StringUtil.assertValidSeparators(s);
    }

    private void assertNotNestedModification() throws IllegalStateException {
        if (this.myChangeInProgress) {
            throw new IllegalStateException("Detected nested request for document modification from 'before change' callback!");
        }
    }

    private void throwGuardedFragment(RangeMarker guard, int offset, String oldString, String newString) {
        if (this.myCheckGuardedBlocks > 0 && !this.myGuardsSuppressed) {
            DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, false);
            throw new ReadOnlyFragmentModificationException(event, guard);
        }
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myGuardsSuppressed = true;
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myGuardsSuppressed = false;
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myEventsHandling;
    }

    public void clearLineModificationFlags() {
        this.myLineSet.clearModificationFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
        this.myChangeInProgress = true;
        DocumentEvent documentEvent = this.doBeforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
        DocumentEvent documentEvent2 = documentEvent;
        if (documentEvent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "beforeChangedUpdate"));
        }
        return documentEvent2;
        finally {
            this.myChangeInProgress = false;
        }
    }

    @NotNull
    private DocumentEvent doBeforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
        VirtualFile file;
        FileDocumentManager manager = FileDocumentManager.getInstance();
        if (manager != null && (file = manager.getFile(this)) != null && !file.isValid()) {
            LOG.error("File of this document has been deleted.");
        }
        DocumentEventImpl event = new DocumentEventImpl(this, offset, oldString, newString, this.myModificationStamp, wholeTextReplaced);
        if (!ShutDownTracker.isShutdownHookRunning()) {
            DocumentListener[] listeners = this.getCachedListeners();
            for (int i = listeners.length - 1; i >= 0; --i) {
                try {
                    listeners[i].beforeDocumentChange(event);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        this.myEventsHandling = true;
        DocumentEventImpl documentEventImpl = event;
        if (documentEventImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "doBeforeChangedUpdate"));
        }
        return documentEventImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changedUpdate(DocumentEvent event, long newModificationStamp) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug(event.toString());
            }
            this.myLineSet.changedUpdate(event);
            this.setModificationStamp(newModificationStamp);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                DocumentListener[] listeners;
                for (DocumentListener listener : listeners = this.getCachedListeners()) {
                    try {
                        listener.documentChanged(event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        finally {
            this.myEventsHandling = false;
        }
    }

    @Override
    public String getText() {
        return ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                return DocumentImpl.this.myText.toString();
            }
        });
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        CharSequence charSequence = this.myText.getCharArray();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCharsSequence"));
        }
        return charSequence;
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "addDocumentListener"));
        }
        if (this.myCachedDocumentListeners != null) {
            this.myCachedDocumentListeners.set(null);
        }
        LOG.assertTrue(!this.myDocumentListeners.contains(listener), "Already registered: " + listener);
        boolean added = this.myDocumentListeners.add(listener);
        LOG.assertTrue(added, listener);
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "removeDocumentListener"));
        }
        DocumentImpl.doRemoveDocumentListener(listener, this.myCachedDocumentListeners, this.myDocumentListeners);
    }

    private static void doRemoveDocumentListener(DocumentListener listener, Ref<DocumentListener[]> cachedDocumentListenersRef, List<DocumentListener> documentListeners) {
        boolean success;
        if (cachedDocumentListenersRef != null) {
            cachedDocumentListenersRef.set(null);
        }
        if (!(success = documentListeners.remove(listener))) {
            LOG.error("Can't remove document listener (" + listener + "). Registered cachedDocumentListenersRef: " + documentListeners);
        }
    }

    @Override
    public int getLineNumber(int offset) {
        return this.myLineSet.findLineIndex(offset);
    }

    @Override
    public final int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.myLineSet.getLineStart(line);
    }

    @Override
    public final int getLineCount() {
        int lineCount = this.myLineSet.getLineCount();
        assert (lineCount >= 0);
        return lineCount;
    }

    @NotNull
    private DocumentListener[] getCachedListeners() {
        DocumentListener[] cachedListeners = this.myCachedDocumentListeners.get();
        if (cachedListeners == null) {
            DocumentListener[] listeners = this.myDocumentListeners.toArray(new DocumentListener[this.myDocumentListeners.size()]);
            Arrays.sort(listeners, PrioritizedDocumentListener.COMPARATOR);
            cachedListeners = listeners;
            this.myCachedDocumentListeners.set(cachedListeners);
        }
        if (cachedListeners == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl", "getCachedListeners"));
        }
        return cachedListeners;
    }

    public void setCyclicBufferSize(int bufferSize) {
        this.myText.setBufferSize(bufferSize);
    }

    @Override
    public void setText(final @NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl", "setText"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DocumentImpl.this.replaceString(0, DocumentImpl.this.getTextLength(), text, LocalTimeCounter.currentTime(), true);
            }
        };
        if (CommandProcessor.getInstance().isUndoTransparentActionInProgress()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(null, runnable, "", DocCommandGroupId.noneGroupId(this));
        }
        this.clearLineModificationFlags();
    }

    @Override
    public final boolean isInBulkUpdate() {
        return this.myDoingBulkUpdate;
    }

    private class MyCharArray
    extends CharArray {
        private MyCharArray(@NotNull char[] chars, int length) {
            if (chars == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl$MyCharArray", "<init>"));
            }
            super(0, chars, length);
        }

        @Override
        @NotNull
        protected DocumentEvent beforeChangedUpdate(int offset, CharSequence oldString, CharSequence newString, boolean wholeTextReplaced) {
            DocumentEvent documentEvent = DocumentImpl.this.beforeChangedUpdate(offset, oldString, newString, wholeTextReplaced);
            if (documentEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/DocumentImpl$MyCharArray", "beforeChangedUpdate"));
            }
            return documentEvent;
        }

        @Override
        protected void afterChangedUpdate(@NotNull DocumentEvent event, long newModificationStamp) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/DocumentImpl$MyCharArray", "afterChangedUpdate"));
            }
            ((DocumentImpl)event.getDocument()).changedUpdate(event, newModificationStamp);
        }

        @Override
        protected void assertWriteAccess() {
            DocumentImpl.this.assertWriteAccess();
        }

        @Override
        protected void assertReadAccess() {
            Application application;
            if (DocumentImpl.this.myAssertThreading && (application = ApplicationManager.getApplication()) != null) {
                application.assertReadAccessAllowed();
            }
        }
    }
}

