/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.storage;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jet.Function0;
import jet.Function1;
import jet.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.storage.MemoizedFunctionToNotNull;
import org.jetbrains.jet.storage.MemoizedFunctionToNullable;
import org.jetbrains.jet.storage.NoLock;
import org.jetbrains.jet.storage.NotNullLazyValue;
import org.jetbrains.jet.storage.NullableLazyValue;
import org.jetbrains.jet.storage.StorageManager;
import org.jetbrains.jet.utils.ExceptionUtils;
import org.jetbrains.jet.utils.WrappedValues;

public class LockBasedStorageManager
implements StorageManager {
    public static final StorageManager NO_LOCKS = new LockBasedStorageManager(NoLock.INSTANCE){

        public String toString() {
            return "NO_LOCKS";
        }
    };
    protected final Lock lock;

    public LockBasedStorageManager() {
        this(new ReentrantLock());
    }

    private LockBasedStorageManager(@NotNull Lock lock) {
        if (lock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/jet/storage/LockBasedStorageManager", "<init>"));
        }
        this.lock = lock;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<K, V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        MemoizedFunctionToNotNull<K, V> memoizedFunctionToNotNull = this.createMemoizedFunction(compute, new ConcurrentHashMap());
        if (memoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        return memoizedFunctionToNotNull;
    }

    @NotNull
    protected <K, V> MemoizedFunctionToNotNull<K, V> createMemoizedFunction(@NotNull Function1<K, V> compute, @NotNull ConcurrentMap<K, Object> map) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        MapBasedMemoizedFunctionToNotNull<K, V> mapBasedMemoizedFunctionToNotNull = new MapBasedMemoizedFunctionToNotNull<K, V>(this.lock, map, compute);
        if (mapBasedMemoizedFunctionToNotNull == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunction"));
        }
        return mapBasedMemoizedFunctionToNotNull;
    }

    @Override
    @NotNull
    public <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<K, V> compute) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        MemoizedFunctionToNullable<K, V> memoizedFunctionToNullable = this.createMemoizedFunctionWithNullableValues(compute, new ConcurrentHashMap());
        if (memoizedFunctionToNullable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        return memoizedFunctionToNullable;
    }

    @NotNull
    protected <K, V> MemoizedFunctionToNullable<K, V> createMemoizedFunctionWithNullableValues(@NotNull Function1<K, V> compute, @NotNull ConcurrentMap<K, Object> map) {
        if (compute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        MapBasedMemoizedFunction<K, V> mapBasedMemoizedFunction = new MapBasedMemoizedFunction<K, V>(this.lock, map, compute);
        if (mapBasedMemoizedFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createMemoizedFunctionWithNullableValues"));
        }
        return mapBasedMemoizedFunction;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValue(@NotNull Function0<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "createLazyValue"));
        }
        LockBasedNotNullLazyValue<T> lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(this.lock, computable);
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createLazyValue"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createRecursionTolerantLazyValue(@NotNull Function0<T> computable, final @NotNull T onRecursiveCall) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "createRecursionTolerantLazyValue"));
        }
        if (onRecursiveCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onRecursiveCall", "org/jetbrains/jet/storage/LockBasedStorageManager", "createRecursionTolerantLazyValue"));
        }
        LockBasedNotNullLazyValue lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(this.lock, computable){

            @Override
            protected T recursionDetected(boolean firstTime) {
                return onRecursiveCall;
            }
        };
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createRecursionTolerantLazyValue"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NotNullLazyValue<T> createLazyValueWithPostCompute(@NotNull Function0<T> computable, final Function1<Boolean, T> onRecursiveCall, final @NotNull Function1<T, Unit> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCompute", "org/jetbrains/jet/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        LockBasedNotNullLazyValue lockBasedNotNullLazyValue = new LockBasedNotNullLazyValue<T>(this.lock, computable){

            @Override
            @Nullable
            protected T recursionDetected(boolean firstTime) {
                if (onRecursiveCall == null) {
                    return super.recursionDetected(firstTime);
                }
                return onRecursiveCall.invoke(firstTime);
            }

            @Override
            protected void postCompute(@NotNull T value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/storage/LockBasedStorageManager$3", "postCompute"));
                }
                postCompute.invoke(value);
            }
        };
        if (lockBasedNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createLazyValueWithPostCompute"));
        }
        return lockBasedNotNullLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValue(@NotNull Function0<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "createNullableLazyValue"));
        }
        LockBasedLazyValue<T> lockBasedLazyValue = new LockBasedLazyValue<T>(this.lock, computable);
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createNullableLazyValue"));
        }
        return lockBasedLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createRecursionTolerantNullableLazyValue(@NotNull Function0<T> computable, final T onRecursiveCall) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "createRecursionTolerantNullableLazyValue"));
        }
        LockBasedLazyValue lockBasedLazyValue = new LockBasedLazyValue<T>(this.lock, computable){

            @Override
            protected T recursionDetected(boolean firstTime) {
                return onRecursiveCall;
            }
        };
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createRecursionTolerantNullableLazyValue"));
        }
        return lockBasedLazyValue;
    }

    @Override
    @NotNull
    public <T> NullableLazyValue<T> createNullableLazyValueWithPostCompute(@NotNull Function0<T> computable, final @NotNull Function1<T, Unit> postCompute) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        if (postCompute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postCompute", "org/jetbrains/jet/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        LockBasedLazyValue lockBasedLazyValue = new LockBasedLazyValue<T>(this.lock, computable){

            @Override
            protected void postCompute(@Nullable T value) {
                postCompute.invoke(value);
            }
        };
        if (lockBasedLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager", "createNullableLazyValueWithPostCompute"));
        }
        return lockBasedLazyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T compute(@NotNull Function0<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager", "compute"));
        }
        this.lock.lock();
        try {
            T t = computable.invoke();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class MapBasedMemoizedFunctionToNotNull<K, V>
    extends MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNotNull<K, V> {
        public MapBasedMemoizedFunctionToNotNull(@NotNull Lock lock, @NotNull ConcurrentMap<K, Object> map, @NotNull Function1<K, V> compute) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            if (compute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "<init>"));
            }
            super(lock, map, compute);
        }

        @Override
        @NotNull
        public V invoke(K input) {
            Object result = super.invoke(input);
            assert (result != null) : "compute() returned null";
            Object v = result;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunctionToNotNull", "invoke"));
            }
            return v;
        }
    }

    private static class MapBasedMemoizedFunction<K, V>
    implements MemoizedFunctionToNullable<K, V> {
        private final Lock lock;
        private final ConcurrentMap<K, Object> cache;
        private final Function1<K, V> compute;

        public MapBasedMemoizedFunction(@NotNull Lock lock, @NotNull ConcurrentMap<K, Object> map, @NotNull Function1<K, V> compute) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            if (map == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            if (compute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compute", "org/jetbrains/jet/storage/LockBasedStorageManager$MapBasedMemoizedFunction", "<init>"));
            }
            this.lock = lock;
            this.cache = map;
            this.compute = compute;
        }

        @Override
        @Nullable
        public V invoke(K input) {
            Object value = this.cache.get(input);
            if (value != null) {
                return WrappedValues.unescapeExceptionOrNull(value);
            }
            this.lock.lock();
            try {
                value = this.cache.get(input);
                if (value != null) {
                    Object v = WrappedValues.unescapeExceptionOrNull(value);
                    return v;
                }
                V typedValue = this.compute.invoke(input);
                Object oldValue = this.cache.put(input, WrappedValues.escapeNull(typedValue));
                assert (oldValue == null) : "Race condition or recursion detected. Old value is " + oldValue;
                V v = typedValue;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class LockBasedNotNullLazyValue<T>
    extends LockBasedLazyValue<T>
    implements NotNullLazyValue<T> {
        public LockBasedNotNullLazyValue(@NotNull Lock lock, @NotNull Function0<T> computable) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/jet/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "<init>"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "<init>"));
            }
            super(lock, computable);
        }

        @Override
        @NotNull
        public T invoke() {
            Object result = super.invoke();
            assert (result != null) : "compute() returned null";
            Object t = result;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/storage/LockBasedStorageManager$LockBasedNotNullLazyValue", "invoke"));
            }
            return t;
        }
    }

    private static class LockBasedLazyValue<T>
    implements NullableLazyValue<T> {
        private final Lock lock;
        private final Function0<T> computable;
        @Nullable
        private volatile Object value;

        public LockBasedLazyValue(@NotNull Lock lock, @NotNull Function0<T> computable) {
            if (lock == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lock", "org/jetbrains/jet/storage/LockBasedStorageManager$LockBasedLazyValue", "<init>"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/jet/storage/LockBasedStorageManager$LockBasedLazyValue", "<init>"));
            }
            this.value = NotValue.NOT_COMPUTED;
            this.lock = lock;
            this.computable = computable;
        }

        @Override
        public boolean isComputed() {
            return this.value != NotValue.NOT_COMPUTED && this.value != NotValue.COMPUTING;
        }

        @Override
        public T invoke() {
            Object _value = this.value;
            if (!(this.value instanceof NotValue)) {
                return (T)WrappedValues.unescapeThrowable(_value);
            }
            this.lock.lock();
            try {
                T t;
                _value = this.value;
                if (!(_value instanceof NotValue)) {
                    Object v = WrappedValues.unescapeThrowable(_value);
                    return (T)v;
                }
                if (_value == NotValue.COMPUTING) {
                    this.value = NotValue.RECURSION_WAS_DETECTED;
                    T t2 = this.recursionDetected(true);
                    return t2;
                }
                if (_value == NotValue.RECURSION_WAS_DETECTED) {
                    T t3 = this.recursionDetected(false);
                    return t3;
                }
                this.value = NotValue.COMPUTING;
                try {
                    T typedValue = this.computable.invoke();
                    this.value = typedValue;
                    this.postCompute(typedValue);
                    t = typedValue;
                }
                catch (Throwable throwable) {
                    if (this.value == NotValue.COMPUTING) {
                        this.value = WrappedValues.escapeThrowable(throwable);
                    }
                    throw ExceptionUtils.rethrow(throwable);
                }
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Nullable
        protected T recursionDetected(boolean firstTime) {
            throw new IllegalStateException("Recursive call in a lazy value");
        }

        protected void postCompute(T value) {
        }

        private static enum NotValue {
            NOT_COMPUTED,
            COMPUTING,
            RECURSION_WAS_DETECTED;

        }
    }
}

