/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ConstraintPosition {
    public static final ConstraintPosition RECEIVER_POSITION = new ConstraintPosition("RECEIVER_POSITION", true);
    public static final ConstraintPosition EXPECTED_TYPE_POSITION = new ConstraintPosition("EXPECTED_TYPE_POSITION", true);
    public static final ConstraintPosition FROM_COMPLETER = new ConstraintPosition("FROM_COMPLETER", true);
    public static final ConstraintPosition SPECIAL = new ConstraintPosition("SPECIAL", true);
    private static final Map<Integer, ConstraintPosition> valueParameterPositions = Maps.newHashMap();
    private static final Map<Integer, ConstraintPosition> typeBoundPositions = Maps.newHashMap();
    private final String debugName;
    private final boolean isStrong;

    public static ConstraintPosition getValueParameterPosition(int index) {
        ConstraintPosition position = valueParameterPositions.get(index);
        if (position == null) {
            position = new ConstraintPosition("VALUE_PARAMETER_POSITION(" + index + ")", true);
            valueParameterPositions.put(index, position);
        }
        return position;
    }

    public static ConstraintPosition getTypeBoundPosition(int index) {
        ConstraintPosition position = typeBoundPositions.get(index);
        if (position == null) {
            position = new ConstraintPosition("TYPE_BOUND_POSITION(" + index + ")", false);
            typeBoundPositions.put(index, position);
        }
        return position;
    }

    public static ConstraintPosition getCompoundConstraintPosition(ConstraintPosition ... positions) {
        return new CompoundConstraintPosition(Lists.newArrayList(positions));
    }

    private ConstraintPosition(String name, boolean isStrong) {
        this.debugName = name;
        this.isStrong = isStrong;
    }

    public boolean isStrong() {
        return this.isStrong;
    }

    public String toString() {
        return this.debugName;
    }

    public static class CompoundConstraintPosition
    extends ConstraintPosition {
        private final Collection<ConstraintPosition> positions;

        public CompoundConstraintPosition(Collection<ConstraintPosition> positions) {
            super("COMPOUND_CONSTRAINT_POSITION", CompoundConstraintPosition.hasConstraint(positions, true));
            this.positions = positions;
        }

        public boolean consistsOfOnlyStrongConstraints() {
            return !CompoundConstraintPosition.hasConstraint(this.positions, false);
        }

        private static boolean hasConstraint(@NotNull Collection<ConstraintPosition> positions, final boolean strong) {
            if (positions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "positions", "org/jetbrains/jet/lang/resolve/calls/inference/ConstraintPosition$CompoundConstraintPosition", "hasConstraint"));
            }
            return ContainerUtil.exists(positions, new Condition<ConstraintPosition>(){

                @Override
                public boolean value(ConstraintPosition constraintPosition) {
                    return constraintPosition.isStrong() == strong;
                }
            });
        }
    }
}

