/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.scopes.receivers.AbstractReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public class AutoCastReceiver
extends AbstractReceiverValue {
    private final ReceiverValue original;
    private final boolean canCast;

    public AutoCastReceiver(@NotNull ReceiverValue original, @NotNull JetType castTo, boolean canCast) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastReceiver", "<init>"));
        }
        if (castTo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "castTo", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastReceiver", "<init>"));
        }
        super(castTo);
        this.original = original;
        this.canCast = canCast;
    }

    public boolean canCast() {
        return this.canCast;
    }

    @NotNull
    public ReceiverValue getOriginal() {
        ReceiverValue receiverValue = this.original;
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/autocasts/AutoCastReceiver", "getOriginal"));
        }
        return receiverValue;
    }

    public String toString() {
        return "(" + this.original + " as " + this.getType() + ")";
    }
}

